/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassComponent;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.Vector;

class RemoteInfo
extends Safeptr {
    int hashCollisionStringLength = -1;
    int nameOffset = -1;
    int HCSOffset = -1;
    int irio = -1;

    RemoteInfo(Safeptr safeptr) {
        super(safeptr);
    }

    int getRemoteMethodCount() {
        return this.u1(0);
    }

    Safeptr getRemoteMethodInfo(int n) {
        return this.offset(1 + 5 * n);
    }

    int getHCSOffset() {
        if (this.HCSOffset == -1) {
            this.HCSOffset = 1 + 5 * this.getRemoteMethodCount();
        }
        return this.HCSOffset;
    }

    int getHCSLength() {
        if (this.hashCollisionStringLength == -1) {
            this.hashCollisionStringLength = this.u1(this.getHCSOffset());
        }
        return this.hashCollisionStringLength;
    }

    int getClassNameOffset() {
        if (this.nameOffset == -1) {
            this.nameOffset = 1 + this.getHCSOffset() + this.getHCSLength();
        }
        return this.nameOffset;
    }

    int getClassNameLength() {
        return this.u1(this.getClassNameOffset());
    }

    Safeptr getName(int n) {
        return this.offset(n);
    }

    int getIRIO() {
        if (this.irio == -1) {
            this.irio = this.getClassNameOffset() + this.getClassNameLength() + 1;
        }
        return this.irio;
    }

    int getRemoteInterfaceCount() {
        return this.u1(this.getIRIO());
    }

    int findImplementedRemoteInterface(int n) {
        int n2 = this.getRemoteInterfaceCount();
        int n3 = this.getIRIO() + 1;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.u2(n3 + n4 * 2);
            if (n5 == n) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    int getRemoteDataLength() {
        int n = 0;
        n = 1 + 5 * this.getRemoteMethodCount();
        n += 1 + this.getHCSLength();
        n += 1 + this.getClassNameLength();
        return n += 1 + 2 * this.getRemoteInterfaceCount();
    }

    void verifyRemoteInfo(ClassDescriptor classDescriptor, ClassInfo classInfo) {
        String string = null;
        PackageInfo packageInfo = Cap.Header.thisPackage();
        ExportFile exportFile = ImportComponent.findExportByAidAndVersion(packageInfo);
        if (this.getHCSLength() > 0) {
            Safeptr safeptr = this.offset(this.getHCSOffset() + 1);
            byte[] byArray = new byte[this.getHCSLength()];
            int n = 0;
            while (n < this.getHCSLength()) {
                byArray[n] = (byte)safeptr.u1(n);
                ++n;
            }
            string = new String(byArray);
        }
        this.verifyRemoteMethodInfo(classInfo);
        this.verifyClassName(classInfo);
        this.verifyRemoteInterfacesForClass(classDescriptor);
    }

    Vector makeMasterRemoteMethodList(ClassInfo classInfo) {
        Vector<Integer> vector = new Vector<Integer>();
        ImplementedInterface implementedInterface = classInfo.firstImplementedInterface();
        int n = 0;
        while (n < classInfo.interfaceCount()) {
            Object object;
            boolean bl = false;
            int n2 = implementedInterface.interfaceImpl();
            if (!Classref.isExternal(n2)) {
                object = Cap.Class.infoOfs(implementedInterface.interfaceImpl());
                if ((((ClassInfo)object).flags() & 2) > 0) {
                    bl = true;
                }
            } else {
                object = Classref.checkExternal(implementedInterface.interfaceImpl());
                if ((((EfClass)object).accessFlag & 0x1000) > 0) {
                    bl = true;
                }
            }
            if (bl) {
                int n3;
                if (n2 != Classref.Remote && (n3 = this.findImplementedRemoteInterface(n2)) < 0) {
                    throw new VerifierError("RemoteInfoError.42");
                }
                int n4 = 0;
                while (n4 < implementedInterface.count()) {
                    int n5 = implementedInterface.indexMethod(n4);
                    if (this.findMethodWithToken(vector, n5) < 0) {
                        vector.add(new Integer(n5));
                    }
                    ++n4;
                }
            }
            ++n;
            implementedInterface.next();
        }
        return vector;
    }

    int findMethodWithToken(Vector vector, int n) {
        int n2 = 0;
        while (n2 < vector.size()) {
            int n3 = (Integer)vector.elementAt(n2);
            if (n3 == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void verifyRemoteMethodInfo(ClassInfo classInfo) {
        Vector vector = this.makeMasterRemoteMethodList(classInfo);
        int n = 0;
        int n2 = this.getRemoteMethodCount();
        if (n2 > 128 || n2 < 0) {
            throw new VerifierError("RemoteInfoError.12");
        }
        Vector<Integer> vector2 = new Vector<Integer>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Safeptr safeptr = this.getRemoteMethodInfo(n3);
            Integer n4 = new Integer(safeptr.u2(0));
            if (n > n4) {
                throw new VerifierError("RemoteInfoError.15");
            }
            if (vector2.indexOf(n4) != -1) {
                throw new VerifierError("RemoteInfoError.13");
            }
            n = n4;
            vector2.add(n4);
            int n5 = safeptr.u2(2);
            RemoteInfo.verifyRemoteMethodTypeDescr(Cap.Class.signaturePool.offset(n5));
            int n6 = safeptr.u1(4);
            MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(classInfo.ofs, n6, false);
            this.checkIfMethodIsRemote(Cap.Class.signaturePool.offset(n5), n6, classInfo);
            int n7 = this.findMethodWithToken(vector, n6);
            if (n7 < 0) {
                throw new VerifierError("RemoteInfoError.43");
            }
            vector.remove(n7);
            ++n3;
        }
        if (vector.size() > 0) {
            throw new VerifierError("RemoteInfoError.44");
        }
    }

    void checkIfMethodIsRemote(Safeptr safeptr, int n, ClassInfo classInfo) {
        while (classInfo != null) {
            int n2;
            int n3 = classInfo.interfaceCount();
            ImplementedInterface implementedInterface = classInfo.firstImplementedInterface();
            int n4 = 0;
            while (n4 < n3) {
                n2 = 0;
                while (n2 < implementedInterface.count()) {
                    int n5 = implementedInterface.indexMethod(n2);
                    if (n5 == n) {
                        if (!Classref.isExternal(implementedInterface.interfaceImpl())) {
                            this.checkInternalInterface(n2, safeptr, implementedInterface);
                        } else {
                            this.checkExternalInterface(n2, safeptr, implementedInterface, classInfo);
                        }
                        return;
                    }
                    ++n2;
                }
                ++n4;
                implementedInterface.next();
            }
            n2 = classInfo.superclass();
            if (n2 == 65535) {
                classInfo = null;
                continue;
            }
            if (Classref.isExternal(n2)) {
                this.checkExternalClass(n2, n);
                break;
            }
            classInfo = Cap.Class.infoOfs(n2);
        }
    }

    private void checkInternalInterface(int n, Safeptr safeptr, ImplementedInterface implementedInterface) {
        ClassInfo classInfo = Cap.Class.infoOfs(implementedInterface.interfaceImpl());
        ClassDescriptor classDescriptor = Classref.checkInternal(implementedInterface.interfaceImpl());
        if (!Classref.extendsInterface(classDescriptor.thisClass(), Classref.Remote) && (classInfo.flags() & 2) != 0) {
            throw new VerifierError("RemoteInfoError.26");
        }
        int n2 = 0;
        while (n2 < classDescriptor.methodCount()) {
            MethodDescriptor methodDescriptor = classDescriptor.methodDescr(n2);
            if (methodDescriptor.token() == n) {
                int n3 = methodDescriptor.type();
                Safeptr safeptr2 = Cap.TypeDescr.at(n3);
                if (this.matchDescriptors(safeptr, safeptr2)) {
                    return;
                }
                throw new VerifierError("RemoteInfoError.40");
            }
            ++n2;
        }
    }

    private void checkExternalInterface(int n, Safeptr safeptr, ImplementedInterface implementedInterface, ClassInfo classInfo) {
        EfClass efClass = Classref.checkExternal(implementedInterface.interfaceImpl());
        if ((efClass.accessFlag & 0x1000) == 0) {
            throw new VerifierError("RemoteInfoError.26");
        }
        int n2 = 0;
        while (n2 < efClass.methods.length) {
            EfMethod efMethod = efClass.methods[n2];
            if (efMethod.token == n) {
                boolean bl = (efMethod.accessFlag & 8) != 0 || efMethod.name().equals("<init>");
                MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(classInfo.ofs, efMethod.token, bl);
                if (methodTypeAndFlags == null) {
                    throw new VerifierError("ExportComponent.38");
                }
                TypeMethod typeMethod = TypeMethod.parseExport(efMethod.sig());
                TypeMethod typeMethod2 = TypeMethod.parseCap(safeptr);
                if (typeMethod2.equals(typeMethod)) {
                    return;
                }
            }
            ++n2;
        }
        throw new VerifierError("RemoteInfoError.27");
    }

    private void checkExternalClass(int n, int n2) {
        EfClass efClass;
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n3 = 0;
        int n4 = Classref.packageToken(n);
        ExportFile exportFile = Cap.Import.exportfileForPackageToken(n4);
        EfClass efClass2 = efClass = Classref.checkExternal(n);
        do {
            int n5 = 0;
            while (n5 < efClass.methods.length) {
                EfMethod efMethod = efClass.methods[n5];
                if (efMethod.token == n2) {
                    string = efMethod.name();
                    string2 = efMethod.sig();
                    bl = true;
                    break;
                }
                ++n5;
            }
            if (bl) {
                int n6 = 0;
                while (n6 < efClass.interfaces.length) {
                    EfClass efClass3 = exportFile.findClassByName(efClass.interfaceName(n6));
                    int n7 = 0;
                    while (n7 < efClass3.methods.length) {
                        EfMethod efMethod = efClass3.methods[n7];
                        if (string.equals(efMethod.name()) && string2.equals(efMethod.sig())) {
                            if ((efClass3.accessFlag & 0x1000) == 0) {
                                throw new VerifierError("RemoteInfoError.26");
                            }
                            return;
                        }
                        ++n7;
                    }
                    ++n6;
                }
            }
            if (efClass2.supers.length <= n3) {
                throw new VerifierError("RemoteInfoError.4");
            }
            efClass = exportFile.findClassByName(efClass.superName(n3++));
        } while (efClass != null);
    }

    private boolean matchDescriptors(Safeptr safeptr, Safeptr safeptr2) {
        int n;
        int n2 = safeptr.u1(0);
        if (n2 != (n = safeptr2.u1(0))) {
            return false;
        }
        int n3 = 2;
        while (n3 <= n2 + 1) {
            if (safeptr.nibble(n3) != safeptr2.nibble(n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static void verifyRemoteMethodTypeDescr(Safeptr safeptr) {
        int n;
        Safeptr safeptr2;
        int n2 = safeptr.u1(0);
        boolean bl = false;
        if (n2 >= 5) {
            safeptr2 = safeptr.offset(1);
            n = safeptr2.nibble(n2 - 5);
            if (n == 6) {
                Object object;
                int n3 = 0;
                int n4 = 1;
                while (n4 <= 4) {
                    n3 = n3 << 4 | safeptr2.nibble(n2 - 5 + n4);
                    ++n4;
                }
                if (!Classref.isExternal(n3)) {
                    object = Cap.Class.infoOfs(n3);
                    if ((((ClassInfo)object).flags() & 2) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                    if ((((ClassInfo)object).flags() & 8) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                } else {
                    object = Classref.checkExternal(n3);
                    if ((((EfClass)object).accessFlag & 0x1000) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                    if ((((EfClass)object).accessFlag & 0x200) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                }
                n2 -= 5;
                bl = true;
            } else if (n == 14) {
                throw new VerifierError("RemoteInfoError.19");
            }
        }
        safeptr2 = safeptr.offset(1);
        if (n2 == 0 && !bl) {
            throw new VerifierError("RemoteInfoError.25");
        }
        n = 0;
        while (n < n2) {
            switch (safeptr2.nibble(n)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    ++n;
                    break;
                }
                case 6: 
                case 14: {
                    throw new VerifierError("RemoteInfoError.20", null);
                }
                default: {
                    throw new VerifierError("RemoteInfoError.22", safeptr2.nibble(n), (Object)safeptr);
                }
            }
        }
        if (n > n2) {
            throw new VerifierError("RemoteInfoError.23", safeptr);
        }
        if (bl) {
            n2 += 5;
        }
        if ((n2 & 1) == 1 && safeptr2.nibble(n2) != 0) {
            throw new VerifierError("RemoteInfoError.24");
        }
    }

    void verifyClassName(ClassInfo classInfo) {
        String string;
        int n = this.getClassNameOffset() + 1;
        Safeptr safeptr = this.getName(n);
        int n2 = this.getClassNameLength();
        if (n2 > 0) {
            string = ClassInfo.getStringFromBytes(n2, safeptr);
            if (string.indexOf("/") > -1 || !EfNames.validClassName(string)) {
                throw new VerifierError("RemoteInfoError.11", string);
            }
            if (ClassComponent.classNamesVector.contains(string)) {
                throw new VerifierError("RemoteInfoError.14", string);
            }
        } else {
            throw new VerifierError("RemoteInfoError.10");
        }
        ClassComponent.classNamesVector.add(string);
    }

    void verifyRemoteInterfacesForClass(ClassDescriptor classDescriptor) {
        int n = this.getRemoteInterfaceCount();
        if (n > 128 || n < 0) {
            throw new VerifierError("RemoteInfoError.30");
        }
        int n2 = this.getIRIO() + 1;
        int n3 = 0;
        while (n3 < n) {
            Object object;
            int n4 = this.u2(n2 + n3 * 2);
            if (!Classref.isExternal(n4)) {
                object = Cap.Class.infoOfs(n4);
                if ((((ClassInfo)object).flags() & 2) == 0) {
                    throw new VerifierError("RemoteInfoError.45");
                }
            } else {
                object = Classref.checkExternal(n4);
                if ((((EfClass)object).accessFlag & 0x1000) == 0) {
                    throw new VerifierError("RemoteInfoError.45");
                }
            }
            if (!ClassComponent.classInfoImplementsInterface(classDescriptor.thisClass(), n4)) {
                throw new VerifierError("RemoteInfoError.31");
            }
            ++n3;
        }
    }

    static void verifyRemoteInterface(ClassDescriptor classDescriptor) {
        if ((classDescriptor.flags() & 1) != 1) {
            throw new VerifierError("RemoteInfoError.41");
        }
        int n = classDescriptor.methodCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = classDescriptor.methodDescr(n2).type();
            Safeptr safeptr = Cap.TypeDescr.at(n3);
            RemoteInfo.verifyRemoteMethodTypeDescr(safeptr);
            ++n2;
        }
    }
}

