/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FreeThread;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.LibraryRemover;
import com.izforge.izpack.util.NativeLibraryClient;
import com.izforge.izpack.util.TargetFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.StringCharacterIterator;
import java.util.Vector;

public class Librarian
implements CleanupClient {
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String TEMP_LOCATION_KEY = "java.io.tmpdir";
    private static final String CLIENT_EXTENSION = ".class";
    private static final String NATIVE = "native";
    private static final int BLOCK_SIZE = 4096;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static Librarian me = null;
    private Vector trackList = new Vector();
    private Vector clients = new Vector();
    private Vector libraryNames = new Vector();
    private Vector temporaryFileNames = new Vector();
    private String extension = "";
    private String nativeDirectory = "native";

    private Librarian() {
        Housekeeper.getInstance().registerForCleanup(this);
        this.extension = '.' + TargetFactory.getInstance().getNativeLibraryExtension();
    }

    public static Librarian getInstance() {
        if (me == null) {
            me = new Librarian();
        }
        return me;
    }

    public synchronized void loadLibrary(String name, NativeLibraryClient client) throws Exception {
        String libraryName = this.strip(name);
        String tempFileName = "";
        if (this.loaded(libraryName)) {
            return;
        }
        if (System.getProperty("DLL_PATH") != null) {
            String path = System.getProperty("DLL_PATH") + "/" + name + this.extension;
            path = path.replace('/', File.separatorChar);
            Debug.trace("Try to load library " + path);
            System.load(path);
            return;
        }
        try {
            System.loadLibrary(libraryName);
            return;
        }
        catch (UnsatisfiedLinkError exception) {
        }
        catch (SecurityException exception) {
            // empty catch block
        }
        Class<?> clientClass = client.getClass();
        String resourceName = clientClass.getName();
        int nameStart = resourceName.lastIndexOf(46) + 1;
        resourceName = resourceName.substring(nameStart, resourceName.length()) + CLIENT_EXTENSION;
        URL url = clientClass.getResource(resourceName);
        if (url == null) {
            throw new Exception("can't identify load protocol for " + libraryName + this.extension);
        }
        String protocol = url.getProtocol();
        if (protocol.equalsIgnoreCase(FILE_PROTOCOL)) {
            try {
                System.load(this.getClientPath(name, url));
            }
            catch (Throwable exception) {
                try {
                    System.load(this.getNativePath(name, client));
                }
                catch (Throwable exception2) {
                    throw new Exception("error loading library");
                }
            }
        } else if (protocol.equalsIgnoreCase(JAR_PROTOCOL)) {
            tempFileName = this.getTempFileName(libraryName);
            try {
                this.extractFromJar(libraryName, tempFileName, client);
                this.clients.add(client);
                this.temporaryFileNames.add(tempFileName);
                this.libraryNames.add(tempFileName.substring(tempFileName.lastIndexOf(File.separatorChar) + 1, tempFileName.length()));
                System.load(tempFileName);
            }
            catch (Throwable exception) {
                throw new Exception("error loading library\n" + exception.toString());
            }
        }
    }

    private boolean loaded(String name) {
        if (this.trackList.contains(name)) {
            return true;
        }
        this.trackList.add(name);
        return false;
    }

    private String strip(String name) {
        int extensionStart = name.lastIndexOf(46);
        int nameStart = name.lastIndexOf(47);
        if (nameStart < 0) {
            nameStart = name.lastIndexOf(92);
        }
        String shortName = extensionStart > 0 ? name.substring(nameStart, extensionStart) : name.substring(++nameStart, name.length());
        return shortName;
    }

    private void extractFromJar(String name, String destination, NativeLibraryClient client) throws Exception {
        int bytesRead = 0;
        FileOutputStream output = null;
        InputStream input = this.openInputStream(name, client);
        try {
            output = new FileOutputStream(destination);
        }
        catch (FileNotFoundException exception) {
            input.close();
            throw new Exception("can't create destination file");
        }
        catch (SecurityException exception) {
            input.close();
            throw new Exception("creation of destination file denied");
        }
        catch (Throwable exception) {
            input.close();
            throw new Exception("unknown problem creating destination file\n" + exception.toString());
        }
        byte[] buffer = new byte[4096];
        try {
            do {
                if ((bytesRead = input.read(buffer)) <= 0) continue;
                ((OutputStream)output).write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
        }
        catch (Throwable exception) {
            throw new Exception("error writing to destination file\n" + exception.toString());
        }
        finally {
            input.close();
            output.flush();
            ((OutputStream)output).close();
        }
    }

    private String getClientPath(String name, URL clientURL) {
        String path = clientURL.getFile();
        int nameStart = path.lastIndexOf(47) + 1;
        path = path.substring(0, nameStart);
        path = path + name + this.extension;
        path = path.replace('/', File.separatorChar);
        path = this.revisePath(path);
        return path;
    }

    private String getNativePath(String name, NativeLibraryClient client) {
        ProtectionDomain domain = client.getClass().getProtectionDomain();
        CodeSource codeSource = domain.getCodeSource();
        URL url = codeSource.getLocation();
        String path = url.getPath();
        path = path + this.nativeDirectory + '/' + name + this.extension;
        path = path.replace('/', File.separatorChar);
        path = this.revisePath(path);
        return path;
    }

    private String revisePath(String in) {
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(in);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c2 = iter.next();
                    if (c2 != '\uffff') {
                        int i2 = Character.digit(c2, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        String path = sb.toString();
        return path;
    }

    private InputStream openInputStream(String name, NativeLibraryClient client) throws Exception {
        Class<?> clientClass = client.getClass();
        InputStream input = clientClass.getResourceAsStream(name + this.extension);
        if (input == null) {
            input = clientClass.getResourceAsStream('/' + this.nativeDirectory + '/' + name + this.extension);
        }
        if (input == null) {
            throw new Exception("can't locate library");
        }
        return input;
    }

    private String getTempFileName(String name) {
        StringBuffer fileName = new StringBuffer();
        String path = System.getProperty(TEMP_LOCATION_KEY);
        if (path.charAt(path.length() - 1) == File.separatorChar) {
            path = path.substring(0, path.length() - 1);
        }
        String modifier = "";
        int counter = 0;
        File file = null;
        do {
            fileName.delete(0, fileName.length());
            fileName.append(path);
            fileName.append(File.separatorChar);
            fileName.append(name);
            fileName.append(modifier);
            fileName.append(this.extension);
            modifier = Integer.toString(counter);
            ++counter;
        } while ((file = new File(fileName.toString())).exists());
        return fileName.toString();
    }

    public void setNativeDirectory(String directory) {
        this.nativeDirectory = directory == null ? "" : directory;
    }

    public void cleanUp() {
        if ((double)JAVA_SPECIFICATION_VERSION < 1.5) {
            this.oldCleanUp();
        } else {
            this.newCleanUp();
        }
    }

    private void oldCleanUp() {
        for (int i = 0; i < this.clients.size(); ++i) {
            NativeLibraryClient client = (NativeLibraryClient)this.clients.elementAt(i);
            String libraryName = (String)this.libraryNames.elementAt(i);
            FreeThread free = new FreeThread(libraryName, client);
            free.start();
            try {
                free.join(50L);
            }
            catch (Throwable exception) {
                // empty catch block
            }
            String tempFileName = (String)this.temporaryFileNames.elementAt(i);
            try {
                File file = new File(tempFileName);
                file.delete();
                continue;
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
    }

    private void newCleanUp() {
        try {
            LibraryRemover.invoke(this.temporaryFileNames);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

