/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class TLP224Message {
    public static final int EOT = 3;
    public static final int ACK = 96;
    public static final int NACK = 224;
    public static final int POWER_DOWN = 77;
    public static final int POWER_UP = 110;
    public static final int ISO_INPUT = 218;
    public static final int ISO_OUTPUT = 219;
    static final int OFFSET_CLA = 3;
    static final int OFFSET_INS = 4;
    static final int OFFSET_P1 = 5;
    static final int OFFSET_P2 = 6;
    static final int OFFSET_P3 = 7;
    static final int OFFSET_DATA_IN = 8;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_INCORRECT_NUMBER_OF_ARGS = 3;
    public static final int STATUS_COMMAND_UNKNOWN = 4;
    public static final int STATUS_PROTOCOL_ERROR = 9;
    public static final int STATUS_ISO_CMD_ERROR = 17;
    public static final int STATUS_MESSAGE_TOO_LONG = 18;
    public static final int STATUS_CARD_TURNED_OFF = 21;
    public static final int STATUS_UNKNOWN_PROTOCOL = 23;
    public static final int STATUS_ISO_LC_ERROR = 26;
    public static final int STATUS_CARD_PROTOCOL_ERROR = 161;
    public static final int STATUS_CARD_MALFUNCTION = 162;
    public static final int STATUS_CARD_ABORTED_CHAINING = 164;
    public static final int STATUS_READER_ABORTED_CHAINING = 165;
    public static final int STATUS_INVALID_PROCEDURE_BYTE = 228;
    public static final int STATUS_INTERRUPTED_EXCHANGE = 229;
    public static final int STATUS_CARD_ERROR = 231;
    public static final int STATUS_CARD_REMOVED = 247;
    public static final int STATUS_CARD_MISSING = 251;
    public static final int MAX_MESSAGE_LEN = 258;
    private byte[] buf;
    private int len;
    ByteArrayInputStream dataIn;
    ByteArrayOutputStream dataOut;

    TLP224Message() {
        this.buf = new byte[258];
        this.len = 0;
    }

    TLP224Message(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        this.buf = byArray;
        this.len = 0;
    }

    byte[] getData() {
        return this.buf;
    }

    int getLength() {
        return this.len;
    }

    void setData(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        this.buf = byArray;
    }

    public void setLength(int n) {
        if (n > this.buf.length) {
            throw new IllegalArgumentException();
        }
        this.len = n;
    }

    int computeLRC(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 ^= this.buf[n3];
            ++n3;
        }
        return n2 & 0xFF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.len <= 0) {
            return "";
        }
        if (this.buf[0] == 96) {
            stringBuffer.append("<ACK>");
        } else if (this.buf[0] == -32) {
            stringBuffer.append("<NACK>");
        } else {
            stringBuffer.append("<" + Integer.toHexString(this.buf[0] & 0xFF) + ">");
        }
        int n = 1;
        while (n < this.len) {
            if ((this.buf[n] & 0xFF) <= 15) {
                stringBuffer.append(", 0");
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Integer.toHexString(this.buf[n] & 0xFF));
            ++n;
        }
        return stringBuffer.toString();
    }
}

