/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.sun.javacard.impl.NativeMethods;
import java.io.PrintStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class Throwable {
    private String detailMessage;
    private transient Object backtrace;

    public Throwable() {
    }

    public Throwable(String message) {
        if (message != null) {
            this.detailMessage = new String(message);
            NativeMethods.setGloballyAccessible(this.detailMessage);
        } else {
            this.detailMessage = null;
        }
    }

    public String getMessage() {
        if (this.detailMessage == null) {
            return null;
        }
        if (!NativeMethods.isGloballyAccessible(this)) {
            return this.detailMessage;
        }
        short currentContext = NativeMethods.getCurrentContext();
        byte currentAppId = NativeMethods.getCurrentAppId();
        NativeMethods.switchContext(0, 0);
        String message = new String(this.detailMessage);
        NativeMethods.transferOwnershipToPreviousContext(message);
        NativeMethods.switchContext(currentContext, currentAppId);
        return message;
    }

    public String toString() {
        String s = this.getClass().getName();
        if (!NativeMethods.isGloballyAccessible(this)) {
            String finalStrRepresentation = this.detailMessage != null ? s + ": " + this.detailMessage : s;
            return finalStrRepresentation;
        }
        short currentContext = NativeMethods.getCurrentContext();
        byte currentAppId = NativeMethods.getCurrentAppId();
        NativeMethods.switchContext(0, 0);
        String finalStrRepresentation = this.detailMessage != null ? s + ": " + this.detailMessage : s;
        NativeMethods.transferOwnershipToPreviousContext(finalStrRepresentation);
        NativeMethods.switchContext(currentContext, currentAppId);
        return finalStrRepresentation;
    }

    public void printStackTrace() {
        PrintStream err = System.err;
        String message = this.getMessage();
        err.print(this.getClass().getName());
        if (message != null) {
            err.print(": ");
            err.println(message);
        } else {
            err.println();
        }
        if (this.backtrace != null) {
            this.printStackTrace0(System.err);
        }
    }

    private native void printStackTrace0(Object var1);
}

