/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.sun.javacard.impl.JCCryptoAccessor;
import javacard.security.CryptoException;
import javacard.security.PrivateKey;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class KeyAgreement {
    public static final String SERVICE_NAME = "keyAgreement";
    public static final byte ALG_EC_SVDP_DH = 1;
    public static final byte ALG_EC_SVDP_DH_KDF = 1;
    public static final byte ALG_EC_SVDP_DHC = 2;
    public static final byte ALG_EC_SVDP_DHC_KDF = 2;
    public static final byte ALG_EC_SVDP_DH_PLAIN = 3;
    public static final byte ALG_EC_SVDP_DHC_PLAIN = 4;
    private static JCCryptoAccessor cryptoAccessorInstance = JCCryptoAccessor.getInstance();

    protected KeyAgreement() {
    }

    public static final KeyAgreement getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        switch (algorithm) {
            case 1: {
                return KeyAgreement.getInstance("EC_SVDP_DH_KDF", externalAccess);
            }
            case 2: {
                return KeyAgreement.getInstance("EC_SVDP_DHC_KDF", externalAccess);
            }
            case 3: {
                return KeyAgreement.getInstance("EC_SVDP_DH_PLAIN", externalAccess);
            }
            case 4: {
                return KeyAgreement.getInstance("EC_SVDP_DHC_PLAIN", externalAccess);
            }
        }
        CryptoException.throwIt((short)3);
        return null;
    }

    public static final KeyAgreement getInstance(String algorithm, boolean externalAccess) throws CryptoException {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (KeyAgreement)o;
    }

    public static final KeyAgreement getInstance(String algorithm, String provider, boolean externalAccess) throws CryptoException {
        if (algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider, externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (KeyAgreement)o;
    }

    public abstract void init(PrivateKey var1) throws CryptoException;

    public abstract byte getAlgorithm();

    public abstract String getAlgorithmName();

    public abstract short generateSecret(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;
}

