/*
 * Decompiled with CFR 0.152.
 */
package javacardx.facilities;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcre.TaskRegistryAccessor;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Vector;
import javacardx.facilities.TaskRegistryPermission;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class TaskRegistry {
    private static TaskRegistry taskRegistry = new TaskRegistry();
    private TaskRegistryAccessor taskRegistryAccessor = TaskRegistryAccessor.getTaskRegistryAccessor();

    public static final TaskRegistry getTaskRegistry() {
        return taskRegistry;
    }

    private TaskRegistry() {
    }

    public void register(Runnable task) {
        if (task != null) {
            NativeMethods.checkPreviousContextAccess(task);
        }
        this.doRegister(task, false);
    }

    public void register(Runnable task, boolean eager) {
        if (task != null) {
            NativeMethods.checkPreviousContextAccess(task);
        }
        this.doRegister(task, eager);
    }

    private void doRegister(Runnable task, boolean eager) {
        int objectContext;
        AccessController.checkPermission(new TaskRegistryPermission("task.register"));
        if (task == null) {
            throw new NullPointerException();
        }
        byte previousContext = NativeMethods.getPreviousContext();
        if (previousContext != (objectContext = NativeMethods.objectContext(task))) {
            throw new SecurityException();
        }
        this.taskRegistryAccessor.register(task, eager);
    }

    public Enumeration<Runnable> list() {
        byte previousContext = NativeMethods.getPreviousContext();
        Vector<Runnable> v = new Vector<Runnable>();
        NativeMethods.transferOwnershipToPreviousContext(v);
        Enumeration<Runnable> enumeration = this.taskRegistryAccessor.list();
        while (enumeration.hasMoreElements()) {
            Runnable runnable = enumeration.nextElement();
            int objectContext = NativeMethods.objectContext(runnable);
            if (previousContext != objectContext) continue;
            v.addElement(runnable);
        }
        return v.elements();
    }

    public void unregister(Runnable task) {
        if (task != null) {
            NativeMethods.checkPreviousContextAccess(task);
        }
        this.doUnregister(task, false);
    }

    public void unregister(Runnable task, boolean eager) {
        if (task != null) {
            NativeMethods.checkPreviousContextAccess(task);
        }
        this.doUnregister(task, eager);
    }

    private void doUnregister(Runnable task, boolean eager) {
        int objectContext;
        AccessController.checkPermission(new TaskRegistryPermission("task.unregister"));
        if (task == null) {
            throw new NullPointerException();
        }
        byte previousContext = NativeMethods.getPreviousContext();
        if (previousContext != (objectContext = NativeMethods.objectContext(task))) {
            throw new SecurityException();
        }
        this.taskRegistryAccessor.unregister(task, eager);
    }

    static {
        NativeMethods.setJCREentry(taskRegistry, false);
    }
}

