/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.bio;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.microedition.io.Connector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.WebServer;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class SocketConnector
extends AbstractConnector {
    protected ServerSocketConnection serverSocketConnection;
    protected Vector<Connection> connections;

    @Override
    public Object getConnection() {
        return null;
    }

    @Override
    public void open() throws IOException {
        Logger.debug("SocketConnector.open -> ");
        this.serverSocketConnection = (ServerSocketConnection)Connector.open("socket://:" + this.getPort());
        Logger.debug("SocketConnector.open -> DONE");
    }

    @Override
    public void close() throws IOException {
        if (this.serverSocketConnection != null) {
            this.serverSocketConnection.close();
        }
        this.serverSocketConnection = null;
    }

    @Override
    public void accept(int acceptorID) throws IOException {
        Logger.debug("jetty.bio.SocketConnector.accept() -> Waiting for connection");
        SocketConnection socket = (SocketConnection)this.serverSocketConnection.acceptAndOpen();
        Logger.debug("jetty.bio.SocketConnector.accept() -> Client request came.");
        this.configure(socket);
        Connection connection = new Connection(socket);
        connection.dispatch();
        Logger.debug("jetty.bio.SocketConnector.accept() -> Client dispatched");
    }

    @Override
    protected Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    @Override
    public void customize(EndPoint endpoint, Request request) throws IOException {
        Connection connection = (Connection)endpoint;
        if (connection._sotimeout != this.maxIdleTime) {
            connection._sotimeout = this.maxIdleTime;
        }
        super.customize(endpoint, request);
    }

    @Override
    public int getLocalPort() {
        if (this.serverSocketConnection == null) {
            return -1;
        }
        try {
            return this.serverSocketConnection.getLocalPort();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getLocalHostAddress() {
        try {
            return this.serverSocketConnection.getLocalAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0.0.0.0";
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.connections = new Vector();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (Connection connection : this.connections) {
            connection.close();
        }
    }

    @Override
    public void reset() {
        try {
            this.doStart();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class Connection
    extends SocketEndPoint
    implements Runnable {
        boolean _dispatched;
        HttpConnection _connection;
        int _sotimeout;
        SocketConnection _socket;

        public Connection(SocketConnection socket) throws IOException {
            super(socket);
            this._dispatched = false;
            this._connection = new HttpConnection(SocketConnector.this, this, WebServer.getWebServer(), socket);
            this._socket = socket;
        }

        public void dispatch() throws IOException {
            if (!SocketConnector.this.getThreadPool().dispatch(this)) {
                Logger.debug("dispatch failed for {}" + this._connection);
                super.close();
            }
        }

        @Override
        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                super.close();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SocketConnector.this.connectionOpened(this._connection);
                SocketConnector.this.connections.addElement(this);
                while (SocketConnector.this.isStarted() && !this.isClosed()) {
                    int lrmit;
                    if (this._connection.isIdle() && WebServer.getWebServer().getThreadPool().isLowOnThreads() && (lrmit = SocketConnector.this.getLowResourceMaxIdleTime()) >= 0 && this._sotimeout != lrmit) {
                        this._sotimeout = lrmit;
                    }
                    Logger.debug("jetty.bio.SocketConnector.run() -> handling()");
                    this._connection.handle();
                }
            }
            catch (EofException e) {
                try {
                    super.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            catch (HttpException e) {
                try {
                    super.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            catch (Throwable e) {
                try {
                    super.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                SocketConnector.this.connectionClosed(this._connection);
                SocketConnector.this.connections.removeElement(this);
            }
        }
    }
}

