/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;

public class Methodref {
    public static ClassAndMethodDescriptor findDescr(int ofs) {
        ClassDescriptor c = Cap.Descriptor.firstClassDescriptor();
        for (int i = Cap.Descriptor.classCount(); i > 0; --i) {
            for (int j = 0; j < c.methodCount(); ++j) {
                MethodDescriptor m = c.methodDescr(j);
                if (m.methodOffset() != ofs) continue;
                return new ClassAndMethodDescriptor(c, m);
            }
            c.next();
        }
        throw new VerifierError("Methodref.1", ofs);
    }

    public static ClassAndMethodDescriptor checkInternalStaticRef(int ofs) {
        ClassAndMethodDescriptor cm = Methodref.findDescr(ofs);
        if ((cm.methodDescr.flags() & 8) == 0) {
            throw new VerifierError("Methodref.2", ofs);
        }
        return cm;
    }

    public static MethodTypeAndFlags findByToken(int cls, int token, boolean isStatic) {
        Object c;
        while (!Classref.isExternal(cls)) {
            c = Classref.checkInternal(cls);
            for (int j = 0; j < ((ClassDescriptor)c).methodCount(); ++j) {
                MethodDescriptor m = ((ClassDescriptor)c).methodDescr(j);
                if (token != m.token() || isStatic != ((m.flags() & 0x88) != 0)) continue;
                boolean found = false;
                if (!isStatic && (Cap.Class.infoOfs(cls).flags() & 8) == 0) {
                    ClassInfo ci = Cap.Class.infoOfs(cls);
                    if ((m.flags() & 4) != 0 || (m.flags() & 1) != 0) {
                        if (ci.publicMethodWithOffsetExists(m.methodOffset())) {
                            found = true;
                        }
                    } else if ((m.flags() & 2) == 0 && ci.packageMethodWithOffsetExists(m.methodOffset())) {
                        found = true;
                    }
                } else {
                    found = true;
                }
                if (!found) continue;
                return new MethodTypeAndFlags(Cap.TypeDescr.at(m.type()), m.flags(), m.methodOffset());
            }
            if ((Cap.Class.infoOfs(cls).flags() & 8) != 0) {
                return null;
            }
            if (isStatic) {
                return null;
            }
            cls = Cap.Class.infoOfs(cls).superclass();
        }
        if (cls == 65535) {
            return null;
        }
        c = Classref.checkExternal(cls);
        for (EfMethod m : ((EfClass)c).methods) {
            if (token != m.token || isStatic != ((m.accessFlag & 8) != 0 || m.name().equals("<init>"))) continue;
            return new MethodTypeAndFlags(m);
        }
        return null;
    }

    public static MethodDescriptor virtualMethodDescriptor(ClassDescriptor cdesc, int token) {
        for (int i = 0; i < cdesc.methodCount(); ++i) {
            MethodDescriptor m = cdesc.methodDescr(i);
            if ((m.flags() & 0x88) != 0 || m.token() != token) continue;
            return m;
        }
        return null;
    }
}

