/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.scriptgen;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.scriptgen.CAP;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Main {
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static String pkgName;
    private static String capPath;
    private static String scriptPath;
    private static boolean nobanner;
    private static boolean noBeginEnd;
    private static PrintWriter scriptWriter;
    private static PrintWriter logWriter;
    private static ResourceBundle msg;

    public static void main(String[] args) {
        try {
            if (Main.parseArgs(args) == 0) {
                Main.processCAP(capPath);
            }
            Main.terminate();
        }
        catch (Exception e) {
            System.exit(1);
        }
        System.exit(0);
    }

    private static void processCAP(String path) {
        CAP cap = null;
        try {
            cap = new CAP(path, logWriter, msg, pkgName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (cap.verifyCAP() == 0) {
            cap.genScript(scriptWriter, noBeginEnd);
        }
        if (!nobanner) {
            System.out.println(msg.getString("Main.02"));
        }
    }

    static int parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o") && args.length > i + 1) {
                scriptPath = args[++i];
                continue;
            }
            if (args[i].equals("-package") && args.length > i + 1) {
                pkgName = args[++i];
                continue;
            }
            if (args[i].equals("-help")) {
                Main.usage();
                return 1;
            }
            if (args[i].equals("-version")) {
                Main.banner();
                return 1;
            }
            if (args[i].equals("-nobanner")) {
                nobanner = true;
                continue;
            }
            if (args[i].equals("-nobeginend")) {
                noBeginEnd = true;
                continue;
            }
            if (args[i].startsWith("-")) {
                Object[] msgArgs = new Object[]{args[i]};
                logWriter.println(MessageFormat.format(msg.getString("Main.badArg"), msgArgs));
                Main.banner();
                return 1;
            }
            capPath = args[i];
        }
        if (capPath == null) {
            logWriter.println(msg.getString("Main.capPath"));
            Main.usage();
            return 1;
        }
        try {
            File f = new File(capPath);
            if (!f.canRead()) {
                Object[] msgArgs = new Object[]{capPath};
                logWriter.println(MessageFormat.format(msg.getString("Main.access"), msgArgs));
                return 1;
            }
        }
        catch (Exception e) {
            logWriter.println(e);
            return 1;
        }
        if (scriptPath != null) {
            try {
                scriptWriter = new PrintWriter(new FileOutputStream(scriptPath));
            }
            catch (Exception e) {
                logWriter.println(e);
                return 1;
            }
        }
        Main.banner();
        return 0;
    }

    static void terminate() {
        logWriter.flush();
        scriptWriter.flush();
    }

    private static void usage() {
        logWriter.println(msg.getString("Main.10"));
        logWriter.println(msg.getString("Main.11"));
        for (int i = 12; i < 18; ++i) {
            logWriter.println(msg.getString("Main." + i));
        }
    }

    private static void banner() {
        if (nobanner) {
            return;
        }
        System.out.println(ToolsVersion.getToolName(3) + ToolsVersion.getVersion(3));
        System.out.println(ToolsVersion.getCopyrightBanner());
    }

    static {
        scriptWriter = new PrintWriter(System.out, true);
        logWriter = new PrintWriter(System.err, true);
        msg = ResourceBundle.getBundle("com/sun/javacard/scriptgen/MessagesBundle");
    }
}

