/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.ParseException;
import com.sun.javacard.jcasm.Parser;
import com.sun.javacard.jcasm.cap.CapFile;
import com.sun.javacard.jcasm.cap.CapLinker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CapgenWrapper {
    public static void generateCAPFile(ConversionProfile cp) {
        ConversionProfile conversion_profile = cp;
        File output_file = null;
        File input_file = null;
        Globals.mode = 1;
        String jca_file_name = Names.getJcaFileName(conversion_profile.package_profile.package_name);
        input_file = new File(conversion_profile.getFullOutputPath(), jca_file_name);
        String cap_file_name = Names.getCAPFileName(conversion_profile.package_profile.package_name);
        output_file = new File(conversion_profile.getFullOutputPath(), cap_file_name);
        Parser parser = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(input_file));
            parser = new Parser(bis);
            Parser.inputSpec = input_file.getAbsolutePath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] arguments = new Object[]{input_file.getName()};
            Msg.error("main.16", arguments);
            String dir = conversion_profile.getFullOutputPath().getAbsolutePath();
            Notifier.error("error.2", dir);
            System.exit(1);
        }
        JCPackage pack = null;
        try {
            pack = Parser.PackageDeclaration();
        }
        catch (ParseException e) {
            System.err.println(e);
            ++Globals.errors;
        }
        CapFile cap = null;
        if (Globals.errors == 0) {
            cap = new CapFile(pack);
        }
        if (Globals.errors == 0) {
            CapLinker.link(pack);
        }
        if (Globals.errors == 0) {
            try {
                cap.gen(output_file);
            }
            catch (IOException e) {
                System.err.println(e);
                ++Globals.errors;
            }
        }
        if (Globals.errors != 0) {
            output_file.delete();
            Notifier.newLine();
            String dir = conversion_profile.getFullOutputPath().getAbsolutePath();
            Notifier.error("error.2", dir);
            Object[] arguments = new Object[]{String.valueOf(Globals.errors), String.valueOf(Globals.warnings)};
            Notifier.out("out.1", arguments);
            System.exit(1);
        }
    }
}

