/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfConstantPackage;
import com.sun.javacard.exportfile.EfConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;

public class EfExportFile
extends PackageDefinition {
    public static byte APPLET_PACKAGE = 0;
    public static byte LIBRARY_PACKAGE = 1;
    private int magic = 16435934;
    private byte major_version;
    private byte minor_version;
    private byte flags;
    private EfConstantPool constant_pool;
    private int this_package_index;
    private EfClass[] classes;

    public EfExportFile() {
    }

    public EfExportFile(byte major_version, byte minor_version, byte flags, PackageDefinition a_package, EfConstantPool cp, EfClass[] classes) {
        super(a_package);
        this.major_version = major_version;
        this.minor_version = minor_version;
        this.flags = flags;
        this.classes = classes;
        this.constant_pool = cp;
        this.this_package_index = this.constant_pool.addConstantPackage(a_package, flags);
    }

    public void parse(DataInputStream dis) throws IOException {
        this.magic = dis.readInt();
        this.minor_version = dis.readByte();
        this.major_version = dis.readByte();
        this.constant_pool = new EfConstantPool();
        this.constant_pool.parse(dis);
        this.this_package_index = dis.readUnsignedShort();
        this.classes = new EfClass[dis.readUnsignedByte()];
        for (int i = 0; i < this.classes.length; ++i) {
            EfClass export_class = new EfClass(this.constant_pool);
            export_class.parse(dis);
            this.classes[i] = export_class;
        }
        try {
            dis.readByte();
            throw new StreamCorruptedException();
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public void resolve() {
        this.constant_pool.resolve();
        EfConstantPackage constant = this.constant_pool.getConstantPackage(this.this_package_index);
        this.package_name = constant.getPackageName();
        this.package_minor_version = constant.getMinorVersion();
        this.package_major_version = constant.getMajorVersion();
        this.aid = constant.getAID();
        for (int i = 0; i < this.classes.length; ++i) {
            this.classes[i].resolve();
        }
    }

    public int getMagic() {
        return this.magic;
    }

    public byte getMinorVersion() {
        return this.minor_version;
    }

    public byte getMajorVersion() {
        return this.major_version;
    }

    public int getThisPackageIndex() {
        return this.this_package_index;
    }

    public EfConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public EfClass[] getClasses() {
        return this.classes;
    }

    public EfClass getClass(String name) {
        for (int i = 0; i < this.classes.length; ++i) {
            if (!this.classes[i].getClassName().equals(name)) continue;
            return this.classes[i];
        }
        return null;
    }

    public EfClass getClass(int token) {
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i].getClassToken() != token) continue;
            return this.classes[i];
        }
        return null;
    }

    public void toText(PrintWriter pw) throws IOException {
        int tab_level = 1;
        String indent = new String("\t");
        pw.println("export file {\t\t// " + this.package_name);
        pw.println(indent + "magic\t" + Strings.toHexString(this.magic) + "\t\t // in hex");
        pw.println(indent + "minor_version\t" + this.minor_version);
        pw.println(indent + "major_version\t" + this.major_version);
        pw.println(indent + "constant_pool_count\t" + this.constant_pool.getSize());
        pw.println(indent + "constant_pool {");
        this.constant_pool.toText(pw, tab_level + 1);
        pw.println(indent + "}");
        pw.println(indent + "this_package\t" + this.this_package_index);
        pw.println(indent + "export_class_count\t" + this.classes.length);
        pw.println(indent + "export_classes {");
        for (int i = 0; i < this.classes.length; ++i) {
            this.classes[i].toText(pw, tab_level + 1);
        }
        pw.println(indent + "}");
        pw.println("}");
        pw.flush();
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeInt(this.magic);
        dos.writeByte(this.minor_version);
        dos.writeByte(this.major_version);
        this.constant_pool.toBinary(dos);
        dos.writeShort(this.this_package_index);
        dos.writeByte(this.classes.length);
        for (int i = 0; i < this.classes.length; ++i) {
            this.classes[i].toBinary(dos);
        }
    }
}

