/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcfile.instructions;

import com.sun.javacard.jcfile.instructions.JcInstruction;

public class JcInstrTableSwitch
extends JcInstruction {
    private int default_label;
    private int low_value;
    private int high_value;
    private int[] branch_labels;

    public JcInstrTableSwitch(int opcode) {
        super(opcode);
    }

    public JcInstrTableSwitch(int opcode, int default_label, int low_value, int high_value, int[] branch_labels) {
        super(opcode);
        this.default_label = default_label;
        if (high_value < low_value) {
            // empty if block
        }
        if (branch_labels.length != high_value - low_value + 1) {
            // empty if block
        }
        this.low_value = low_value;
        this.high_value = high_value;
        this.branch_labels = branch_labels;
    }

    public int getDefaultLabel() {
        return this.default_label;
    }

    public int getLowValue() {
        return this.low_value;
    }

    public int getHighValue() {
        return this.high_value;
    }

    public int[] getBranchLabels() {
        return this.branch_labels;
    }

    public int getSizeInBytes() {
        if (this.opcode == 116) {
            return 11 + (this.high_value - this.low_value + 1) * 2;
        }
        return 7 + (this.high_value - this.low_value + 1) * 2;
    }
}

