/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.impl.AppTable;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.APDU;
import javacard.framework.APDUException;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.PINException;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.framework.UserException;
import javacard.security.CryptoException;

class Dispatcher {
    private static final byte INS_SELECT = -92;
    private static final byte P1_SELECT_DFBYNAME = 4;
    private static final byte P2_SELECT_OPTIONS = -13;
    private static final byte P2_SELECT_OPTIONS_ONLY = 0;
    private static boolean initDone = false;
    private static APDU theAPDU;
    private static byte[] theAPDUBuffer;
    private static PrivAccess thePrivAccess;
    static Dispatcher theDispatcher;

    Dispatcher() {
    }

    static void cardInit() {
        NativeMethods.markHeap();
        if (theDispatcher == null) {
            theDispatcher = new Dispatcher();
        }
        Exception ex = new CardException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new CardRuntimeException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new APDUException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new ISOException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new PINException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new SystemException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new TransactionException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new UserException(0);
        NativeMethods.setJCREentry(ex, true);
        ex = new CryptoException(0);
        NativeMethods.setJCREentry(ex, true);
        theAPDU = new APDU();
        NativeMethods.setJCREentry(theAPDU, true);
        thePrivAccess = JCSystem.thePrivAccess = new PrivAccess();
        NativeMethods.setJCREentry(thePrivAccess, false);
        theAPDUBuffer = theAPDU.getBuffer();
        NativeMethods.setJCREentry(theAPDUBuffer, true);
        PrivAccess.initialize(theAPDU);
        initDone = true;
        NativeMethods.commit();
    }

    static void cardReset() {
        PrivAccess.selectDefaultApplet();
        AppTable.cleanup();
    }

    static void main() {
        if (!initDone) {
            Dispatcher.cardInit();
        }
        Dispatcher.cardReset();
        int sw = 0;
        while (true) {
            PrivAccess.resetSelectingAppletFlag();
            theAPDU.complete((short)sw);
            try {
                Dispatcher.processDispatcherAPDU();
                if (PrivAccess.getSelectedAppID() == -1) {
                    ISOException.throwIt((short)27033);
                }
                PrivAccess.getSelectedApplet().process(theAPDU);
                if (JCSystem.getTransactionDepth() != 0) {
                    TransactionException.throwIt((short)1);
                }
                sw = -28672;
            }
            catch (ISOException ex) {
                sw = ex.getReason();
            }
            catch (Throwable throwable) {
                sw = 28416;
            }
            if (JCSystem.getTransactionDepth() == 0) continue;
            JCSystem.abortTransaction();
        }
    }

    private static void processDispatcherAPDU() {
        if (theAPDUBuffer[0] == 0) {
            switch (theAPDUBuffer[1]) {
                case -92: {
                    theDispatcher.selectAPDU(theAPDU);
                    break;
                }
            }
        }
    }

    void selectAPDU(APDU theAPDU) {
        if (theAPDUBuffer[2] == 4) {
            byte i;
            if ((theAPDUBuffer[3] & 0xFFFFFFF3) != 0) {
                return;
            }
            byte len = (byte)theAPDU.setIncomingAndReceive();
            if (len == theAPDUBuffer[4] && (i = AppTable.findApplet(theAPDUBuffer, (short)5, len)) != -1) {
                if (PrivAccess.getAppState(thePrivAccess.getAID(i)) >= 4) {
                    PrivAccess.selectApplet(i);
                } else {
                    PrivAccess.deselectOnly();
                    NativeMethods.setSelectedContext((byte)0);
                }
            }
            this.undoReceive();
        }
    }

    void undoReceive() {
        theAPDU.undoIncomingAndReceive();
    }
}

