/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.BaseClassInterfaceConverter;
import com.sun.javacard.converter.converters.ClinitConverter;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcMethodTable;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class InterfaceConverter
extends BaseClassInterfaceConverter {
    public InterfaceConverter(JClassFile java_class, PackageConverter p_converter) {
        super(java_class, p_converter);
    }

    public JcClass convert() throws Exception {
        this.intTypeCheck();
        this.jc_class.setInterfaceType(true);
        this.jc_class.setAccessFlags(this.jc_class.getAccessFlags() | 0x400);
        this.jc_class.setAccessFlags(this.jc_class.getAccessFlags() & 0xFFFFF7FF);
        String[] all_interfaces = this.determineAllSuperInterfaces();
        this.jc_class.setSuperInterfaces(all_interfaces);
        String[] public_interfaces = this.determinePublicSuperInterfaces();
        this.jc_class.setPublicSuperInterfaces(public_interfaces);
        this.detectRemovedPublicSuperinterfaces();
        if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
            this.detectAddedPublicSuperinterfaces();
        }
        boolean flag = this.determineShareableType();
        this.jc_class.setShareableType(flag);
        String[] super_classes = new String[]{this.java_class.getSuperClassName()};
        this.jc_class.setPublicSuperClasses(super_classes);
        JField[] java_fields = this.java_class.getFields();
        JcField[] jc_fields = new JcField[java_fields.length];
        int i = 0;
        while (i < java_fields.length) {
            jc_fields[i] = new JcField(java_fields[i]);
            if (this.getJcClass().getEfClass() != null) {
                jc_fields[i].setEfField(this.getJcClass().getEfClass().getField(java_fields[i].getFieldName(), java_fields[i].getFieldDescriptor()));
            }
            ++i;
        }
        this.jc_class.setFields(jc_fields);
        this.detectRemovedAPIFields();
        this.detectAddedAPIFields();
        this.checkFieldFlags();
        this.checkFieldValues();
        this.assignFieldTokens(jc_fields);
        JMethod[] java_methods = this.java_class.getMethods();
        int virtual_methods_num = java_methods.length;
        int i2 = 0;
        while (i2 < java_methods.length) {
            if (java_methods[i2].getMethodName().equals("<clinit>")) {
                ClinitConverter clinit_converter = new ClinitConverter(java_methods[i2], this.jc_class);
                clinit_converter.convert();
                virtual_methods_num = java_methods.length - 1;
                break;
            }
            ++i2;
        }
        JcMethod[] jc_methods = new JcMethod[virtual_methods_num];
        this.jc_class.setMethods(jc_methods);
        int j = 0;
        boolean allMethodsThrowRemoteException = true;
        int i3 = 0;
        while (i3 < java_methods.length) {
            if (!java_methods[i3].getMethodName().equals("<clinit>")) {
                jc_methods[j] = new JcMethod(java_methods[i3]);
                if (!java_methods[i3].throwsRemoteExceptionOrSuper()) {
                    allMethodsThrowRemoteException = false;
                }
                jc_methods[j].setLocalVariables(new JcLocalVariable[0]);
                jc_methods[j].setExceptions(new JcException[0]);
                ++j;
            }
            ++i3;
        }
        if (this.jc_class.inheritsRemote()) {
            if (allMethodsThrowRemoteException) {
                int i4 = 0;
                while (i4 < jc_methods.length) {
                    jc_methods[i4].setRemote(true);
                    ++i4;
                }
                this.jc_class.setRemote(true);
            } else {
                Object[] args = new String[]{this.java_class.getClassName().replace('/', '.')};
                Notifier.warning("warning.10", args);
                this.jc_class.setRemote(false);
            }
        }
        JcMethodTable public_method_table = this.constructPublicMethodTable();
        this.jc_class.setPublicMethodTable(public_method_table);
        this.assignMethodTokens();
        this.jc_class.setPackageMethodTable(new JcMethodTable(new MethodDefinition[0], 0));
        this.jc_class.setImplementedInterfaceInfos(new JcImplementedInterfaceInfo[0]);
        return this.jc_class;
    }

    private String[] determineAllSuperInterfaces() throws Exception {
        String[] direct_super_interfaces = this.java_class.getInterfaceNames();
        if (direct_super_interfaces == null) {
            return new String[0];
        }
        Vector interface_vector = new Vector(15);
        String this_package_name = Names.getPackageName(this.java_class.getClassName());
        int i = 0;
        while (i < direct_super_interfaces.length) {
            String[] super_super_interfaces;
            String an_interface = direct_super_interfaces[i];
            if (Names.getPackageName(an_interface).equals(this_package_name)) {
                JcClass jc_interface = this.p_converter.getJcClass(an_interface);
                if (jc_interface == null) {
                    Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), an_interface.replace('/', '.')};
                    Notifier.error("linking.5", args);
                    throw new ConversionException();
                }
                super_super_interfaces = jc_interface.getSuperInterfaces();
            } else {
                ExportFileManager ex_manager = this.p_converter.getExportFileManager();
                EfClass ef_interface = ex_manager.getClass(an_interface);
                if (ef_interface == null) {
                    Object[] args = new String[]{this.java_class.getClassName().replace('/', '.'), an_interface.replace('/', '.'), Names.getExportFileName(Names.getPackageName(an_interface))};
                    Notifier.error("linking.4", args);
                    throw new ConversionException();
                }
                super_super_interfaces = ef_interface.getInterfaceNames();
            }
            this.addInterfaces(interface_vector, super_super_interfaces);
            this.addInterface(interface_vector, an_interface);
            ++i;
        }
        Object[] all_super_interfaces = new String[interface_vector.size()];
        interface_vector.copyInto(all_super_interfaces);
        return all_super_interfaces;
    }

    private JcMethodTable constructPublicMethodTable() throws Exception {
        String[] direct_super_interfaces = this.java_class.getInterfaceNames();
        Vector method_vector = new Vector(20);
        String this_package_name = Names.getPackageName(this.java_class.getClassName());
        int i = 0;
        while (i < direct_super_interfaces.length) {
            MethodDefinition[] super_interface_methods;
            Object[] args;
            String super_interface = direct_super_interfaces[i];
            if (Names.getPackageName(super_interface).equals(this_package_name)) {
                JcClass jc_super_interface = this.p_converter.getJcClass(super_interface);
                if (jc_super_interface == null) {
                    args = new String[]{this.java_class.getClassName().replace('/', '.'), super_interface.replace('/', '.')};
                    Notifier.error("linking.5", args);
                    throw new ConversionException();
                }
                super_interface_methods = jc_super_interface.getPublicMethodTable().getMethods();
            } else {
                EfClass ef_class = this.getExportClass(super_interface);
                if (ef_class == null) {
                    args = new String[]{this.java_class.getClassName().replace('/', '.'), super_interface.replace('/', '.'), Names.getExportFileName(Names.getPackageName(super_interface))};
                    Notifier.error("linking.4", args);
                    throw new ConversionException();
                }
                super_interface_methods = ef_class.getMethods();
            }
            int j = 0;
            while (j < super_interface_methods.length) {
                MethodDefinition a_method = new MethodDefinition(super_interface_methods[j]);
                this.addMethod(method_vector, a_method);
                ++j;
            }
            ++i;
        }
        JcMethod[] this_interface_methods = this.jc_class.getMethods();
        int i2 = 0;
        while (i2 < this_interface_methods.length) {
            MethodDefinition a_method = new MethodDefinition(this_interface_methods[i2]);
            this.addMethod(method_vector, this_interface_methods[i2]);
            ++i2;
        }
        Object[] all_interface_methods = new MethodDefinition[method_vector.size()];
        method_vector.copyInto(all_interface_methods);
        return new JcMethodTable((MethodDefinition[])all_interface_methods, 0);
    }

    private void addMethod(Vector method_vector, MethodDefinition a_method) {
        int i = 0;
        while (i < method_vector.size()) {
            MethodDefinition method_i = (MethodDefinition)method_vector.elementAt(i);
            if (method_i.getMethodName().equals(a_method.getMethodName()) && method_i.getMethodDescriptor().equals(a_method.getMethodDescriptor())) {
                return;
            }
            ++i;
        }
        method_vector.addElement(a_method);
    }

    private void assignMethodTokens() throws Exception {
        MethodDefinition[] all_methods = this.jc_class.getPublicMethodTable().getMethods();
        this.detectRemovedAPIMethods(all_methods);
        this.detectAddedAPIMethods(all_methods);
        this.assignKnownMethodTokens(all_methods);
        InterfaceConverter.sortMethodsByTokens(all_methods);
        InterfaceConverter.assignNewMethodTokens(all_methods);
        JcMethod[] jc_methods = this.jc_class.getMethods();
        int i = 0;
        while (i < jc_methods.length) {
            JcMethod method_i = jc_methods[i];
            int j = 0;
            while (j < all_methods.length) {
                MethodDefinition method_j = all_methods[j];
                if (method_i.getMethodName().equals(method_j.getMethodName()) && method_i.getMethodDescriptor().equals(method_j.getMethodDescriptor())) {
                    method_i.setMethodToken(j);
                    break;
                }
                ++j;
            }
            if (j == all_methods.length) {
                throw new ConversionException();
            }
            ++i;
        }
    }

    private MethodDefinition[] getMethodsFromExportFile() throws Exception {
        String class_name = this.java_class.getClassName();
        EfClass ef_class = this.getExportClass(class_name);
        if (ef_class == null) {
            Object[] args = new String[]{class_name.replace('/', '.'), class_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(class_name))};
            Notifier.error("linking.20", args);
            throw new ConversionException();
        }
        MethodDefinition[] ef_methods = ef_class.getMethods();
        int i = 0;
        while (i < ef_methods.length) {
            MethodDefinition method_i = ef_methods[i];
            int j = method_i.getMethodToken();
            if (i != j) {
                MethodDefinition method_j = ef_methods[j];
                ef_methods[j] = method_i;
                ef_methods[i] = method_j;
            }
            ++i;
        }
        return ef_methods;
    }

    private void assignFieldTokens(JcField[] jc_fields) {
        this.assignKnownFieldTokens();
        this.presortFieldsByTokens();
        int token = 0;
        int i = 0;
        while (i < jc_fields.length) {
            JcField jc_field = jc_fields[i];
            String descriptor = jc_field.getFieldDescriptor();
            if (DataType.getType(descriptor) == 10) {
                jc_field.setFieldToken(token++);
            }
            ++i;
        }
    }

    private boolean isThisExpProvided() {
        int access_flags = this.java_class.getAccessFlags();
        if (Modifier.isPublic(access_flags)) {
            return this.p_converter.isThisExpProvided();
        }
        return false;
    }

    protected void detectRemovedAPIMethods(MethodDefinition[] md) throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfMethod[] efMethods = this.getJcClass().getEfClass().getMethods();
        int i = 0;
        while (i < efMethods.length) {
            EfMethod efMethod = efMethods[i];
            if (InterfaceConverter.findMethodInArray(md, efMethod.getMethodName(), efMethod.getMethodDescriptor()) == null) {
                Object[] args = new Object[]{efMethod.getMethodDescriptor(), efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.22", args);
                throw new ConversionException();
            }
            ++i;
        }
    }

    protected void detectAddedAPIMethods(MethodDefinition[] md) throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        int i = 0;
        while (i < md.length) {
            EfMethod efMethod = this.getJcClass().getEfClass().getMethod(md[i].getMethodName(), md[i].getMethodDescriptor());
            if (efMethod == null) {
                Object[] args = new Object[]{md[i].getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.39", args);
                throw new ConversionException();
            }
            ++i;
        }
    }

    private static void sortMethodsByTokens(MethodDefinition[] methods) {
        boolean again = true;
        while (again) {
            again = false;
            int i = 0;
            while (i < methods.length - 1) {
                if (methods[i].getMethodToken() > methods[i + 1].getMethodToken()) {
                    again = true;
                    MethodDefinition tmp = methods[i];
                    methods[i] = methods[i + 1];
                    methods[i + 1] = tmp;
                }
                ++i;
            }
        }
    }

    private static void assignNewMethodTokens(MethodDefinition[] methods) {
        int i = 0;
        while (i < methods.length) {
            methods[i].setMethodToken(i);
            ++i;
        }
    }

    private static MethodDefinition findMethodInArray(MethodDefinition[] md, String name, String descriptor) {
        int i = 0;
        while (i < md.length) {
            if (md[i].getMethodName().equals(name) && md[i].getMethodDescriptor().equals(descriptor)) {
                return md[i];
            }
            ++i;
        }
        return null;
    }

    private void assignKnownMethodTokens(MethodDefinition[] md) {
        EfClass efc = this.getJcClass().getEfClass();
        if (efc == null) {
            int i = 0;
            while (i < md.length) {
                md[i].setMethodToken(255);
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < md.length) {
            EfMethod efm = efc.getMethod(md[i].getMethodName(), md[i].getMethodDescriptor());
            if (efm != null) {
                md[i].setMethodToken(efm.getMethodToken());
            } else {
                md[i].setMethodToken(255);
            }
            ++i;
        }
    }
}

