/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.ObjectReferenceConverters;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ChainPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassInfoPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classic.handlers.FixedDataHandler;
import com.sun.javacard.debugproxy.classic.handlers.UnsupportedOperationHandler;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.FieldDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReferenceTypeConverters {
    public static final int CLASS_OBJECT_FLAG = Integer.MIN_VALUE;

    static byte getTypeTag(String type) {
        if (type.startsWith("[")) {
            return 91;
        }
        if (type.equals("B")) {
            return 66;
        }
        if (type.equals("Ljava/lang/String;")) {
            return 115;
        }
        if (type.startsWith("L")) {
            return 76;
        }
        if (type.equals("I")) {
            return 73;
        }
        if (type.equals("S")) {
            return 83;
        }
        if (type.equals("V")) {
            return 86;
        }
        if (type.equals("Z")) {
            return 90;
        }
        if (type.equals("t")) {
            return 116;
        }
        if (type.equals("g")) {
            return 103;
        }
        if (type.equals("c")) {
            return 99;
        }
        Logger.getAnonymousLogger().severe("Unsupported type: " + type);
        return 86;
    }

    static void registerReferenceTypeConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(2, 1, new ClassInfoPacketHandler("Signature"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                EncodingUtils.writeString(toIdePacket, cid == -32 ? "Lkvm_threadgroup;" : classFile.getClassSignature());
            }
        });
        proxy.addConverter(2, 2, new FixedDataHandler(0));
        proxy.addConverter(2, 3, new ClassInfoPacketHandler("Modifiers"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                int accessFlags = classFile.getRawAccessFlags() & 0x7FF;
                toIdePacket.writeInt(accessFlags);
            }
        });
        proxy.addConverter(2, 4, new ClassInfoPacketHandler("field"){

            @Override
            public boolean processNullClass(DataInputStream fromIde, DataOutputStream toIde, int cid) throws Exception {
                Log.LOGN(3, "field_cmd: cf == null");
                toIde.writeInt(0);
                return true;
            }

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                List<FieldDebugInfo> fiList = classFile.getAllFieldInfo();
                long fieldID = (long)classFile.getClassID() << 32;
                Log.LOGN(5, "field class id is " + Integer.toHexString(classFile.getClassID()) + " fieldid is " + Long.toHexString(fieldID));
                toIdePacket.writeInt(fiList.size());
                for (FieldDebugInfo fi : fiList) {
                    if (fi == null) {
                        throw new Exception("fieldinfo null");
                    }
                    Log.LOGN(5, "Field: id = " + Long.toHexString(fieldID));
                    toIdePacket.writeLong(fieldID++);
                    Log.LOGN(5, "Field: name = " + fi.getName());
                    EncodingUtils.writeString(toIdePacket, fi.getName());
                    Log.LOGN(5, "Field: sig = " + fi.getType());
                    EncodingUtils.writeString(toIdePacket, fi.getType());
                    Log.LOGN(5, "Field: flags = " + fi.getAccessFlags());
                    toIdePacket.writeInt(fi.getAccessFlags());
                }
            }
        });
        proxy.addConverter(2, 5, new ClassInfoPacketHandler("method"){

            @Override
            public boolean processNullClass(DataInputStream fromIde, DataOutputStream toIde, int cid) throws Exception {
                Log.LOGN(3, "methods_cmd: cf == null or cf == arrayclass");
                toIde.writeInt(0);
                return true;
            }

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                List<MethodDebugInfo> miList = classFile.getAllMethodInfo();
                Log.LOGN(5, "Methods: " + miList.size() + " methods");
                toIdePacket.writeInt(miList.size());
                for (MethodDebugInfo mi : miList) {
                    if (mi == null) {
                        throw new Exception("methodinfo null");
                    }
                    Log.LOGN(5, "Method: id = " + Integer.toHexString(mi.getID()));
                    toIdePacket.writeInt(mi.getID());
                    Log.LOGN(5, "Method: name = " + mi.getName());
                    EncodingUtils.writeString(toIdePacket, mi.getName());
                    Log.LOGN(5, "Method: sig = " + mi.getSignatureRaw());
                    EncodingUtils.writeString(toIdePacket, mi.getSignatureRaw());
                    Log.LOGN(5, "Method: flags = " + mi.getAccessFlags());
                    toIdePacket.writeInt(mi.getAccessFlags());
                }
            }
        });
        proxy.addConverter(2, 6, new ChainPacketHandler(VMPacketHandler.CommandCode.GET_STATIC_FIELD, 50){

            boolean isFinalPrimitiveField(FieldDebugInfo fieldDebugInfo) {
                boolean isFinal = (fieldDebugInfo.getAccessFlags() & 0x10) != 0;
                boolean isReference = fieldDebugInfo.getType().startsWith("[") || fieldDebugInfo.getType().startsWith("L");
                return isFinal && !isReference;
            }

            int loadFieldArray(DataInputStream fromIde, int numFields, List<FieldDebugInfo> fieldArray) throws IOException {
                int nonFinalPrimitiveCount = 0;
                for (int field = 0; field < numFields; ++field) {
                    long fieldID = fromIde.readLong();
                    FieldDebugInfo fieldDebugInfo = this.proxy.state().classes().findFieldInfoByIndex(fieldID);
                    if (fieldDebugInfo == null) {
                        throw new InvalidRequestException(25);
                    }
                    if (!this.isFinalPrimitiveField(fieldDebugInfo)) {
                        ++nonFinalPrimitiveCount;
                    }
                    fieldArray.add(fieldDebugInfo);
                }
                return nonFinalPrimitiveCount;
            }

            @Override
            protected int startChain(HandlerState state) throws Exception {
                ArrayList<FieldDebugInfo> fieldArray = new ArrayList<FieldDebugInfo>();
                int cid = state.in.readInt();
                int numFields = EncodingUtils.copyInt(state.in, state.out);
                ClassDebugInfo cl = this.proxy.state().classes().getClassByID(cid);
                if (cl == null) {
                    throw new InvalidRequestException(21);
                }
                state.args.put("fields", fieldArray);
                state.args.put("class", cl);
                state.args.put("current-field", 0);
                return this.loadFieldArray(state.in, numFields, fieldArray);
            }

            @Override
            protected void handleChunk(boolean isHead, HandlerState state, DataOutputStream toVm, int chunkSize) throws Exception {
                ClassDebugInfo cl = (ClassDebugInfo)state.args.get("class");
                List fields = (List)state.args.get("fields");
                int currentField = 5.getInt(state.args, "current-field");
                toVm.writeByte(cl.getPackageID());
                toVm.writeByte((byte)chunkSize);
                int sentFields = 0;
                while (sentFields < chunkSize) {
                    FieldDebugInfo fieldDebugInfo;
                    if (this.isFinalPrimitiveField(fieldDebugInfo = (FieldDebugInfo)fields.get(currentField++))) continue;
                    String staticFieldType = fieldDebugInfo.getType();
                    toVm.writeByte(ReferenceTypeConverters.getTypeTag(staticFieldType));
                    int staticFieldIndex = fieldDebugInfo.getContents();
                    toVm.writeShort((short)staticFieldIndex);
                    Log.LOGN(3, "staticFieldIndex: " + staticFieldIndex);
                    ++sentFields;
                }
            }

            @Override
            protected void finishChain(HandlerState state, int totalLength) throws Exception {
                ArrayList fields = (ArrayList)state.args.get("fields");
                for (int i = 5.getInt(state.args, "current-field"); i < fields.size(); ++i) {
                    FieldDebugInfo fieldDebugInfo = (FieldDebugInfo)fields.get(i);
                    if (!this.isFinalPrimitiveField(fieldDebugInfo)) {
                        throw new InvalidRequestException(25);
                    }
                    this.writeFinalPrimitiveField(fieldDebugInfo, state.out);
                }
            }

            private void writeFinalPrimitiveField(FieldDebugInfo field, DataOutputStream out) throws IOException {
                byte tag = ReferenceTypeConverters.getTypeTag(field.getType());
                ObjectReferenceConverters.writeTaggedValue(field.getContents(), out, tag, (short)25);
            }

            @Override
            protected void handleResponseChunk(boolean isHead, HandlerState state, int chunkSize, DataInputStream in, int length) throws Exception {
                ArrayList fields = (ArrayList)state.args.get("fields");
                int currentField = 5.getInt(state.args, "current-field");
                int end = currentField + chunkSize;
                int numFieldsInRequest = in.readByte();
                while (currentField < end && numFieldsInRequest > 0) {
                    FieldDebugInfo fieldDebugInfo;
                    if (this.isFinalPrimitiveField(fieldDebugInfo = (FieldDebugInfo)fields.get(currentField++))) {
                        this.writeFinalPrimitiveField(fieldDebugInfo, state.out);
                        continue;
                    }
                    byte tag = in.readByte();
                    ObjectReferenceConverters.writeTaggedValue(in, (DataOutputStream)state.out, tag, (short)25);
                    --numFieldsInRequest;
                }
                state.args.put("current-field", end);
            }
        });
        proxy.addConverter(2, 7, new ClassInfoPacketHandler("Source File"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                String sfName = classFile.getSourceFileName();
                if (sfName == null) {
                    throw new InvalidRequestException(101);
                }
                Log.LOGN(3, "Returning from attribute: " + sfName);
                EncodingUtils.writeString(toIdePacket, sfName);
            }
        });
        proxy.addConverter(2, 8, new ClassInfoPacketHandler("Nested Types"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                Log.LOGN(3, "Nested Types: class " + classFile.getClassName());
                Collection<ClassDebugInfo> classes = this.proxy.state().classes().getClasses();
                String className = classFile.getClassName();
                ArrayList<ClassDebugInfo> nestedTypes = new ArrayList<ClassDebugInfo>();
                Pattern pattern = Pattern.compile("^" + className + "\\$[^\\$]*$");
                for (ClassDebugInfo aClass : classes) {
                    Matcher matcher = pattern.matcher(aClass.getClassName());
                    if (!matcher.matches() || aClass.getJDWPTypeTag() == 3) continue;
                    Log.LOGN(3, "Nested Type found: " + aClass.getClassName());
                    nestedTypes.add(aClass);
                }
                toIdePacket.writeInt(nestedTypes.size());
                for (ClassDebugInfo nestedType : nestedTypes) {
                    toIdePacket.writeByte(nestedType.getJDWPTypeTag());
                    toIdePacket.writeInt(nestedType.getClassID());
                }
            }
        });
        proxy.addConverter(2, 9, new FixedDataHandler(2));
        proxy.addConverter(2, 10, new ClassInfoPacketHandler("Interfaces"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                List<String> iList = classFile.getAllInterfaces();
                Log.LOGN(3, "Interfaces: class " + classFile.getClassName() + " " + iList.size() + " interfaces");
                toIdePacket.writeInt(iList.size());
                for (String className : iList) {
                    Log.LOGN(3, "interfaces: classname: " + className);
                    if (className == null) {
                        throw new Exception("interface name null");
                    }
                    String jniSignature = VMClassPool.getJNISignature(className);
                    classFile = this.proxy.state().classes().getClassBySignature(jniSignature);
                    if (classFile == null) {
                        toIdePacket.writeInt(0);
                        continue;
                    }
                    toIdePacket.writeInt(classFile.getClassID());
                }
            }
        });
        proxy.addConverter(2, 11, new ClassInfoPacketHandler("ClassObject"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                int classObjectID = classFile.getClassID() | Integer.MIN_VALUE;
                toIdePacket.writeInt(classObjectID);
            }
        });
        proxy.addConverter(2, 12, new UnsupportedOperationHandler(99));
    }

    static void registerClassObjectReferenceConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(17, 1, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.NONE){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
                int classID = state.in.readInt() & Integer.MAX_VALUE;
                ClassDebugInfo cl = this.proxy.state().classes().getClassByID(classID);
                if (cl == null) {
                    throw new InvalidRequestException(20);
                }
                state.out.writeByte(cl.getJDWPTypeTag());
                state.out.writeInt(classID);
                return ClassicPacketHandler.DeliveryType.NONE;
            }
        });
    }
}

