/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.instructions;

import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstrSwitch;
import java.io.DataInputStream;
import java.io.IOException;

public class JInstrTableSwitch
extends JInstrSwitch {
    private int low_value;
    private int high_value;
    private int[] branch_offsets;

    public JInstrTableSwitch(JConstantPool cp, int pc, int opcode) {
        super(cp, pc, opcode);
    }

    public int getLowValue() {
        return this.low_value;
    }

    public int getHighValue() {
        return this.high_value;
    }

    public int[] getBranchOffsets() {
        return this.branch_offsets;
    }

    public int getSizeInBytes() {
        return this.size_in_bytes;
    }

    public void parse(DataInputStream dis) throws IOException {
        super.parse(dis);
        this.low_value = dis.readInt();
        this.high_value = dis.readInt();
        int num_branch_offset = this.high_value - this.low_value + 1;
        this.branch_offsets = new int[num_branch_offset];
        int i = 0;
        while (i < num_branch_offset) {
            this.branch_offsets[i] = dis.readInt();
            ++i;
        }
        this.size_in_bytes = 1 + this.num_padding + (3 + num_branch_offset) * 4;
    }
}

