/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.constants.JcConstantStaticMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantVirtualMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

class InstrMethodRefConverter
extends InstructionConverter {
    public InstrMethodRefConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    public JcInstruction convert() throws Exception {
        JInstrMethodRef method_instr = (JInstrMethodRef)this.java_instr;
        String class_name = method_instr.getClassName();
        String method_name = method_instr.getMethodName();
        String descriptor = method_instr.getDescriptor();
        this.checkParamAndReturnTypes(class_name, method_name, descriptor);
        int[] param_types = MethodDescriptor.getParamTypes(descriptor);
        int return_type = MethodDescriptor.getReturnType(descriptor);
        this.checkParamTypesAgainstStackEntryTypes(param_types);
        int i = 0;
        while (i < param_types.length) {
            this.operand_stack.pop();
            ++i;
        }
        int java_opcode = method_instr.getOpcode();
        JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
        switch (java_opcode) {
            case 182: {
                this.operand_stack.pop();
                JcConstantVirtualMethodRef methodref = jc_cp.addConstantVirtualMethodRef(class_name, method_name, descriptor);
                this.checkRef(methodref);
                this.jc_instr = new JcInstrMethodRef(139, methodref);
                if (return_type != 9) {
                    this.operand_stack.push(return_type, this.instr_container);
                }
                return this.jc_instr;
            }
            case 183: {
                this.operand_stack.pop();
                JcConstantMethodRef methodref = this.getMethodRef(class_name, method_name, descriptor);
                this.jc_instr = new JcInstrMethodRef(140, methodref);
                if (return_type != 9) {
                    this.operand_stack.push(return_type, this.instr_container);
                }
                return this.jc_instr;
            }
            case 184: {
                JcConstantStaticMethodRef methodref = jc_cp.addConstantStaticMethodRef(class_name, method_name, descriptor);
                this.jc_instr = new JcInstrMethodRef(141, methodref);
                if (return_type != 9) {
                    this.operand_stack.push(return_type, this.instr_container);
                }
                return this.jc_instr;
            }
            case 185: {
                this.operand_stack.pop();
                JcConstantClassRef class_ref = jc_cp.addConstantClassRef(class_name);
                int num_of_args = MethodDescriptor.getParamSize(descriptor) + 1;
                int method_token = this.getMethodToken(class_name, method_name, descriptor);
                this.jc_instr = new JcInstrInterfaceRef(142, num_of_args, class_ref, method_token);
                if (return_type != 9) {
                    this.operand_stack.push(return_type, this.instr_container);
                }
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private JcConstantMethodRef getMethodRef(String class_name, String method_name, String descriptor) {
        JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
        if (method_name.equals("<init>")) {
            return jc_cp.addConstantStaticMethodRef(class_name, method_name, descriptor);
        }
        JClassFile java_class = this.method_converter.getClassConverter().getJavaClass();
        JMethod[] java_methods = java_class.getMethods();
        int i = 0;
        while (i < java_methods.length) {
            JMethod j_method = java_methods[i];
            int access_flags = j_method.getAccessFlags();
            if (Modifier.isPrivate(access_flags) && j_method.getMethodName().equals(method_name) && j_method.getMethodDescriptor().equals(descriptor)) {
                return jc_cp.addConstantStaticMethodRef(class_name, method_name, descriptor);
            }
            ++i;
        }
        return jc_cp.addConstantSuperMethodRef(java_class.getClassName(), method_name, descriptor);
    }

    private void checkParamAndReturnTypes(String method_class_name, String method_name, String descriptor) throws Exception {
        Object[] args;
        String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
        String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
        int i = param_descs.length - 1;
        while (i >= 0) {
            if (param_descs[i].equals("I") || param_descs[i].equals("[I")) {
                if (this.method_converter.isIntSupported()) {
                    args = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(method_class_name.replace('/', '.') + "." + method_name)};
                    Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.2", args);
                    this.method_converter.getPackageConverter().setIntFlag(true);
                } else {
                    args = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(method_class_name.replace('/', '.') + "." + method_name)};
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.2", args);
                    throw new ConversionException();
                }
            }
            --i;
        }
        if (return_desc.equals("I") || return_desc.equals("[I")) {
            if (this.method_converter.isIntSupported()) {
                args = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(method_class_name.replace('/', '.') + "." + method_name)};
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.3", args);
                this.method_converter.getPackageConverter().setIntFlag(true);
            } else {
                args = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(method_class_name.replace('/', '.') + "." + method_name)};
                Notifier.error(this.java_instr.getSourceLineNumber(), "int.3", args);
                throw new ConversionException();
            }
        }
    }

    private void checkParamTypesAgainstStackEntryTypes(int[] param_types) throws Exception {
        int i = param_types.length - 1;
        while (i >= 0) {
            int operand_stack_entry_num = param_types.length - i;
            OperandStackEntry value_entry = this.operand_stack.peek(operand_stack_entry_num);
            switch (param_types[i]) {
                case 3: {
                    if (value_entry.getType() == 3) break;
                    value_entry.rollBack();
                    break;
                }
                case 2: {
                    if (value_entry.getType() != 3) break;
                    Object[] args = new Object[]{this.method_converter.getClassName().replace('/', '.'), "" + i};
                    Notifier.error(this.java_instr.getSourceLineNumber(), "conversion.21", args);
                    throw new ConversionException();
                }
                case 1: {
                    if (value_entry.getType() != 3) break;
                    Object[] args = new Object[]{this.method_converter.getClassName().replace('/', '.'), "" + i};
                    Notifier.error(this.java_instr.getSourceLineNumber(), "conversion.21", args);
                    throw new ConversionException();
                }
            }
            --i;
        }
    }

    private int getMethodToken(String interface_name, String method_name, String descriptor) throws Exception {
        PackageConverter p_converter = this.method_converter.getPackageConverter();
        String this_package_name = p_converter.getJcPackage().getPackageName();
        if (Names.getPackageName(interface_name).equals(this_package_name)) {
            JcClass jc_interface = p_converter.getJcClass(interface_name);
            if (jc_interface == null) {
                Object[] args = new String[]{this.method_converter.getClassName().replace('/', '.'), interface_name.replace('/', '.')};
                Notifier.error(this.java_instr.getSourceLineNumber(), "linking.21", args);
                throw new ConversionException();
            }
            MethodDefinition[] all_interface_methods = jc_interface.getPublicMethodTable().getMethods();
            int i = 0;
            while (i < all_interface_methods.length) {
                if (all_interface_methods[i].getMethodName().equals(method_name) && all_interface_methods[i].getMethodDescriptor().equals(descriptor)) {
                    return i;
                }
                ++i;
            }
            Object[] args = new String[]{this.method_converter.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(method_name, descriptor), interface_name.replace('/', '.')};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.17", args);
            throw new ConversionException();
        }
        ExportFileManager ex_manager = p_converter.getExportFileManager();
        EfClass ef_interface = ex_manager.getClass(interface_name);
        if (ef_interface == null) {
            Object[] args = new String[]{this.method_converter.getClassName().replace('/', '.'), interface_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(interface_name))};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.20", args);
            throw new ConversionException();
        }
        EfMethod ef_method = ef_interface.getMethod(method_name, descriptor);
        if (ef_method == null) {
            Object[] args = new String[]{this.method_converter.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(method_name, descriptor), interface_name.replace('/', '.'), Names.getExportFileName(Names.getPackageName(interface_name))};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.20", args);
            throw new ConversionException();
        }
        return ef_method.getMethodToken();
    }

    private void checkRef(JcConstantVirtualMethodRef methodref) throws Exception {
        if (this.method_converter.getClassName().equals(methodref.getClassName())) {
            return;
        }
        PackageConverter p_converter = this.method_converter.getPackageConverter();
        JcClass jcc = p_converter.getJcClass(methodref.getClassName());
        if (jcc == null) {
            return;
        }
        JcMethod jcm = jcc.getMethod(methodref.getMethodName(), methodref.getDescriptor());
        Object[] args = new String[]{this.method_converter.getMethodName(), this.method_converter.getClassName().replace('/', '.'), methodref.getMethodName(), methodref.getClassName().replace('/', '.')};
        if (jcm == null && !jcc.hasVirtualMethod(methodref.getMethodName(), methodref.getDescriptor())) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.26", args);
            throw new ConversionException();
        }
        if (jcm != null && jcm.isPrivate()) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.25", args);
            throw new ConversionException();
        }
    }
}

