/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework.tlv;

import com.sun.javacard.impl.NativeMethods;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacardx.framework.tlv.BERTLV;
import javacardx.framework.tlv.BERTag;
import javacardx.framework.tlv.PrimitiveBERTag;
import javacardx.framework.tlv.TLVException;

public class PrimitiveBERTLV
extends BERTLV {
    public PrimitiveBERTLV(short numValueBytes) {
        try {
            this.theValue = new byte[numValueBytes];
        }
        catch (Exception e2) {
            TLVException.throwIt((short)1);
        }
        this.theValue = new byte[numValueBytes];
        this.valueLength = 0;
        this.emptyTLV = true;
    }

    public short init(byte[] bArray, short bOff, short bLen) throws TLVException {
        NativeMethods.checkArrayArgs(bArray, bOff, bLen);
        if (!BERTLV.verifyFormat(bArray, bOff, bLen)) {
            TLVException.throwIt((short)6);
        }
        if (this.theBERTag != null) {
            JCSystem.requestObjectDeletion();
        }
        short bLength = PrimitiveBERTLV.getLength(bArray, bOff);
        short bOffSet = PrimitiveBERTLV.getValueOffsetInternal(bArray, bOff);
        if ((short)(bOffSet + bLength) > (short)(bOff + bLen)) {
            TLVException.throwIt((short)6);
        }
        this.theBERTag = BERTag.getInstance(bArray, bOff);
        this.sharedValueInit(bArray, bOffSet, bLength);
        return this.size();
    }

    public short init(PrimitiveBERTag tag, byte[] vArray, short vOff, short vLen) throws TLVException {
        NativeMethods.checkArrayArgs(vArray, vOff, vLen);
        if (this.theBERTag != null) {
            JCSystem.requestObjectDeletion();
        }
        this.theBERTag = tag;
        this.sharedValueInit(vArray, vOff, vLen);
        return this.size();
    }

    private void sharedValueInit(byte[] vArray, short vOff, short vLen) {
        if (this.theBERTag.isConstructed()) {
            TLVException.throwIt((short)6);
        }
        if (this.theValue.length < vLen) {
            this.theValue = new byte[(short)(vLen + 4)];
            JCSystem.requestObjectDeletion();
        }
        Util.arrayCopy(vArray, vOff, this.theValue, (short)0, vLen);
        this.valueLength = vLen;
        this.emptyTLV = false;
    }

    public short appendValue(byte[] vArray, short vOff, short vLen) throws TLVException {
        return this.setValue(vArray, vOff, vLen, (byte)1);
    }

    public short replaceValue(byte[] vArray, short vOff, short vLen) throws TLVException {
        return this.setValue(vArray, vOff, vLen, (byte)2);
    }

    private short setValue(byte[] vArray, short vOff, short vLen, byte replaceOrAppend) throws TLVException {
        short valueLen;
        short offset = 0;
        byte[] tempArray = null;
        NativeMethods.checkArrayArgs(vArray, vOff, vLen);
        if (this.emptyTLV) {
            TLVException.throwIt((short)4);
        }
        if (replaceOrAppend == 1) {
            valueLen = (short)(vLen + this.valueLength);
            offset = this.valueLength;
        } else {
            valueLen = vLen;
        }
        if (this.theValue.length < valueLen) {
            if (replaceOrAppend == 1) {
                tempArray = new byte[this.theValue.length];
                Util.arrayCopy(this.theValue, (short)0, tempArray, (short)0, this.valueLength);
            }
            this.theValue = new byte[(short)(valueLen + 4)];
            if (replaceOrAppend == 1) {
                Util.arrayCopy(tempArray, (short)0, this.theValue, (short)0, this.valueLength);
            }
            JCSystem.requestObjectDeletion();
        }
        Util.arrayCopy(vArray, vOff, this.theValue, offset, vLen);
        this.valueLength = valueLen;
        return (short)(this.valueLength + this.theBERTag.size() + PrimitiveBERTLV.getValueLengthSize(this.valueLength));
    }

    public short getValue(byte[] tlvValue, short tOff) throws TLVException {
        NativeMethods.checkArrayArgs(tlvValue, tOff, this.valueLength);
        if (this.emptyTLV) {
            TLVException.throwIt((short)4);
        }
        Util.arrayCopy(this.theValue, (short)0, tlvValue, tOff, this.valueLength);
        return this.valueLength;
    }

    public static short getValueOffset(byte[] berTLVArray, short bTLVOff) throws TLVException {
        if ((0x20 & berTLVArray[bTLVOff]) != 0) {
            TLVException.throwIt((short)6);
        }
        NativeMethods.checkArrayArgs(berTLVArray, bTLVOff, (short)(berTLVArray.length - bTLVOff));
        short offSet = PrimitiveBERTLV.verifyTagAndLength(berTLVArray, bTLVOff);
        if (offSet == -1) {
            TLVException.throwIt((short)6);
        } else if (offSet == -2) {
            TLVException.throwIt((short)11);
        } else if (offSet == -3) {
            TLVException.throwIt((short)6);
        } else if (offSet == -4) {
            NativeMethods.checkArrayArgs(berTLVArray, bTLVOff, (short)(berTLVArray.length + 1));
        }
        return BERTLV.getValueOffsetInternal(berTLVArray, bTLVOff);
    }

    public static short toBytes(byte[] berTagArray, short berTagOff, byte[] valueArray, short vOff, short vLen, byte[] outBuf, short bOff) {
        short tempNumber;
        NativeMethods.checkArrayArgs(berTagArray, berTagOff, (short)(berTagArray.length - berTagOff));
        NativeMethods.checkArrayArgs(valueArray, vOff, vLen);
        short tagSizeInBytes = 0;
        short len = BERTLV.getValueLengthSize(vLen);
        short totalLen = 0;
        if (BERTag.isConstructed(berTagArray, berTagOff)) {
            TLVException.throwIt((short)5);
        }
        if ((tempNumber = BERTag.verifyFormatInternal(berTagArray, berTagOff)) >= 0) {
            tagSizeInBytes = BERTag.getTagSize(tempNumber);
            totalLen = (short)(vLen + tagSizeInBytes + len);
            NativeMethods.checkArrayArgs(outBuf, bOff, totalLen);
            if (totalLen > Short.MAX_VALUE) {
                TLVException.throwIt((short)10);
            }
            Util.arrayCopy(berTagArray, berTagOff, outBuf, bOff, tagSizeInBytes);
            short offset = (short)(bOff + tagSizeInBytes);
            if (vLen < 128) {
                outBuf[offset] = (byte)vLen;
                offset = (short)(offset + 1);
            } else {
                outBuf[offset] = -126;
                offset = (short)(offset + 1);
                Util.setShort(outBuf, offset, vLen);
                offset = (short)(offset + 2);
            }
            Util.arrayCopy(valueArray, vOff, outBuf, offset, vLen);
        } else {
            TLVException.throwIt((short)5);
        }
        return totalLen;
    }

    public static short appendValue(byte[] berTLVArray, short bTLVOff, byte[] vArray, short vOff, short vLen) throws TLVException {
        int sizeOfLength = 0;
        short tagSizeInBytes = 0;
        short valueOffset = 0;
        short valueLength = 0;
        int lengthSizeChange = 0;
        if (BERTag.verifyFormatInternal(berTLVArray, bTLVOff) < 0) {
            TLVException.throwIt((short)6);
        }
        if (BERTag.isConstructed(berTLVArray, bTLVOff)) {
            TLVException.throwIt((short)6);
        }
        try {
            valueOffset = PrimitiveBERTLV.getValueOffset(berTLVArray, bTLVOff);
            valueLength = PrimitiveBERTLV.getLength(berTLVArray, bTLVOff);
        }
        catch (Exception e2) {
            TLVException.throwIt((short)6);
        }
        short tempNumber = BERTag.verifyFormatInternal(berTLVArray, bTLVOff);
        if (tempNumber >= 0) {
            tagSizeInBytes = BERTag.getTagSize(tempNumber);
        } else {
            TLVException.throwIt((short)6);
        }
        if ((short)(vLen + valueLength) > Short.MAX_VALUE) {
            TLVException.throwIt((short)10);
        }
        if (BERTLV.verifyFormatInternal(berTLVArray, bTLVOff, (short)(valueOffset + valueLength - bTLVOff)) >= 0) {
            NativeMethods.checkArrayArgs(vArray, vOff, vLen);
            short offSet = PrimitiveBERTLV.getLengthOffset(berTLVArray, bTLVOff);
            if ((short)(valueLength + vLen) > 127) {
                lengthSizeChange = (berTLVArray[offSet] & 0xFFFFFF80) != -128 ? 2 : 1;
                NativeMethods.checkArrayArgs(berTLVArray, valueOffset, (short)(valueLength + lengthSizeChange + vLen));
                Util.arrayCopy(vArray, vOff, berTLVArray, (short)(valueOffset + valueLength + lengthSizeChange), vLen);
                Util.arrayCopy(berTLVArray, valueOffset, berTLVArray, (short)(valueOffset + lengthSizeChange), valueLength);
                berTLVArray[offSet] = -126;
                valueLength = (short)(valueLength + vLen);
                Util.setShort(berTLVArray, (short)(offSet + 1), valueLength);
                sizeOfLength = 3;
            } else {
                Util.arrayCopy(vArray, vOff, berTLVArray, (short)(valueOffset + valueLength), vLen);
                valueLength = (short)(valueLength + vLen);
                if ((berTLVArray[offSet] & 0xFFFFFF80) == -128) {
                    sizeOfLength = (short)(1 + (berTLVArray[offSet] & 0x7F));
                    if (sizeOfLength == 2) {
                        berTLVArray[(short)(offSet + 1)] = (byte)valueLength;
                    } else {
                        for (short i2 = 1; i2 < (short)(sizeOfLength - 2); i2 = (short)(i2 + 1)) {
                            if (berTLVArray[(short)(offSet + i2)] == 0) continue;
                            Util.setShort(berTLVArray, (short)(offSet + i2), valueLength);
                        }
                    }
                } else {
                    berTLVArray[offSet] = (byte)valueLength;
                    sizeOfLength = 1;
                }
            }
        } else {
            TLVException.throwIt((short)6);
        }
        return (short)(sizeOfLength + valueLength + tagSizeInBytes);
    }
}

