/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.comm;

import com.oracle.tee.tools.util.Closables;
import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.comm.ClassicVMConnection;
import com.sun.javacard.debugproxy.comm.CommListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class StreamVMConnection
implements ClassicVMConnection {
    private Closables manager = new Closables();
    private InputStream in;
    private OutputStream out;
    private CommListener listener;
    boolean isRunning = true;
    private boolean isDisconnected = false;

    public StreamVMConnection(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.manager.add(in);
        this.manager.add(out);
    }

    public StreamVMConnection(Socket socket) throws IOException {
        try {
            this.manager.add(socket);
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
            this.manager.add(this.in);
            this.manager.add(this.out);
        }
        catch (Exception e) {
            this.manager.close();
        }
    }

    @Override
    public void send(int id, byte[] packet) throws IOException {
        Log.LOG(3, Thread.currentThread().getName() + "VM<-:0x" + Utils.canonize(packet));
        int length = packet.length + 2;
        this.out.write(0xFF & length >> 8);
        this.out.write(0xFF & length);
        this.out.write(0xFF & id >> 8);
        this.out.write(0xFF & id);
        this.out.write(packet);
        this.out.flush();
    }

    @Override
    public void setListener(CommListener listener) {
        this.listener = listener;
    }

    @Override
    public void close() throws IOException {
        this.isRunning = false;
        this.disconnected();
        this.manager.close();
    }

    private void disconnected() {
        if (this.isDisconnected) {
            return;
        }
        this.isDisconnected = true;
        Log.LOG(3, "VM:Disconnected");
        if (this.listener != null) {
            this.listener.vmDisconnected();
        }
    }

    private int readU16(InputStream in) throws IOException {
        return in.read() << 8 | in.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.isRunning) {
                int length = this.readU16(this.in);
                if (length < 0) {
                    Log.LOG(3, "VM->:ERROR length=" + length);
                    return;
                }
                int id = this.readU16(this.in);
                byte[] data = new byte[length - 2];
                if (this.in.read(data) == -1) {
                    throw new IOException("Read failed");
                }
                Log.LOG(3, Thread.currentThread().getName() + " VM->:0x" + Utils.canonize(data));
                if (this.listener == null) continue;
                this.listener.packetFromVMReceived(id, data);
            }
        }
        catch (Exception e) {
            Log.LOG(3, "VM connection closed: " + e.getMessage());
            System.out.flush();
        }
        finally {
            this.disconnected();
        }
    }
}

