/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cli;

import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.tools.util.JCToolsLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Tool {
    private static final String ERROR_MESSAGE_1 = "tool.error.1";
    private static final String ERROR_MESSAGE_2 = "tool.error.2";
    private Hashtable<String, Class<? extends SubCommand>> subCommandHandlers = new Hashtable();
    private Class<? extends SubCommand> selectedSubCommandClass = null;
    private ResourceBundle resourceBundle = null;
    protected JCToolsLogger toolsLogger = null;

    public Tool(String resourceBundlePath) {
        this.resourceBundle = ResourceBundle.getBundle(resourceBundlePath);
        String name = resourceBundlePath.replace("/", ".");
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        this.toolsLogger = JCToolsLogger.getLogger(name, resourceBundlePath);
    }

    public final String getResourceString(String key) {
        return this.resourceBundle.getString(key);
    }

    public final String getFormattedResourceString(String key, Object ... values) {
        String str = this.resourceBundle.getString(key);
        return MessageFormat.format(str, values);
    }

    public final void registerSubCommand(String name, Class<? extends SubCommand> subCommandClass) {
        this.subCommandHandlers.put(name, subCommandClass);
    }

    public final void printLines(String propertyName) {
        try {
            String line = null;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                try {
                    line = this.getResourceString(propertyName + "." + i);
                }
                catch (Exception e) {
                    break;
                }
                line = line.trim();
                if (line.startsWith("\"")) {
                    line = line.substring(1);
                }
                if (line.endsWith("\"")) {
                    line = line.substring(0, line.length() - 1);
                }
                System.out.println(line);
                System.out.flush();
            }
        }
        catch (Exception e) {
            this.toolsLogger.severe("messages.properties file corrupted.", new Object[0]);
        }
    }

    public final int runTool(String[] mainArgs, boolean suppressHeader) throws Exception {
        return this.executeTool(mainArgs, suppressHeader);
    }

    public final int runTool(String[] mainArgs) throws Exception {
        return this.executeTool(mainArgs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int executeTool(String[] mainArgs, boolean suppressHeader) throws Exception {
        if (!suppressHeader) {
            this.printLines("header");
        }
        if (mainArgs.length <= 0) {
            throw new Exception(this.getResourceString(ERROR_MESSAGE_1));
        }
        String commandName = mainArgs[0];
        this.selectedSubCommandClass = this.subCommandHandlers.get(commandName);
        if (this.selectedSubCommandClass == null) {
            throw new Exception(this.getFormattedResourceString(ERROR_MESSAGE_2, commandName));
        }
        String[] commandArgs = null;
        List<String> argsList = Arrays.asList(mainArgs);
        if (argsList.contains("-C") || argsList.contains("--commandoptionsfile")) {
            if (mainArgs.length != 3 || !mainArgs[1].equals("-C") && !mainArgs[1].equals("--commandoptionsfile")) throw new Exception(this.getFormattedResourceString("tool.error.3", new Object[0]));
            FileInputStream fs = null;
            try {
                fs = new FileInputStream(new File(mainArgs[2]).getCanonicalPath());
                commandArgs = this.getArgsFromFile(fs);
            }
            catch (Exception e) {
                this.toolsLogger.severe(e.getMessage(), new Object[0]);
                System.exit(1);
            }
            finally {
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            commandArgs = new String[mainArgs.length - 1];
            System.arraycopy(mainArgs, 1, commandArgs, 0, commandArgs.length);
        }
        SubCommand subCommand = this.selectedSubCommandClass.newInstance();
        subCommand.setResourceBundle(this.resourceBundle);
        subCommand.setLogger(this.toolsLogger);
        subCommand.setup();
        subCommand.parse(commandArgs);
        return subCommand.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getArgsFromFile(FileInputStream file) {
        BufferedReader r = null;
        StringBuilder sb = new StringBuilder();
        try {
            r = new BufferedReader(new InputStreamReader(file));
            String line = null;
            while ((line = r.readLine()) != null) {
                sb.append(line + "\n");
            }
            r.close();
        }
        catch (IOException ioe) {
            this.toolsLogger.severe(ioe.getMessage(), new Object[0]);
            System.exit(1);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {}
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(sb.toString());
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            args.add(s);
        }
        String[] argsArr = new String[args.size()];
        return args.toArray(argsArr);
    }
}

