/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.ServerT1Protocol;
import com.sun.javacard.apduio.T1Exception;
import com.sun.javacard.appletcontainer.APDUDispatcher;
import com.sun.javacard.impl.Constants;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;

public class T1APDUConnection
implements CadServerListener,
Constants {
    private static final short BUFFER_OVERFLOW = -16383;
    private static final short READ_ERROR = -16381;
    private static final short WRITE_ERROR = -16380;
    private static final short INVALID_GET_RESPONSE = -16378;
    private static final byte ACK_NONE = 0;
    private static final byte ACK_INS = 1;
    private static final byte ACK_NOT_INS = 2;
    private static final byte GET_RESPONSE_CLA = 0;
    private static final byte GET_RESPONSE_INS = -64;
    private static final byte GET_RESPONSE_P1 = 0;
    private static final byte GET_RESPONSE_P2 = 0;
    private boolean invalidGetResponse = false;
    public int port = 0;
    public ServerSocketConnection srvSock = null;
    protected ServerT1Protocol t1Protocol;
    private short apduStatus = 0;
    private byte[] command = new byte[5];
    private byte[] t1APDUBuffer = new byte[133];
    private short[] t1Len = new short[2];
    private boolean[] t1Last = new boolean[1];
    private int protocol;
    private static final byte T1_EVENT_NONE = 0;
    private static final byte T1_EVENT_POWERUP = 1;
    private static final byte T1_EVENT_POWERDOWN = 2;

    public T1APDUConnection(int port, int protocol) {
        this.port = port;
        this.protocol = protocol;
        try {
            this.srvSock = (ServerSocketConnection)Connector.open("socket://:" + port);
        }
        catch (Exception iE) {
            System.err.println(iE);
            throw new RuntimeException();
        }
    }

    @Override
    public void powerUp(CadEvent evt) {
    }

    @Override
    public void powerDown(CadEvent evt) {
        this.t1Protocol = null;
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            dispatcher.getChannelManager().deselectAll();
        }
    }

    private ServerT1Protocol getCadT1Dual() {
        if (this.t1Protocol == null) {
            SocketConnection sock = null;
            try {
                sock = (SocketConnection)this.srvSock.acceptAndOpen();
                this.t1Protocol = new ServerT1Protocol(sock.openInputStream(), sock.openOutputStream());
                this.t1Protocol.addCadServerListener(this);
                byte[] ATR = new byte[]{59, -16, 17, 0, -1, (byte)(this.protocol == -111 ? 1 : 0)};
                this.t1Protocol.sendATR(ATR);
            }
            catch (Exception e) {
                System.err.println(e);
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.powerDown(null);
                throw new RuntimeException();
            }
        }
        return this.t1Protocol;
    }

    public short t1SndBlockRcvAck(short offset, short length, boolean isLastBlock) {
        try {
            short status = this.getCadT1Dual().t1SndBlockRcvAck(this.t1APDUBuffer, offset, length, isLastBlock);
            return status;
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
    }

    public short t1RcvBlock(short offset, short dataLimit) {
        try {
            ServerT1Protocol cadObj = this.getCadT1Dual();
            short status = cadObj.t1RcvBlock(this.t1APDUBuffer, this.t1Len, offset, dataLimit);
            if (status < 0) {
                return status;
            }
            return this.t1Len[0];
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
    }

    public short t1RcvBlockDiscardData(short numBytesExpected, short numBytesReceived) {
        try {
            ServerT1Protocol cadObj = this.getCadT1Dual();
            while (!this.t1LastBlockReceived()) {
                short status = cadObj.t1RcvBlock(null, this.t1Len, numBytesExpected, numBytesReceived);
                if (status <= -1) {
                    return status;
                }
                cadObj.discardIncomingGetLe(this.t1Len, numBytesExpected, numBytesExpected);
                numBytesReceived = (short)(numBytesReceived + this.t1Len[0]);
            }
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
        if (numBytesReceived != numBytesExpected && this.t1Len[1] < 0) {
            return -2;
        }
        if (numBytesReceived == numBytesExpected) {
            return -1;
        }
        return this.t1Len[1];
    }

    public short t1Abort() {
        try {
            boolean result = this.getCadT1Dual().t1Abort();
            if (!result) {
                return -1;
            }
            return 0;
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
    }

    public short t1Wait() {
        try {
            boolean result = this.getCadT1Dual().t1Wait();
            if (!result) {
                return -1;
            }
            return 0;
        }
        catch (T1Exception t1e) {
            return (short)(t1e.getStatus() & 0xFFFF);
        }
    }

    public byte t1GetNAD() {
        return this.getCadT1Dual().t1GetNAD();
    }

    public boolean t1LastBlockReceived() {
        return this.getCadT1Dual().t1LastBlockReceived();
    }

    public short t1GetIFSC() {
        return this.getCadT1Dual().t1GetIFSC();
    }

    public short t1GetIFSD() {
        return this.getCadT1Dual().t1GetIFSD();
    }

    public byte[] t1InitAPDUBuffer() {
        return this.t1APDUBuffer;
    }
}

