/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.javacard.impl.NativeMethods;
import com.sun.midp.io.BaseInputStream;
import com.sun.midp.io.BaseOutputStream;
import com.sun.midp.io.HttpUrl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javacardx.framework.TransientReference;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public abstract class ConnectionBaseAdapter
implements ConnectionBaseInterface,
StreamConnection {
    protected TransientReference<Object> stateRef = null;
    protected int iStreams = 0;
    protected int maxIStreams = 1;
    protected int oStreams = 0;
    protected int maxOStreams = 1;
    protected int requiredPermission = -1;
    protected String protocol;
    private boolean permissionChecked;

    protected boolean connectionOpen() {
        return this.stateRef != null && this.stateRef.get() != null;
    }

    protected void setStateOpen() {
        this.stateRef = new TransientReference<ConnectionBaseAdapter>(this);
    }

    protected void setStateClose() {
        this.stateRef = null;
    }

    @Override
    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\"");
        }
        HttpUrl url = new HttpUrl(this.protocol, name);
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode");
            }
        }
        this.connect(name, mode, timeouts);
        this.setStateOpen();
        return this;
    }

    public Connection openPrim(String name) throws IOException {
        return this.openPrim(name, 3, false);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        if (this.maxIStreams == 0) {
            throw new IOException("no more input streams available");
        }
        BaseInputStream i = new BaseInputStream(this);
        --this.maxIStreams;
        ++this.iStreams;
        return i;
    }

    @Override
    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        if (this.maxOStreams == 0) {
            throw new IOException("no more output streams available");
        }
        BaseOutputStream o = new BaseOutputStream(this);
        --this.maxOStreams;
        ++this.oStreams;
        return o;
    }

    @Override
    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    protected abstract void reset();

    @Override
    public void close() throws IOException {
        if (this.connectionOpen()) {
            this.reset();
            this.setStateClose();
            this.closeCommon();
        }
        NativeMethods.removeConnection(this);
    }

    protected void closeInputStream() throws IOException {
        --this.iStreams;
        this.closeCommon();
    }

    protected void closeOutputStream() throws IOException {
        --this.oStreams;
        this.closeCommon();
    }

    void closeCommon() throws IOException {
        if (!this.connectionOpen() && this.iStreams == 0 && this.oStreams == 0) {
            this.disconnect();
        }
    }

    protected void ensureOpen() throws IOException {
        if (!this.connectionOpen()) {
            throw new IOException("Connection closed");
        }
    }

    protected abstract void connect(String var1, int var2, boolean var3) throws IOException;

    protected abstract void disconnect() throws IOException;

    protected abstract int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int available() throws IOException {
        return 0;
    }

    protected abstract int writeBytes(byte[] var1, int var2, int var3) throws IOException;

    protected void flush() throws IOException {
    }
}

