/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework.tlv;

import com.sun.javacard.impl.NativeMethods;
import javacard.framework.Util;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.tlv.BERTag;
import javacardx.framework.tlv.ConstructedBERTLV;
import javacardx.framework.tlv.PrimitiveBERTLV;
import javacardx.framework.tlv.TLVException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class BERTLV {
    static final byte PRIMITIVE_TLV = 0;
    static final byte CONSTRUCTED_TLV = 32;
    static final byte MORE_BYTES_CHECK = -128;
    static final byte LENGTH_VALUE_MASK = 127;
    static final byte TAG_MASK = 31;
    static final byte EXTENDED_FORMAT = -128;
    static final byte INDEFINITE_FORMAT = -128;
    static final byte MAX_TAG_SIZE = 3;
    static final byte MAX_ONE_BYTE_LENGTH = 127;
    static final short MAX_TLV_SIZE = Short.MAX_VALUE;
    static final byte FIRST_BYTE_LONG_LENGTH = -126;
    static final byte TLV_ARRAY_EXPANSION_INCREMENT = 8;
    static final byte VALUE_INCREMENT = 4;
    static final byte APPEND = 1;
    static final byte REPLACE = 2;
    static final byte MALFORMED_LENGTH = -3;
    static final byte LENGTH_NOT_IN_LIMITS = -4;
    BERTag theBERTag = null;
    BERTLV[] berTLV = null;
    short numTLVs;
    short numDeletedTLVs;
    byte[] theValue = null;
    short valueLength;
    boolean emptyTLV = true;

    protected BERTLV() {
    }

    public abstract short init(byte[] var1, short var2, short var3) throws TLVException;

    public static BERTLV getInstance(byte[] bArray, short bOff, short bLen) throws TLVException {
        BERTLV instance = null;
        NativeMethods.checkArrayArgs(bArray, bOff, bLen);
        if (bLen > Short.MAX_VALUE) {
            TLVException.throwIt((short)2);
        }
        if (!BERTLV.verifyFormat(bArray, bOff, bLen)) {
            TLVException.throwIt((short)6);
        }
        if ((bArray[bOff] & 0x20) != 0) {
            instance = new ConstructedBERTLV(8);
            instance.init(bArray, bOff, bLen);
        } else {
            instance = new PrimitiveBERTLV(bLen);
            instance.init(bArray, bOff, bLen);
        }
        return instance;
    }

    public short toBytes(byte[] outBuf, short bOff) {
        if (this.emptyTLV) {
            TLVException.throwIt((short)4);
        }
        short valueLen = this.getLength();
        short totalLength = (short)(this.theBERTag.size() + valueLen + BERTLV.getValueLengthSize(valueLen));
        NativeMethods.checkArrayArgs(outBuf, bOff, valueLen);
        if (totalLength > Short.MAX_VALUE) {
            TLVException.throwIt((short)10);
        }
        short valueOffset = (short)(bOff + this.theBERTag.toBytes(outBuf, bOff));
        if (valueLen > 127) {
            outBuf[valueOffset] = -126;
            valueOffset = (short)(valueOffset + 3);
            Util.setShort(outBuf, valueOffset, valueLen);
        } else {
            outBuf[valueOffset] = (byte)valueLen;
            valueOffset = (short)(valueOffset + 1);
        }
        if (this.theBERTag.isConstructed()) {
            for (short i = 0; i < this.numTLVs; i = (short)(i + 1)) {
                if (this.berTLV[i] == null) continue;
                valueOffset = (short)(valueOffset + this.berTLV[i].toBytes(outBuf, valueOffset));
            }
            return (short)(valueOffset - bOff);
        }
        Util.arrayCopy(this.theValue, (short)0, outBuf, valueOffset, valueLen);
        return (short)(valueOffset + valueLen - bOff);
    }

    public BERTag getTag() throws TLVException {
        if (this.emptyTLV) {
            TLVException.throwIt((short)4);
        }
        return this.theBERTag;
    }

    public short getLength() throws TLVException {
        short valueLen = 0;
        if (this.emptyTLV) {
            TLVException.throwIt((short)4);
        }
        valueLen = this.theBERTag.isConstructed() ? this.getLengthInternal(false) : this.valueLength;
        if ((short)(this.theBERTag.size() + valueLen + BERTLV.getValueLengthSize(valueLen)) > Short.MAX_VALUE) {
            TLVException.throwIt((short)10);
        }
        return valueLen;
    }

    public short size() {
        short valueLen = 0;
        if (this.emptyTLV) {
            TLVException.throwIt((short)4);
        }
        valueLen = this.theBERTag.isConstructed() ? this.getLength() : this.valueLength;
        valueLen = (short)(this.theBERTag.size() + valueLen + BERTLV.getValueLengthSize(valueLen));
        if (valueLen > Short.MAX_VALUE) {
            TLVException.throwIt((short)10);
        }
        return valueLen;
    }

    public static boolean verifyFormat(byte[] berTlvArray, short bOff, short bLen) {
        try {
            return BERTLV.verifyFormatInternal(berTlvArray, bOff, bLen) >= 0;
        }
        catch (TLVException e) {
            return false;
        }
    }

    static short verifyFormatInternal(byte[] berTlvArray, short bOff, short bLen) {
        int numTlv = 0;
        NativeMethods.checkArrayArgs(berTlvArray, bOff, bLen);
        short nextTagLengthOffSet = bOff;
        if (bLen < 2) {
            return -3;
        }
        short firstValueLen = BERTLV.getLength(berTlvArray, nextTagLengthOffSet);
        short firstValueOffset = BERTLV.getValueOffsetInternal(berTlvArray, nextTagLengthOffSet);
        if (firstValueLen == 1 && BERTag.isConstructed(berTlvArray, bOff)) {
            return -3;
        }
        if (bLen == 2 && firstValueLen > 0) {
            return -3;
        }
        while (nextTagLengthOffSet < (short)(bLen + bOff)) {
            if (BERTag.isConstructed(berTlvArray, nextTagLengthOffSet)) {
                short intValueLen = BERTLV.getLength(berTlvArray, nextTagLengthOffSet);
                if (intValueLen == 1) {
                    return -3;
                }
                if ((nextTagLengthOffSet = BERTLV.verifyTagAndLength(berTlvArray, nextTagLengthOffSet)) < 0) {
                    return nextTagLengthOffSet;
                }
                if ((short)(bLen + bOff) < nextTagLengthOffSet) {
                    return -3;
                }
                short intOffSet = nextTagLengthOffSet;
                if ((short)(bLen + bOff) != (short)(nextTagLengthOffSet + firstValueLen)) {
                    while (nextTagLengthOffSet < (short)(intValueLen + intOffSet)) {
                        if ((nextTagLengthOffSet = BERTLV.verifyTagAndLength(berTlvArray, nextTagLengthOffSet)) < 0) {
                            return nextTagLengthOffSet;
                        }
                        if ((short)(bLen + bOff) >= nextTagLengthOffSet) continue;
                        return -3;
                    }
                }
            } else {
                if ((nextTagLengthOffSet = BERTLV.verifyTagAndLength(berTlvArray, nextTagLengthOffSet)) < 0) {
                    return nextTagLengthOffSet;
                }
                if ((short)(bLen + bOff) < nextTagLengthOffSet) {
                    return -3;
                }
            }
            numTlv = (short)(numTlv + 1);
        }
        return (short)(numTlv - 1);
    }

    public static short getTag(byte[] berTLVArray, short bTLVOff, byte[] berTagArray, short bTagOff) throws TLVException {
        NativeMethods.checkArrayArgs(berTLVArray, bTLVOff, (short)(berTLVArray.length - bTLVOff));
        NativeMethods.checkArrayArgs(berTagArray, bTagOff, (short)(berTagArray.length - bTagOff));
        short retStatus = BERTLV.verifyTagAndLength(berTLVArray, bTLVOff);
        if (retStatus == -1) {
            TLVException.throwIt((short)6);
        } else if (retStatus == -2) {
            TLVException.throwIt((short)2);
        } else if (retStatus == -3) {
            TLVException.throwIt((short)6);
        } else if (retStatus == -4) {
            TLVException.throwIt((short)6);
        }
        berTagArray[bTagOff] = berTLVArray[bTLVOff];
        short tagSizeInBytes = 1;
        if ((berTLVArray[bTLVOff] & 0x1F) == 31) {
            berTagArray[(short)(bTagOff + tagSizeInBytes)] = berTLVArray[(short)(bTLVOff + tagSizeInBytes)];
            if ((berTLVArray[(short)(bTLVOff + (tagSizeInBytes = (short)(tagSizeInBytes + 1)) - 1)] & 0xFFFFFF80) == -128) {
                berTagArray[(short)(bTagOff + tagSizeInBytes)] = berTLVArray[(short)(bTLVOff + tagSizeInBytes)];
                tagSizeInBytes = (short)(tagSizeInBytes + 1);
            }
        }
        return tagSizeInBytes;
    }

    public static short getLength(byte[] berTLVArray, short bOff) throws TLVException {
        short sizeOfLength;
        NativeMethods.checkArrayArgs(berTLVArray, bOff, (short)(berTLVArray.length - bOff));
        short offSet = BERTLV.verifyTagAndLength(berTLVArray, bOff);
        if (offSet == -1) {
            TLVException.throwIt((short)6);
        } else if (offSet == -2) {
            TLVException.throwIt((short)11);
        } else if (offSet == -3) {
            TLVException.throwIt((short)6);
        } else if (offSet == -4) {
            NativeMethods.checkArrayArgs(berTLVArray, bOff, (short)(berTLVArray.length + 1));
        }
        offSet = BERTLV.getLengthOffset(berTLVArray, bOff);
        short valueLen = (berTLVArray[offSet] & 0xFFFFFF80) == -128 ? ((sizeOfLength = (short)((berTLVArray[offSet] & 0x7F) + 1)) > 2 ? Util.getShort(berTLVArray, (short)(offSet + sizeOfLength - 2)) : (short)(berTLVArray[(short)(offSet + 1)] & 0xFF)) : (short)berTLVArray[offSet];
        return valueLen;
    }

    static short getValueLengthSize(short valueLength) {
        return valueLength < 127 ? (short)1 : 3;
    }

    static short getLengthOffset(byte[] berTlvArray, short bOff) {
        short offSet = (berTlvArray[bOff] & 0x1F) == 31 ? ((berTlvArray[(short)(bOff + 1)] & 0xFFFFFF80) == -128 ? (short)(3 + bOff) : (short)(2 + bOff)) : (short)(1 + bOff);
        return offSet;
    }

    static short getValueOffsetInternal(byte[] berTlvArray, short bOff) {
        short offSet = BERTLV.getLengthOffset(berTlvArray, bOff);
        if ((berTlvArray[offSet] & 0xFFFFFF80) == -128) {
            return (short)((short)(berTlvArray[offSet] & 0x7F & 0xFF) + offSet + 1);
        }
        return (short)(offSet + 1);
    }

    static short getSizeOfLength(byte[] berTLVArray, short bOff) {
        short returnSize = 0;
        short offSet = BERTLV.getLengthOffset(berTLVArray, bOff);
        returnSize = (berTLVArray[offSet] & 0xFFFFFF80) == -128 ? (short)((berTLVArray[offSet] & 0x7F) + 1) : (short)1;
        return returnSize;
    }

    static short verifyTagAndLength(byte[] berTlvArray, short bOff) {
        short offSet = 0;
        short tagNumber = BERTag.verifyFormatInternal(berTlvArray, bOff);
        if (tagNumber < 0) {
            return tagNumber;
        }
        offSet = BERTag.getTagSize(tagNumber);
        if (berTlvArray.length < (short)(bOff + offSet)) {
            return -4;
        }
        if (berTlvArray[(short)(bOff + offSet)] == -1 || berTlvArray[(short)(bOff + offSet)] == -128) {
            return -3;
        }
        if ((berTlvArray[(short)(bOff + offSet)] & 0xFFFFFF80) == -128) {
            short i;
            short sizeOfLength = (short)((berTlvArray[(short)(bOff + offSet)] & 0x7F & 0xFF) + 1);
            if (berTlvArray.length < (short)(bOff + offSet + sizeOfLength)) {
                return -4;
            }
            if (sizeOfLength > 3) {
                for (i = 1; i < (short)(sizeOfLength - 2); i = (short)(i + 1)) {
                    if (berTlvArray[(short)(bOff + offSet + i)] == 0) continue;
                    return -2;
                }
            }
            if ((i = sizeOfLength > 2 ? Util.getShort(berTlvArray, (short)(bOff + offSet + sizeOfLength - 2)) : (short)(berTlvArray[(short)(bOff + offSet + 1)] & 0xFF)) < 0) {
                return -2;
            }
            offSet = (berTlvArray[bOff] & 0x20) != 0 ? (short)(offSet + sizeOfLength) : (short)(offSet + (short)(sizeOfLength + i));
        } else {
            offSet = (berTlvArray[bOff] & 0x20) != 0 ? (short)(offSet + 1) : (short)(offSet + (short)(1 + berTlvArray[(short)(bOff + offSet)]));
        }
        return (short)(bOff + offSet);
    }

    short getLengthInternal(boolean isInnerTLV) {
        short lastTLV = (short)(this.numTLVs + this.numDeletedTLVs);
        short valueLen = 0;
        for (short i = 0; i < lastTLV; i = (short)(i + 1)) {
            if (this.berTLV[i] == null) continue;
            valueLen = this.berTLV[i] instanceof ConstructedBERTLV ? (short)(valueLen + this.berTLV[i].getLengthInternal(true)) : (short)(valueLen + this.berTLV[i].size());
        }
        if (isInnerTLV) {
            valueLen = (short)(valueLen + (short)(this.theBERTag.size() + BERTLV.getValueLengthSize(valueLen)));
        }
        return valueLen;
    }

    boolean contains(BERTLV aTLV) {
        short lastTLV = (short)(this.numTLVs + this.numDeletedTLVs);
        if (this.equals(aTLV)) {
            return true;
        }
        for (short i = 0; i < lastTLV; i = (short)(i + 1)) {
            if (this.berTLV[i] == null || !(this.berTLV[i] instanceof ConstructedBERTLV ? this.berTLV[i].contains(aTLV) : this.berTLV[i].equals(aTLV))) continue;
            return true;
        }
        return false;
    }
}

