/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import com.sun.javacard.Logger;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.jetty.security.Password;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class Credential {
    public abstract boolean check(Object var1);

    public static Credential getCredential(String credential) {
        if (credential.startsWith("MD5:")) {
            return new MD5(credential);
        }
        return new Password(credential);
    }

    public static class MD5
    extends Credential {
        public static final String TYPE = "MD5:";
        private static com.sun.spot.security.implementation.MD5 md;
        private byte[] adigest;

        MD5(String digest) {
            digest = digest.startsWith(TYPE) ? digest.substring(TYPE.length()) : digest;
            this.adigest = TypeUtil.parseBytes(digest, 16);
        }

        public byte[] getDigest() {
            return this.adigest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean check(Object credentials) {
            try {
                byte[] digest = new byte[16];
                if (credentials instanceof Password || credentials instanceof String) {
                    String string = TYPE;
                    synchronized (TYPE) {
                        if (md == null) {
                            md = new com.sun.spot.security.implementation.MD5();
                        }
                        md.reset();
                        md.update(credentials.toString().getBytes(StringUtil.ISO_8859_1), 0, credentials.toString().getBytes(StringUtil.ISO_8859_1).length);
                        md.digest(digest, 0, 16);
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        if (digest == null || digest.length != this.adigest.length) {
                            return false;
                        }
                        for (int i = 0; i < digest.length; ++i) {
                            if (digest[i] == this.adigest[i]) continue;
                            return false;
                        }
                        return true;
                    }
                }
                if (credentials instanceof MD5) {
                    MD5 md5 = (MD5)credentials;
                    if (this.adigest.length != md5.adigest.length) {
                        return false;
                    }
                    for (int i = 0; i < this.adigest.length; ++i) {
                        if (this.adigest[i] == md5.adigest[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (credentials instanceof Credential) {
                    return ((Credential)credentials).check(this);
                }
                Logger.debug("Can't check " + credentials.getClass() + " against MD5");
                return false;
            }
            catch (Exception e) {
                Logger.debug(e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String digest(String password) {
            try {
                byte[] digest = new byte[16];
                String string = TYPE;
                synchronized (TYPE) {
                    if (md == null) {
                        try {
                            md = new com.sun.spot.security.implementation.MD5();
                        }
                        catch (Exception e) {
                            Logger.debug(e);
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return null;
                        }
                    }
                    md.reset();
                    md.update(password.getBytes(StringUtil.ISO_8859_1), 0, password.getBytes(StringUtil.ISO_8859_1).length);
                    md.digest(digest, 0, 16);
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return TYPE + TypeUtil.toString(digest, 16);
                }
            }
            catch (Exception e) {
                Logger.debug(e);
                return null;
            }
        }
    }
}

