/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.aram;

import javacard.framework.JCSystem;
import javacard.framework.Util;

public class RuleEntry {
    private RuleEntry next;
    private static RuleEntry first;
    private static RuleEntry deleted;
    private byte[] aid = new byte[16];
    private byte[] hash = new byte[32];
    private byte[] rule = new byte[162];
    private byte aidLength;
    private byte hashLength;
    private byte ruleLength;

    private RuleEntry() {
        this.next = first;
        first = this;
    }

    static RuleEntry getInstance() {
        if (deleted == null) {
            return new RuleEntry();
        }
        RuleEntry instance = deleted;
        deleted = instance.next;
        instance.next = first;
        first = instance;
        return instance;
    }

    static RuleEntry searchAid(byte[] buf, short ofs, byte len) {
        RuleEntry re = first;
        while (re != null) {
            if (re.aidLength == len && Util.arrayCompare((byte[])re.aid, (short)0, (byte[])buf, (short)ofs, (short)len) == 0) {
                return re;
            }
            re = re.next;
        }
        return null;
    }

    static RuleEntry searchAidHash(byte[] buf, short aidOfs, byte aidLen, short hashOfs, byte hashLen) {
        RuleEntry re = first;
        while (re != null) {
            if (re.aidLength == aidLen && re.hashLength == hashLen && Util.arrayCompare((byte[])re.aid, (short)0, (byte[])buf, (short)aidOfs, (short)aidLen) == 0 && Util.arrayCompare((byte[])re.hash, (short)0, (byte[])buf, (short)hashOfs, (short)hashLen) == 0) {
                return re;
            }
            re = re.next;
        }
        return null;
    }

    static RuleEntry searchAidHashRule(byte[] buf, short aidOfs, byte aidLen, short hashOfs, byte hashLen, short ruleOfs, byte ruleLen) {
        RuleEntry re = first;
        while (re != null) {
            if (re.aidLength == aidLen && re.hashLength == hashLen && re.ruleLength == ruleLen && Util.arrayCompare((byte[])re.aid, (short)0, (byte[])buf, (short)aidOfs, (short)aidLen) == 0 && Util.arrayCompare((byte[])re.hash, (short)0, (byte[])buf, (short)hashOfs, (short)hashLen) == 0 && Util.arrayCompare((byte[])re.rule, (short)0, (byte[])buf, (short)ruleOfs, (short)ruleLen) == 0) {
                return re;
            }
            re = re.next;
        }
        return null;
    }

    public static RuleEntry getFirst() {
        return first;
    }

    private void remove() {
        if (first == this) {
            first = this.next;
        } else {
            RuleEntry re = first;
            while (re != null) {
                if (re.next == this) {
                    re.next = this.next;
                }
                re = re.next;
            }
        }
    }

    private void recycle() {
        this.next = deleted;
        this.aidLength = 0;
        this.hashLength = 0;
        this.ruleLength = 0;
        deleted = this;
    }

    static void deleteAll() {
        RuleEntry re = first;
        while (re != null) {
            JCSystem.beginTransaction();
            re.remove();
            re.recycle();
            JCSystem.commitTransaction();
            re = first;
        }
    }

    static void deleteAid(byte[] buf, short ofs, byte len) {
        RuleEntry re = RuleEntry.searchAid(buf, ofs, len);
        while (re != null) {
            JCSystem.beginTransaction();
            re.remove();
            re.recycle();
            JCSystem.commitTransaction();
            re = RuleEntry.searchAid(buf, ofs, len);
        }
    }

    static void deleteAidHash(byte[] buf, short aidOfs, byte aidLen, short hashOfs, byte hashLen) {
        RuleEntry re = RuleEntry.searchAidHash(buf, aidOfs, aidLen, hashOfs, hashLen);
        while (re != null) {
            JCSystem.beginTransaction();
            re.remove();
            re.recycle();
            JCSystem.commitTransaction();
            re = RuleEntry.searchAidHash(buf, aidOfs, aidLen, hashOfs, hashLen);
        }
    }

    static void deleteAidHashRule(byte[] buf, short aidOfs, byte aidLen, short hashOfs, byte hashLen, short ruleOfs, byte ruleLen) {
        RuleEntry re = RuleEntry.searchAidHashRule(buf, aidOfs, aidLen, hashOfs, hashLen, ruleOfs, ruleLen);
        while (re != null) {
            JCSystem.beginTransaction();
            re.remove();
            re.recycle();
            JCSystem.commitTransaction();
            re = RuleEntry.searchAidHashRule(buf, aidOfs, aidLen, hashOfs, hashLen, ruleOfs, ruleLen);
        }
    }

    short getAid(byte[] buf, short ofs) {
        Util.arrayCopy((byte[])this.aid, (short)0, (byte[])buf, (short)ofs, (short)this.aidLength);
        return (short)(ofs + this.aidLength);
    }

    short getAid(byte[] buf, short ofs, short dataOffset, short dataOffsetMax) {
        return this.getOffsetData(this.aidLength, this.aid, buf, ofs, dataOffset, dataOffsetMax);
    }

    short getHash(byte[] buf, short ofs) {
        Util.arrayCopy((byte[])this.hash, (short)0, (byte[])buf, (short)ofs, (short)this.hashLength);
        return (short)(ofs + this.hashLength);
    }

    short getHash(byte[] buf, short ofs, short dataOffset, short dataOffsetMax) {
        return this.getOffsetData(this.hashLength, this.hash, buf, ofs, dataOffset, dataOffsetMax);
    }

    short getRule(byte[] buf, short ofs) {
        Util.arrayCopy((byte[])this.rule, (short)0, (byte[])buf, (short)ofs, (short)this.ruleLength);
        return (short)(ofs + this.ruleLength);
    }

    short getRule(byte[] buf, short ofs, short dataOffset, short dataOffsetMax) {
        return this.getOffsetData(this.ruleLength, this.rule, buf, ofs, dataOffset, dataOffsetMax);
    }

    short getOffsetData(byte dataLength, byte[] data, byte[] buf, short ofs, short dataOffset, short dataOffsetMax) {
        if (ofs >= dataOffset && ofs < dataOffsetMax) {
            if (dataLength <= (short)(dataOffsetMax - ofs)) {
                Util.arrayCopy((byte[])data, (short)0, (byte[])buf, (short)((short)(ofs - dataOffset)), (short)dataLength);
            } else {
                Util.arrayCopy((byte[])data, (short)0, (byte[])buf, (short)((short)(ofs - dataOffset)), (short)((short)(dataOffsetMax - ofs)));
            }
        } else if ((short)(ofs + dataLength) > dataOffset && (short)(ofs + dataLength) < dataOffsetMax) {
            Util.arrayCopy((byte[])data, (short)((short)(dataOffset - ofs)), (byte[])buf, (short)0, (short)((short)(dataLength - (dataOffset - ofs))));
        }
        return (short)(ofs + dataLength);
    }

    public byte getAidLength() {
        return this.aidLength;
    }

    public byte getHashLength() {
        return this.hashLength;
    }

    public byte getRuleLength() {
        return this.ruleLength;
    }

    public RuleEntry getNext() {
        return this.next;
    }

    public void setAid(byte[] buf, short ofs, byte len) {
        Util.arrayCopy((byte[])buf, (short)ofs, (byte[])this.aid, (short)0, (short)len);
        this.aidLength = len;
    }

    public void setHash(byte[] buf, short ofs, byte len) {
        Util.arrayCopy((byte[])buf, (short)ofs, (byte[])this.hash, (short)0, (short)len);
        this.hashLength = len;
    }

    public void setRule(byte[] buf, short ofs, byte len) {
        Util.arrayCopy((byte[])buf, (short)ofs, (byte[])this.rule, (short)0, (short)len);
        this.ruleLength = len;
    }
}

