/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.RemoteInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.SafeptrError;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class ClassComponent
extends Safeptr {
    static final int MAX_SUPER_INTERFACE_COUNT = 14;
    static Vector<String> classNamesVector = new Vector();
    int classInterfaceInfoOffset;
    Safeptr signaturePool;
    private TreeSet<OffsetAndLength> allClasses;

    ClassComponent(byte[] data) {
        super(data, "Class");
    }

    public ClassInfo infoOfs(int ofs) {
        return new ClassInfo(this.offset(ofs));
    }

    void verify() {
        classNamesVector.clear();
        if (Cap.capMinorVersion == 2) {
            int signaturePoolLength = this.u2(0);
            this.classInterfaceInfoOffset = signaturePoolLength + 2;
            this.signaturePool = this.offset(2);
            this.verifySignaturePool(signaturePoolLength);
        }
        if (Verifier.verbose >= 2) {
            Messages.println("ClassComponent.100");
        }
        this.allClasses = new TreeSet();
        ClassDescriptor cdesc = Cap.Descriptor.firstClassDescriptor();
        for (int i = Cap.Descriptor.classCount(); i > 0; --i) {
            ClassInfo cinfo = this.infoOfs(cdesc.thisClass());
            try {
                this.verifyClass(cdesc, cinfo);
            }
            catch (SafeptrError e) {
                throw new SafeptrError("ClassComponent.1", cdesc, cinfo, e.getMessage(), e);
            }
            catch (VerifierError e) {
                throw new VerifierError("ClassComponent.1", (Object)cdesc, (Object)cinfo, (Object)e.getMessage());
            }
            cdesc.next();
        }
        this.verifyOverlap();
        this.allClasses = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyClass(ClassDescriptor cdesc, ClassInfo cinfo) {
        int len;
        boolean isActuallyRemote = false;
        int remoteDataLength = 0;
        if (Cap.capMinorVersion == 2 ? (cinfo.flags() & 0xFFFFFFF1) != 0 : (cinfo.flags() & 0xFFFFFFF3) != 0) {
            throw new VerifierError("ClassComponent.2", cinfo.flags());
        }
        if ((cdesc.flags() & 0x40) != 0) {
            if ((cinfo.flags() & 8) == 0) {
                throw new VerifierError("ClassComponent.4");
            }
        } else if ((cinfo.flags() & 8) != 0) {
            throw new VerifierError("ClassComponent.7");
        }
        if (Cap.capMinorVersion == 2) {
            boolean claimsToBeRemote = (cinfo.flags() & 2) != 0;
            isActuallyRemote = false;
            isActuallyRemote = (cinfo.flags() & 8) != 0 ? Classref.isRemote(cdesc.thisClass(), false) : Classref.isRemote(cdesc.thisClass(), true);
            if (claimsToBeRemote && !isActuallyRemote) {
                throw new VerifierError("RemoteInfoError.2");
            }
            isActuallyRemote = claimsToBeRemote;
            if (isActuallyRemote && !Cap.Header.hasName) {
                throw new VerifierError("RemoteInfoError.3");
            }
        }
        boolean claimsToBeShareable = (cinfo.flags() & 4) != 0;
        boolean isActuallyShareable = false;
        if (Classref.Shareable != -1) {
            isActuallyShareable = (cinfo.flags() & 8) != 0 ? Classref.extendsInterface(cdesc.thisClass(), Classref.Shareable) : Classref.implementsInterface(cdesc.thisClass(), Classref.Shareable);
        }
        if (claimsToBeShareable != isActuallyShareable) {
            throw new VerifierError("ClassComponent.3");
        }
        if ((cdesc.flags() & 0x40) != 0) {
            if (cinfo.interfaceCount() > 14) {
                throw new SafeptrError("ClassComponent.11", cdesc);
            }
            TreeSet<Integer> claimedSuperIntf = new TreeSet<Integer>();
            TreeSet<Integer> actualSuperIntf = new TreeSet<Integer>();
            for (int j = 0; j < cinfo.interfaceCount(); ++j) {
                int supintf = cinfo.superinterface(j);
                int flags = Classref.checkAndGetAccessFlags(supintf);
                if ((flags & 0x40) == 0) {
                    throw new VerifierError("ClassComponent.5", supintf);
                }
                if (!Classref.isExternal(supintf) && supintf >= cdesc.thisClass()) {
                    throw new VerifierError("ClassComponent.41");
                }
                if (!claimedSuperIntf.add(new Integer(supintf))) {
                    throw new VerifierError("ClassComponent.51", supintf);
                }
                this.addSuperInterfaces(actualSuperIntf, supintf);
            }
            if (!claimedSuperIntf.equals(actualSuperIntf)) {
                throw new VerifierError("ClassComponent.50");
            }
            if (isActuallyRemote) {
                RemoteInfo.verifyRemoteInterface(cdesc);
                int nameLength = cinfo.interfaceNamelength();
                if (nameLength <= 0) throw new VerifierError("RemoteInfoError.10");
                Safeptr interfaceNameBytes = cinfo.interfaceName();
                String interfaceName = ClassInfo.getStringFromBytes(nameLength, interfaceNameBytes);
                if (interfaceName.indexOf("/") > -1 || !EfNames.validClassName(interfaceName)) {
                    throw new VerifierError("RemoteInfoError.11", interfaceName);
                }
                if (classNamesVector.contains(interfaceName)) {
                    throw new VerifierError("RemoteInfoError.14", interfaceName);
                }
                classNamesVector.add(interfaceName);
            }
        } else {
            int j;
            int j2;
            int supclass = cinfo.superclass();
            if (supclass == 65535) {
                if (Cap.Import != null && Cap.Import.count() != 0 || cdesc.token() != 0) {
                    throw new VerifierError("ClassComponent.8");
                }
            } else {
                int flags = Classref.checkAndGetAccessFlags(supclass);
                if ((flags & 0x40) != 0) {
                    throw new VerifierError("ClassComponent.9", supclass);
                }
                if ((flags & 0x10) != 0) {
                    throw new VerifierError("ClassComponent.10", supclass);
                }
                if (!Classref.isExternal(supclass) && supclass >= cdesc.thisClass()) {
                    throw new VerifierError("ClassComponent.42");
                }
            }
            TreeSet<OffsetAndLength> allInstanceFields = new TreeSet<OffsetAndLength>();
            for (j2 = 0; j2 < cdesc.fieldCount(); ++j2) {
                this.checkClassField(cinfo, cdesc.fieldDescr(j2), allInstanceFields);
            }
            this.verifyTokenOverlap(allInstanceFields, cinfo.declaredInstanceSize());
            this.checkFieldTokenOrdering(cdesc);
            if (cinfo.referenceCount() == 0 && cinfo.firstReferenceIndex() != 255) {
                throw new VerifierError("ClassComponent.38");
            }
            if (Classref.totalInstanceSize(cinfo.ofs) > 255) {
                throw new VerifierError("ClassComponent.53");
            }
            for (j2 = 0; j2 < cinfo.publicMethodCount(); ++j2) {
                this.checkClassMethod(cdesc, cinfo, cinfo.publicMethod(j2), cinfo.publicMethodBase() + j2, false);
            }
            for (j2 = 0; j2 < cinfo.packageMethodCount(); ++j2) {
                this.checkClassMethod(cdesc, cinfo, cinfo.packageMethod(j2), cinfo.packageMethodBase() + j2 + 128, true);
            }
            for (j2 = 0; j2 < cinfo.publicMethodBase(); ++j2) {
                this.checkClassMethod(cdesc, cinfo, 65535, j2, false);
            }
            for (j2 = 0; j2 < cinfo.packageMethodBase(); ++j2) {
                this.checkClassMethod(cdesc, cinfo, 65535, j2 + 128, false);
            }
            TreeSet<Integer> implementedInterfaces = new TreeSet<Integer>();
            ImplementedInterface p = cinfo.firstImplementedInterface();
            for (j = cinfo.interfaceCount(); j > 0; --j) {
                if (!implementedInterfaces.add(new Integer(p.interfaceImpl()))) {
                    throw new VerifierError("ClassComponent.52", p.interfaceImpl());
                }
                ClassComponent.checkClassImplIntf(cdesc, cinfo, p);
                p.next();
            }
            for (j = 0; j < cdesc.interfaceCount(); ++j) {
                if (ClassComponent.classInfoImplementsInterface(cdesc.thisClass(), cdesc.interfaceRef(j))) continue;
                throw new VerifierError("ClassComponent.40", cdesc.interfaceRef(j));
            }
            if ((cdesc.flags() & 0x80) == 0) {
                ClassComponent.checkMethodsAreProvided(cinfo, 0, cinfo.publicMethodBase(), cinfo.publicMethodCount(), cinfo.publicVtable());
                ClassComponent.checkMethodsAreProvided(cinfo, 128, cinfo.packageMethodBase(), cinfo.packageMethodCount(), cinfo.packageVtable());
            }
            if ((cinfo.flags() & 2) != 0) {
                ImplementedInterface fii = cinfo.firstImplementedInterface();
                for (int j3 = cinfo.interfaceCount(); j3 > 0; --j3) {
                    fii.next();
                }
                int remoteInfoStart = fii.ofs;
                RemoteInfo remoteInfo = new RemoteInfo(this.offset(remoteInfoStart));
                remoteInfo.verifyRemoteInfo(cdesc, cinfo);
                remoteDataLength = remoteInfo.getRemoteDataLength();
            }
        }
        if ((cdesc.flags() & 0x40) == 0) {
            ImplementedInterface p = cinfo.firstImplementedInterface();
            for (int j = cinfo.interfaceCount(); j > 0; --j) {
                p.next();
            }
            len = p.ofs + remoteDataLength - cinfo.ofs;
        } else {
            len = (cinfo.flags() & 2) == 0 ? 1 + 2 * cinfo.interfaceCount() : 2 + 2 * cinfo.interfaceCount() + cinfo.interfaceNamelength();
        }
        if (this.allClasses.add(new OffsetAndLength(cinfo.ofs, len))) return;
        throw new VerifierError("ClassComponent.31");
    }

    private void checkClassField(ClassInfo cinfo, FieldDescriptor f, TreeSet<OffsetAndLength> allInstanceFields) {
        if ((f.flags() & 8) != 0) {
            return;
        }
        int typOfs = f.type();
        int fieldsize = typOfs == 32773 ? 2 : 1;
        int token = f.token();
        if (token + fieldsize > cinfo.declaredInstanceSize()) {
            throw new VerifierError("ClassComponent.13", token, (Object)f);
        }
        if ((typOfs & 0x8000) == 0) {
            if (cinfo.firstReferenceIndex() == 255) {
                throw new VerifierError("ClassComponent.35");
            }
            if (token < cinfo.firstReferenceIndex() || token >= cinfo.firstReferenceIndex() + cinfo.referenceCount()) {
                throw new VerifierError("ClassComponent.36", token, (Object)f);
            }
        } else if ((f.flags() & 5) == 0) {
            if (cinfo.firstReferenceIndex() != 255 && token < cinfo.firstReferenceIndex() + cinfo.referenceCount()) {
                throw new VerifierError("ClassComponent.48", token, (Object)f);
            }
        } else if (cinfo.firstReferenceIndex() != 255 && token + fieldsize > cinfo.firstReferenceIndex()) {
            throw new VerifierError("ClassComponent.49", token, (Object)f);
        }
        if (!allInstanceFields.add(new OffsetAndLength(token, fieldsize))) {
            throw new VerifierError("ClassComponent.32", token);
        }
    }

    void checkFieldTokenOrdering(ClassDescriptor cdesc) {
        int minPrivateToken = Integer.MAX_VALUE;
        int maxPublicToken = Integer.MIN_VALUE;
        for (int j = 0; j < cdesc.fieldCount(); ++j) {
            FieldDescriptor fdesc = cdesc.fieldDescr(j);
            if ((fdesc.flags() & 8) != 0) continue;
            int token = fdesc.token();
            if ((fdesc.flags() & 5) == 0) {
                if (token <= maxPublicToken) {
                    throw new VerifierError("ClassComponent.46", token, (Object)fdesc);
                }
                if (token >= minPrivateToken) continue;
                minPrivateToken = token;
                continue;
            }
            if (token >= minPrivateToken) {
                throw new VerifierError("ClassComponent.47", token, (Object)fdesc);
            }
            if (token <= maxPublicToken) continue;
            maxPublicToken = token;
        }
    }

    private void checkClassMethod(ClassDescriptor cdesc, ClassInfo cinfo, int ofs, int token, boolean holesNotAllowed) {
        if (ofs == 65535) {
            if (holesNotAllowed) {
                throw new VerifierError("ClassComponent.44");
            }
            MethodDescriptor md = Methodref.virtualMethodDescriptor(cdesc, token);
            if (md != null && (md.flags() & 4) == 0) {
                throw new VerifierError("ClassComponent.45", token);
            }
            return;
        }
        ClassAndMethodDescriptor cmd = Methodref.findDescr(ofs);
        ClassDescriptor defclass = cmd.classDescr;
        MethodDescriptor meth = cmd.methodDescr;
        if (!Classref.isSubclass(cdesc.thisClass(), defclass.thisClass())) {
            throw new VerifierError("ClassComponent.16", ofs);
        }
        if (meth.token() != token) {
            throw new VerifierError("ClassComponent.17", meth.token(), token);
        }
        if ((meth.flags() & 0x88) != 0) {
            throw new VerifierError("ClassComponent.18");
        }
        MethodTypeAndFlags mtyf = Methodref.findByToken(cinfo.superclass(), token, false);
        if (mtyf != null && mtyf.offset != ofs) {
            TypeMethod mty = TypeMethod.parseCap(Cap.TypeDescr.at(meth.type()));
            if (!mty.equals(mtyf.mty)) {
                throw new VerifierError("ClassComponent.19", (Object)mty, (Object)mtyf.mty);
            }
            if ((mtyf.flags & 0x10) != 0) {
                throw new VerifierError("ClassComponent.20");
            }
            if (ClassComponent.visibilityLevel(meth.flags()) < ClassComponent.visibilityLevel(mtyf.flags)) {
                throw new VerifierError("ClassComponent.30");
            }
        }
    }

    static void checkClassImplIntf(ClassDescriptor cdesc, ClassInfo cinfo, ImplementedInterface intf) {
        int intfref = intf.interfaceImpl();
        Classref.check(intfref);
        if (!Classref.implementsInterface(cdesc.thisClass(), intfref)) {
            throw new VerifierError("ClassComponent.21", intfref);
        }
        if (!Classref.isExternal(intfref) && intfref >= cdesc.thisClass()) {
            throw new VerifierError("ClassComponent.43");
        }
        for (int intfToken = 0; intfToken < intf.count(); ++intfToken) {
            int implToken = intf.indexMethod(intfToken);
            MethodTypeAndFlags intfMtyf = Methodref.findByToken(intf.interfaceImpl(), intfToken, false);
            if (intfMtyf == null) {
                throw new VerifierError("ClassComponent.22", intf.interfaceImpl());
            }
            MethodTypeAndFlags implMtyf = Methodref.findByToken(cdesc.thisClass(), implToken, false);
            if (implMtyf == null) {
                throw new VerifierError("ClassComponent.23", intf.interfaceImpl());
            }
            if ((implMtyf.flags & 1) == 0) {
                throw new VerifierError("ClassComponent.24");
            }
            if (implMtyf.mty.equals(intfMtyf.mty)) continue;
            throw new VerifierError("ClassComponent.25");
        }
        if (intf.count() != Classref.numberOfMethods(intf.interfaceImpl())) {
            throw new VerifierError("ClassComponent.39", intf.interfaceImpl());
        }
    }

    static boolean classInfoImplementsInterface(int cref, int intfRef) {
        if (Classref.isExternal(cref)) {
            EfClass ec = Classref.checkExternal(cref);
            for (int i = 0; i < ec.interfaces.length; ++i) {
                if (Classref.refForName(ec.interfaceName(i)) != intfRef) continue;
                return true;
            }
            return false;
        }
        ClassInfo cinfo = Cap.Class.infoOfs(cref);
        ImplementedInterface p = cinfo.firstImplementedInterface();
        for (int j = cinfo.interfaceCount(); j > 0; --j) {
            if (p.interfaceImpl() == intfRef) {
                return true;
            }
            p.next();
        }
        int superRef = cinfo.superclass();
        if (superRef == 65535) {
            return false;
        }
        return ClassComponent.classInfoImplementsInterface(superRef, intfRef);
    }

    private static void checkMethodsAreProvided(ClassInfo cinfo, int pkg, int base, int count, Safeptr vtable) {
        for (int i = 0; i < base + count; ++i) {
            MethodTypeAndFlags mtyf;
            int token = pkg + i;
            if (i >= base && vtable.u2((i - base) * 2) != 65535 || (mtyf = Methodref.findByToken(cinfo.ofs, token, false)) != null && (mtyf.flags & 0x40) == 0) continue;
            throw new VerifierError("ClassComponent.26", token);
        }
    }

    private void verifyOverlap() {
        Safeptr curr = this.offset(this.classInterfaceInfoOffset);
        Iterator<OffsetAndLength> i$ = this.allClasses.iterator();
        while (i$.hasNext()) {
            OffsetAndLength offsetAndLength;
            OffsetAndLength ol = offsetAndLength = i$.next();
            if (ol.offset < curr.ofs) {
                throw new VerifierError("ClassComponent.27", curr.ofs);
            }
            if (ol.offset > curr.ofs) {
                throw new VerifierError("ClassComponent.28", curr.ofs);
            }
            curr.advance(ol.length);
        }
        if (!curr.atComponentEnd()) {
            throw new VerifierError("ClassComponent.29");
        }
    }

    private void verifyTokenOverlap(TreeSet<OffsetAndLength> allInstanceFields, int declaredInstanceSize) {
        int curr = 0;
        Iterator<OffsetAndLength> i$ = allInstanceFields.iterator();
        while (i$.hasNext()) {
            OffsetAndLength offsetAndLength;
            OffsetAndLength ol = offsetAndLength = i$.next();
            if (ol.offset < curr) {
                throw new VerifierError("ClassComponent.33", curr);
            }
            if (ol.offset > curr) {
                throw new VerifierError("ClassComponent.34", curr);
            }
            curr += ol.length;
        }
        if (curr != declaredInstanceSize) {
            throw new VerifierError("ClassComponent.34", curr);
        }
    }

    private static int visibilityLevel(int flags) {
        if ((flags & 1) != 0) {
            return 3;
        }
        if ((flags & 4) != 0) {
            return 2;
        }
        if ((flags & 2) != 0) {
            return 0;
        }
        return 1;
    }

    private void addSuperInterfaces(TreeSet<Integer> superIntf, int iref) {
        superIntf.add(new Integer(iref));
        if (Classref.isExternal(iref)) {
            EfClass ei = Classref.checkExternal(iref);
            for (int i = 0; i < ei.interfaces.length; ++i) {
                superIntf.add(new Integer(Classref.refForName(ei.interfaceName(i))));
            }
        } else {
            ClassInfo iinfo = this.infoOfs(iref);
            for (int i = 0; i < iinfo.interfaceCount(); ++i) {
                this.addSuperInterfaces(superIntf, iinfo.superinterface(i));
            }
        }
    }

    void verifySignaturePool(int signaturePoolLength) {
        int nibbleCount;
        for (int SPOffset = 0; SPOffset < signaturePoolLength; SPOffset += (nibbleCount + 1) / 2 + 1) {
            RemoteInfo.verifyRemoteMethodTypeDescr(this.signaturePool.offset(SPOffset));
            nibbleCount = this.signaturePool.u1(SPOffset);
        }
    }
}

