/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.MethodTable;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.RemoteMethodInfo;
import com.sun.javacard.jcasm.Sortable;
import com.sun.javacard.jcasm.SuperInterface;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCClass
extends Member
implements Sortable {
    public static final int MAX_INTERFACES = 15;
    public static final int MAX_FIELDS = 255;
    public static final int ACC_INTERFACE = 128;
    public static final int ACC_SHAREABLE = 64;
    public static final int ACC_REMOTE = 32;
    protected ClassIdentifier classId;
    protected JCPackage parentPackage;
    protected JCClass superClass;
    protected String superClassName;
    protected ClassIdentifier superClassIdentifier;
    protected Vector<Field> fieldVector;
    protected boolean isShareable;
    protected boolean remoteFlag;
    public MethodTable publicMethodTable;
    public MethodTable packageMethodTable;
    public Vector<InterfaceTable> interfaceVector;
    public Vector<InterfaceTable> remoteInterfaceVector;
    public Vector<SuperInterface> superInterfaceVector;
    protected int referenceCount;
    protected int firstReferenceToken;
    protected int instanceSize;
    protected Vector<JCMethod> methodVector;
    public Hashtable<Object, JCMethod> methodSymbolTable;
    public Hashtable<Object, Field> fieldSymbolTable;
    public Vector<RemoteMethodInfo> remoteMethods;
    Vector<Short> methodhashes = new Vector();
    private String hashAntiCollisionString = null;
    public static final byte STRING_MAX = 127;
    public static final byte STRING_MIN = 0;
    boolean noMethodHashCollisions = true;

    public JCClass(JCPackage jCPackage, int n, String string, ClassIdentifier classIdentifier, int n2) {
        super(n, string, n2, 0);
        assert (classIdentifier != null) : "id != null";
        this.parentPackage = jCPackage;
        this.classId = classIdentifier;
        this.methodSymbolTable = new Hashtable();
        this.fieldSymbolTable = new Hashtable();
        this.fieldVector = new Vector();
        this.interfaceVector = new Vector(4);
        this.remoteInterfaceVector = new Vector(4);
        this.methodVector = new Vector();
        this.firstReferenceToken = 255;
        this.isShareable = false;
        if (Modifier.isInterface(n)) {
            this.superInterfaceVector = new Vector();
        }
        this.remoteMethods = new Vector();
    }

    void processRemoteMethodInfo() {
        for (int i = 0; i < this.remoteInterfaceVector.size(); ++i) {
            InterfaceTable interfaceTable = this.remoteInterfaceVector.elementAt(i);
            Vector<String> vector = interfaceTable.getNameDescrVector();
            Vector<Integer> vector2 = interfaceTable.getIndexVector();
            assert (vector.size() == vector2.size()) : "NameTableSize == TokenTableSize";
            for (int j = 0; j < vector2.size(); ++j) {
                String string = vector.elementAt(j);
                int n = vector2.elementAt(j);
                if (this.findRemoteMethodWithToken(n)) continue;
                RemoteMethodInfo remoteMethodInfo = new RemoteMethodInfo(string, n, this);
                this.remoteMethods.add(remoteMethodInfo);
            }
        }
        this.resolveMethodHashes();
        this.remoteMethods = this.sortRemoteMethods();
    }

    boolean findRemoteMethodWithToken(int n) {
        for (int i = 0; i < this.remoteMethods.size(); ++i) {
            byte by = this.remoteMethods.elementAt((int)i).flagAndToken;
            if (by != n) continue;
            return true;
        }
        return false;
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classId;
    }

    public JCPackage getParentPackage() {
        return this.parentPackage;
    }

    public void setSuperClass(JCClass jCClass) {
        this.superClass = jCClass;
        this.superClassName = jCClass.getName();
        this.superClassIdentifier = jCClass.getClassIdentifier();
    }

    public JCClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClassName(String string) {
        this.superClassName = string;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassIdentifier(ClassIdentifier classIdentifier) {
        this.superClassIdentifier = classIdentifier;
    }

    public ClassIdentifier getSuperClassIdentifier() {
        return this.superClassIdentifier;
    }

    public void addMethod(JCMethod jCMethod) {
        assert (jCMethod != null) : "jcMethod != null";
        String string = jCMethod.getName();
        if (this.methodSymbolTable.containsKey(string)) {
            Object[] objectArray = new Object[]{string, this.name};
            Msg.error("class.1", objectArray);
            return;
        }
        if (Modifier.isInterface(this.attributes) && !Modifier.isAbstract(jCMethod.getAttributes())) {
            Object[] objectArray = new Object[]{jCMethod.getName(), this.name};
            Msg.error("class.9", objectArray);
            return;
        }
        MethodIdentifier methodIdentifier = jCMethod.getMethodIdentifier();
        if (methodIdentifier != null) {
            if (this.methodSymbolTable.containsKey(methodIdentifier)) {
                Object[] objectArray = new Object[]{new Integer(methodIdentifier.getMethodToken()), this.name};
                Msg.error("class.2", objectArray);
                return;
            }
            this.methodSymbolTable.put(methodIdentifier, jCMethod);
        }
        jCMethod.methodFixup();
        this.methodSymbolTable.put(string, jCMethod);
        this.methodVector.addElement(jCMethod);
    }

    public Enumeration<JCMethod> methodElements() {
        return this.methodVector.elements();
    }

    public void addField(Field field) {
        assert (field != null) : "field != null";
        String string = field.getName();
        if (this.fieldSymbolTable.containsKey(string)) {
            Object[] objectArray = new Object[]{string, this.name};
            Msg.error("class.3", objectArray);
            return;
        }
        if (!(!Modifier.isInterface(this.attributes) || Modifier.isFinal(field.getAttributes()) && Modifier.isStatic(field.getAttributes()))) {
            Object[] objectArray = new Object[]{field.getName(), this.name};
            Msg.error("class.10", objectArray);
            return;
        }
        FieldIdentifier fieldIdentifier = field.getFieldIdentifier();
        if (fieldIdentifier != null) {
            if (this.fieldSymbolTable.containsKey(fieldIdentifier)) {
                Object[] objectArray = new Object[]{new Integer(fieldIdentifier.getFieldToken()), this.name};
                Msg.error("class.4", objectArray);
                return;
            }
            this.fieldSymbolTable.put(fieldIdentifier, field);
        }
        this.fieldSymbolTable.put(string, field);
        this.fieldVector.addElement(field);
    }

    public Enumeration<Field> fieldElements() {
        return this.fieldVector.elements();
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public int getFirstReferenceToken() {
        return this.firstReferenceToken;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    public boolean isExported() {
        boolean bl = false;
        if (!Modifier.isPublic(this.attributes) && !Modifier.isProtected(this.attributes)) {
            bl = false;
        }
        if (this.parentPackage.appletCount() == 0 || this.isShareable() && Modifier.isInterface(this.attributes)) {
            bl = true;
        }
        return bl;
    }

    void makeShareable() {
        this.isShareable = true;
    }

    public int getInstanceBase() {
        int n = 0;
        for (JCClass jCClass = this.getSuperClass(); jCClass != null; jCClass = jCClass.getSuperClass()) {
            n += jCClass.getInstanceSize();
        }
        return n;
    }

    @Override
    public int compare(Object object) {
        JCClass jCClass;
        JCClass jCClass2 = (JCClass)object;
        if (Modifier.isInterface(jCClass2.getAttributes()) && !Modifier.isInterface(this.getAttributes())) {
            return 1;
        }
        if (!Modifier.isInterface(jCClass2.getAttributes()) && Modifier.isInterface(this.getAttributes())) {
            return -1;
        }
        for (jCClass = jCClass2; jCClass != null; jCClass = jCClass.getSuperClass()) {
            if (!jCClass.equals(this)) continue;
            return -1;
        }
        for (jCClass = this; jCClass != null; jCClass = jCClass.getSuperClass()) {
            if (!jCClass.equals(jCClass2)) continue;
            return 1;
        }
        return 0;
    }

    public void sortFields() {
        int n;
        int n2;
        this.instanceSize = 0;
        this.firstReferenceToken = 255;
        this.referenceCount = 0;
        int n3 = this.fieldVector.size() * 2;
        Field[][] fieldArray = new Field[4][n3];
        Field[] fieldArray2 = new Field[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (Field field : this.fieldVector) {
            Object[] objectArray;
            n2 = field.getAttributes();
            if (Modifier.isStatic(n2)) {
                if (!field.getDescriptor().isPrimitive()) {
                    if (field.getDescriptor().isArray() && field.getFieldInitializer() != null) {
                        fieldArray[0][n4++] = field;
                        continue;
                    }
                    fieldArray[1][n5++] = field;
                    continue;
                }
                if (field.getFieldInitializer() == null) {
                    fieldArray[2][n6++] = field;
                    continue;
                }
                fieldArray[3][n7++] = field;
                continue;
            }
            int n8 = field.getFieldIdentifier().getFieldToken();
            if (n8 > n3) {
                objectArray = new Object[]{field.getName(), field.getParentClass().getName()};
                Msg.error("class.7", objectArray);
                continue;
            }
            if (fieldArray2[n8] != null) {
                objectArray = new Object[]{field.getName(), field.getParentClass().getName()};
                Msg.error("class.8", objectArray);
                continue;
            }
            fieldArray2[n8] = field;
        }
        Vector vector = new Vector(this.fieldVector.size());
        for (n = 0; n < 4; ++n) {
            n2 = 0;
            while (n2 < fieldArray[0].length && fieldArray[n][n2] != null) {
                vector.addElement(fieldArray[n][n2++]);
            }
        }
        n = 0;
        for (Field field : fieldArray2) {
            if (field == null) continue;
            int n9 = field.getFieldIdentifier().getFieldToken();
            int n10 = Math.max(2, field.size()) / 2;
            if (n9 != n) {
                Object[] objectArray = new Object[]{field.getName(), field.getParentClass().getName()};
                Msg.error("class.7", objectArray);
            }
            n = n9 + n10;
            if (!field.getDescriptor().isPrimitive()) {
                ++this.referenceCount;
                if (this.firstReferenceToken == 255) {
                    this.firstReferenceToken = n9;
                }
            }
            this.instanceSize += n10;
            vector.addElement(field);
        }
        this.fieldVector = vector;
    }

    public void addInterface(InterfaceTable interfaceTable) {
        assert (interfaceTable != null) : "inter != null";
        if (this.interfaceVector.size() >= 15) {
            Object[] objectArray = new Object[]{this.name};
            Msg.error("class.5", objectArray);
        }
        this.interfaceVector.addElement(interfaceTable);
    }

    public void addRemoteInterface(InterfaceTable interfaceTable) {
        assert (interfaceTable != null) : "inter != null";
        if (this.remoteInterfaceVector.size() >= 15) {
            Object[] objectArray = new Object[]{this.name};
            Msg.error("class.5", objectArray);
        }
        this.remoteInterfaceVector.addElement(interfaceTable);
    }

    public void addSuperInterface(String string) {
        assert (Modifier.isInterface(this.attributes)) : "!isInterface";
        this.superInterfaceVector.addElement(new SuperInterface(this, string));
    }

    public void addSuperInterface(ClassIdentifier classIdentifier) {
        assert (Modifier.isInterface(this.attributes)) : "!isInterface";
        this.superInterfaceVector.addElement(new SuperInterface(this, classIdentifier));
    }

    public Enumeration<InterfaceTable> interfaceElements() {
        return this.interfaceVector.elements();
    }

    public Enumeration<InterfaceTable> remoteInterfaceElements() {
        return this.remoteInterfaceVector.elements();
    }

    public Enumeration<SuperInterface> superInterfaceElements() {
        return this.superInterfaceVector.elements();
    }

    public void setRemote(boolean bl) {
        this.remoteFlag = bl;
        if (bl) {
            this.parentPackage.set22Flag();
        }
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.attributes);
    }

    public boolean isRemote() {
        return this.remoteFlag;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toByteArray() {
        byte[] byArray;
        block22: {
            int n;
            int n2;
            int n3;
            block21: {
                byArray = new byte[this.size()];
                n3 = 0;
                int n4 = n2 = this.isShareable ? 64 : 0;
                if (this.isRemote()) {
                    n2 |= 0x20;
                }
                if (!Modifier.isInterface(this.attributes)) break block21;
                byArray[n3++] = (byte)((n2 |= 0x80) | this.superInterfaceVector.size() & 0xF);
                for (SuperInterface object22 : this.superInterfaceVector) {
                    if (object22.isResolved()) {
                        int n5 = object22.resolve().getRelocAddr();
                        byArray[n3++] = (byte)(n5 >> 8 & 0xFF);
                        byArray[n3++] = (byte)(n5 & 0xFF);
                        continue;
                    }
                    ClassIdentifier classIdentifier = object22.getClassIdentifier();
                    PackageIdentifier packageIdentifier = classIdentifier.getPackageIdentifier();
                    byArray[n3++] = (byte)(this.parentPackage.getPackageToken(packageIdentifier) | 0x80);
                    byArray[n3++] = (byte)classIdentifier.getClassToken();
                }
                if (!this.isRemote()) break block22;
                Object object3 = this.getName();
                object3 = ((String)object3).substring(((String)object3).lastIndexOf("/") + 1);
                byte[] object6 = ((String)object3).getBytes();
                byArray[n3++] = (byte)object6.length;
                for (byte by : object6) {
                    byArray[n3++] = by;
                }
                break block22;
            }
            byArray[n3++] = (byte)(n2 | this.interfaceVector.size() & 0xF);
            if (this.superClass == null && this.superClassIdentifier == null) {
                byArray[n3++] = -1;
                byArray[n3++] = -1;
            } else if (this.superClass == null) {
                PackageIdentifier packageIdentifier = this.superClassIdentifier.getPackageIdentifier();
                byArray[n3++] = (byte)(this.parentPackage.getPackageToken(packageIdentifier) | 0x80);
                byArray[n3++] = (byte)this.superClassIdentifier.getClassToken();
            } else {
                int n6 = this.superClass.getRelocAddr();
                byArray[n3++] = (byte)(n6 >> 8 & 0xFF);
                byArray[n3++] = (byte)(n6 & 0xFF);
            }
            byArray[n3++] = (byte)this.instanceSize;
            byArray[n3++] = (byte)this.firstReferenceToken;
            byArray[n3++] = (byte)this.referenceCount;
            byArray[n3++] = (byte)this.publicMethodTable.getBase();
            byArray[n3++] = (byte)this.publicMethodTable.getCount();
            byArray[n3++] = (byte)this.packageMethodTable.getBase();
            byArray[n3++] = (byte)this.packageMethodTable.getCount();
            Object object5 = this.publicMethodTable.elements();
            while (object5.hasMoreElements()) {
                JCMethod i = object5.nextElement();
                if (i != null) {
                    n = i.getRelocAddr();
                    byArray[n3++] = (byte)(n >> 8 & 0xFF);
                    byArray[n3++] = (byte)(n & 0xFF);
                    continue;
                }
                byArray[n3++] = -1;
                byArray[n3++] = -1;
            }
            object5 = this.packageMethodTable.elements();
            while (object5.hasMoreElements()) {
                JCMethod jCMethod = object5.nextElement();
                assert (jCMethod != null) : "m!= null";
                n = jCMethod.getRelocAddr();
                byArray[n3++] = (byte)(n >> 8 & 0xFF);
                byArray[n3++] = (byte)(n & 0xFF);
            }
            for (InterfaceTable interfaceTable : this.interfaceVector) {
                byte[] byArray2 = interfaceTable.toByteArray();
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                n3 += byArray2.length;
            }
            if (this.isRemote()) {
                byArray[n3++] = (byte)this.remoteMethods.size();
                if (this.remoteMethods.size() > 0) {
                    for (RemoteMethodInfo remoteMethodInfo : this.remoteMethods) {
                        int n6 = this.getParentPackage().getSignaturePool().getAddressForOffset(remoteMethodInfo.methodSigOffset);
                        byArray[n3++] = (byte)(remoteMethodInfo.remoteMethodHash >> 8 & 0xFF);
                        byArray[n3++] = (byte)(remoteMethodInfo.remoteMethodHash & 0xFF);
                        byArray[n3++] = (byte)(n6 >> 8 & 0xFF);
                        byArray[n3++] = (byte)(n6 & 0xFF);
                        byArray[n3++] = remoteMethodInfo.flagAndToken;
                    }
                }
                if (this.hashAntiCollisionString != null) {
                    void var5_18;
                    object5 = this.hashAntiCollisionString.getBytes();
                    byArray[n3++] = (byte)((Object)object5).length;
                    boolean bl = false;
                    while (var5_18 < ((Object)object5).length) {
                        byArray[n3++] = (byte)object5[var5_18];
                        ++var5_18;
                    }
                } else {
                    byArray[n3++] = 0;
                }
                object5 = this.getName();
                object5 = ((String)object5).substring(((String)object5).lastIndexOf("/") + 1);
                byte[] byArray3 = ((String)object5).getBytes();
                int n7 = byArray3.length;
                byArray[n3++] = (byte)n7;
                for (int i = 0; i < n7; ++i) {
                    byArray[n3++] = byArray3[i];
                }
                byArray[n3++] = (byte)this.remoteInterfaceVector.size();
                for (InterfaceTable interfaceTable : this.remoteInterfaceVector) {
                    byte[] byArray4 = interfaceTable.remoteInterfaceToByteArray();
                    System.arraycopy(byArray4, 0, byArray, n3, byArray4.length);
                    n3 += byArray4.length;
                }
            }
        }
        return byArray;
    }

    public Vector<RemoteMethodInfo> sortRemoteMethods() {
        Vector<RemoteMethodInfo> vector = new Vector<RemoteMethodInfo>();
        while (this.remoteMethods.size() > 0) {
            vector.addElement(this.getMethodWithSmallestHash());
        }
        return vector;
    }

    private RemoteMethodInfo getMethodWithSmallestHash() {
        RemoteMethodInfo remoteMethodInfo = this.remoteMethods.elementAt(0);
        int n = remoteMethodInfo.remoteMethodHash & Integer.MAX_VALUE;
        for (int i = 1; i < this.remoteMethods.size(); ++i) {
            RemoteMethodInfo remoteMethodInfo2 = this.remoteMethods.elementAt(i);
            int n2 = remoteMethodInfo2.remoteMethodHash & Integer.MAX_VALUE;
            if (n <= n2) continue;
            remoteMethodInfo = remoteMethodInfo2;
            n = n2;
        }
        this.remoteMethods.removeElement(remoteMethodInfo);
        return remoteMethodInfo;
    }

    public int size() {
        if (Modifier.isInterface(this.attributes)) {
            int n = 1 + this.superInterfaceVector.size() * 2;
            if (this.isRemote()) {
                String string = this.name.substring(this.name.lastIndexOf("/") + 1);
                n += string.getBytes().length + 1;
            }
            return n;
        }
        int n = 10 + 2 * this.packageMethodTable.getCount() + 2 * this.publicMethodTable.getCount();
        for (InterfaceTable interfaceTable : this.interfaceVector) {
            n += interfaceTable.size();
        }
        if (this.isRemote()) {
            String string = this.name.substring(this.name.lastIndexOf("/") + 1);
            n += 1 + this.remoteMethods.size() * 5;
            n = this.hashAntiCollisionString != null ? (n += this.hashAntiCollisionString.getBytes().length + 1) : ++n;
            n += string.getBytes().length + 1;
            n += this.remoteInterfaceVector.size() * 2 + 1;
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (Modifier.isInterface(this.attributes)) {
            stringBuffer.append(".interface");
        } else {
            stringBuffer.append(".class");
        }
        stringBuffer.append(" " + super.toString());
        if (this.classId != null) {
            stringBuffer.append(" <" + this.classId + ">");
        }
        stringBuffer.append(" {" + Msg.eol);
        stringBuffer.append(".fields {" + Msg.eol);
        Enumeration<JCMethod> enumeration = this.fieldElements();
        while (enumeration.hasMoreElements()) {
            Field object = enumeration.nextElement();
            stringBuffer.append(object + ";" + Msg.eol);
        }
        stringBuffer.append("}" + Msg.eol);
        if (this.publicMethodTable != null) {
            stringBuffer.append("public method table base: " + this.publicMethodTable.getBase() + ", ");
            stringBuffer.append("public method table count: " + this.publicMethodTable.getCount() + Msg.eol);
            enumeration = this.publicMethodTable.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
            }
        }
        if (this.packageMethodTable != null) {
            stringBuffer.append("package method table base: " + this.packageMethodTable.getBase() + ", ");
            stringBuffer.append("package method table count: " + this.packageMethodTable.getCount() + Msg.eol);
            enumeration = this.publicMethodTable.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
            }
        }
        for (InterfaceTable interfaceTable : this.interfaceVector) {
            stringBuffer.append(interfaceTable + Msg.eol);
        }
        for (JCMethod jCMethod : this.methodVector) {
            stringBuffer.append(jCMethod);
        }
        stringBuffer.append("}" + Msg.eol);
        return stringBuffer.toString();
    }

    public String getAntiHashCollisionString() {
        this.resolveMethodHashes();
        return this.hashAntiCollisionString;
    }

    public void resolveMethodHashes() {
        if (this.noMethodHashCollisions) {
            return;
        }
        int n = 0;
        byte[] byArray = new byte[]{0};
        this.methodhashes.removeAllElements();
        for (int i = 0; i < this.remoteMethods.size(); ++i) {
            this.hashAntiCollisionString = new String(byArray);
            RemoteMethodInfo remoteMethodInfo = this.remoteMethods.elementAt(i);
            Short s = new Short(Strings.computeShortHash(this.hashAntiCollisionString + remoteMethodInfo.methodNameAndDesc));
            if (this.methodhashes.indexOf(s) < 0) {
                this.methodhashes.addElement(s);
                remoteMethodInfo.remoteMethodHash = s;
                this.noMethodHashCollisions = true;
                continue;
            }
            this.methodhashes.removeAllElements();
            i = -1;
            this.hashAntiCollisionString = null;
            this.noMethodHashCollisions = false;
            if (byArray[n] == 127) {
                Object[] objectArray = new Object[]{this.getName()};
                Msg.error("cap.4", objectArray);
                System.exit(1);
                continue;
            }
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] + 1);
        }
    }
}

