/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.PackageIdentifier;

public class SuperMethodRefInfo
extends Info {
    protected JCClass theClass;
    protected int superMethodToken;

    SuperMethodRefInfo(PackageIdentifier packageId, String name) {
        super(4, packageId, name, name.substring(name.lastIndexOf(40)));
    }

    public void resolve(JCClass theClass, int token) {
        this.theClass = theClass;
        this.superMethodToken = token;
    }

    public byte[] toByteArray(JCPackage p) {
        byte[] array = super.toByteArray(p);
        JCMethod method = (JCMethod)this.resolvedTo;
        if (method != null) {
            int addr = method.getParentClass().getRelocAddr();
            array[1] = (byte)(addr >> 8);
            array[2] = (byte)addr;
            array[3] = (byte)method.getMethodIdentifier().getMethodToken();
        } else {
            int addr = this.theClass.getRelocAddr();
            array[1] = (byte)(addr >> 8);
            array[2] = (byte)addr;
            array[3] = (byte)this.superMethodToken;
        }
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        return sb.toString();
    }
}

