/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.ClassConverter;
import com.sun.javacard.converter.converters.InterfaceConverter;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcAppletInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class PackageConverter {
    private JPackage java_package;
    private ExportFileManager export_file_manager;
    private JcPackage jc_package;
    private boolean int_support = false;
    private boolean this_exp_provided = false;
    private boolean convert_bc = false;
    private JcConstantPool jc_cp;
    private ConversionProfile conversion_profile;

    public PackageConverter(JPackage java_package, ConversionProfile conversion_profile, ExportFileManager export_file_manager) throws Exception {
        this.java_package = java_package;
        this.jc_package = new JcPackage(java_package);
        this.jc_cp = new JcConstantPool();
        this.jc_package.setConstantPool(this.jc_cp);
        this.jc_package.setAID(conversion_profile.package_profile.aid);
        this.jc_package.setPackageMajorVersion(conversion_profile.package_profile.major_version);
        this.jc_package.setPackageMinorVersion(conversion_profile.package_profile.minor_version);
        this.conversion_profile = conversion_profile;
        this.export_file_manager = export_file_manager;
        this.int_support = conversion_profile.int_supported;
        this.this_exp_provided = conversion_profile.this_exp_provided;
        this.convert_bc = conversion_profile.output != 2;
        if (this.this_exp_provided) {
            this.jc_package.setEfExportFile(export_file_manager.getExportFile(java_package.getPackageName()));
        } else {
            this.jc_package.setEfExportFile(null);
        }
    }

    private void assignClassTokens(JcClass[] jc_classes) {
        JcClass jcClass;
        int nexttoken = 0;
        int i = 0;
        while (i < jc_classes.length) {
            jcClass = jc_classes[i];
            jcClass.setClassToken(255);
            if (jcClass.isAPIElement(this.jc_package) && jcClass.getEfClass() != null) {
                int token = jcClass.getEfClass().getClassToken();
                jcClass.setClassToken(token);
                if (token >= nexttoken) {
                    nexttoken = token + 1;
                }
            }
            ++i;
        }
        i = 0;
        while (i < jc_classes.length) {
            jcClass = jc_classes[i];
            if (jcClass.getClassToken() == 255 && jcClass.isAPIElement(this.jc_package)) {
                jcClass.setClassToken(nexttoken++);
            }
            ++i;
        }
        i = 0;
        while (i < jc_classes.length) {
            jcClass = jc_classes[i];
            if (jcClass.getClassToken() == 255 && jcClass.isPublic()) {
                jcClass.setClassToken(nexttoken++);
            }
            ++i;
        }
    }

    private void checkAID() throws Exception {
        byte[] newAid = this.getConversionProfile().package_profile.aid;
        byte[] oldAid = this.getJcPackage().getEfExportFile().getAID();
        if (Arrays.equals(newAid, oldAid)) {
            return;
        }
        Object[] args = new Object[]{Strings.toHexString(oldAid, ":"), Strings.toHexString(newAid, ":")};
        Notifier.error("binary.49", args);
        throw new ConversionException();
    }

    private void checkClassFlags() throws Exception {
        boolean cfr_ignored_0 = this.conversion_profile.debug;
        JcClass[] jc_classes = this.jc_package.getClasses();
        int i = 0;
        while (i < jc_classes.length) {
            if (jc_classes[i].getEfClass() != null) {
                JcClass jcC = jc_classes[i];
                EfClass efC = jcC.getEfClass();
                if (!efC.isFinal() && jcC.isFinal()) {
                    Object[] args = new Object[]{efC.getClassName().replace('/', '.')};
                    Notifier.error("binary.45", args);
                    throw new ConversionException();
                }
                if (!efC.isAbstract() && jcC.isAbstract()) {
                    Object[] args = new Object[]{efC.getClassName().replace('/', '.')};
                    Notifier.error("binary.46", args);
                    throw new ConversionException();
                }
                if (!efC.isInterfaceType() && jcC.isInterfaceType()) {
                    Object[] args = new Object[]{efC.getClassName().replace('/', '.')};
                    Notifier.error("binary.47", args);
                    throw new ConversionException();
                }
                if (efC.isInterfaceType() && !jcC.isInterfaceType()) {
                    Object[] args = new Object[]{efC.getClassName().replace('/', '.')};
                    Notifier.error("binary.48", args);
                    throw new ConversionException();
                }
            }
            ++i;
        }
    }

    private JcAppletInfo[] constructAppletInfos() {
        AppletProfile[] applets_profile = this.conversion_profile.applets_profile;
        JcAppletInfo[] applet_infos = new JcAppletInfo[applets_profile.length];
        int i = 0;
        while (i < applets_profile.length) {
            applet_infos[i] = new JcAppletInfo(applets_profile[i].install_class, applets_profile[i].aid);
            ++i;
        }
        return applet_infos;
    }

    public JcPackage convert() throws Exception {
        if (this.isThisExpProvided()) {
            this.checkAID();
        }
        try {
            JcAppletInfo[] applet_infos = this.constructAppletInfos();
            this.jc_package.setAppletInfos(applet_infos);
            if (applet_infos.length > 0) {
                this.getJcPackage().setAppletFlag(true);
            }
            JClassFile[] java_classes = this.java_package.getClasses();
            this.sortClasses(java_classes);
            JcClass[] jc_classes = new JcClass[java_classes.length];
            this.jc_package.setClasses(jc_classes);
            int i = 0;
            while (i < java_classes.length) {
                JClassFile java_class = java_classes[i];
                Notifier.progress("progress.2", java_class.getClassName().replace('/', '.'));
                if (!Names.getPackageName(java_class.getClassName()).equals(this.java_package.getPackageName())) {
                    Object[] args = new Object[]{Names.getClassName(java_class.getClassName()), this.java_package.getPackageName().replace('/', '.')};
                    Notifier.error("conversion.1", args);
                    throw new ConverterException();
                }
                int access_flags = java_class.getAccessFlags();
                if (Modifier.isInterface(access_flags)) {
                    InterfaceConverter i_converter = new InterfaceConverter(java_class, this);
                    jc_classes[i] = i_converter.convert();
                } else {
                    ClassConverter c_converter = new ClassConverter(java_class, this);
                    jc_classes[i] = c_converter.convert();
                }
                ++i;
            }
            if (this.this_exp_provided) {
                this.detectRemovedAPIClasses();
                this.detectAddedAPIClasses();
                this.checkClassFlags();
            }
            this.assignClassTokens(jc_classes);
            this.jc_cp.setIndex();
        }
        catch (ConverterException converterException) {}
        return this.jc_package;
    }

    public boolean convertByteCode() {
        return this.convert_bc;
    }

    private void detectAddedAPIClasses() throws Exception {
        JcClass[] jc_classes = this.jc_package.getClasses();
        EfClass[] ef_classes = this.jc_package.getEfExportFile().getClasses();
        int i = 0;
        while (i < jc_classes.length) {
            JcClass jcClass = jc_classes[i];
            if (jcClass.isAPIElement(this.jc_package)) {
                boolean cfr_ignored_0 = this.conversion_profile.debug;
                EfClass efClass = jcClass.getEfClass();
                boolean bl = this.conversion_profile.debug && efClass == null;
                if (!this.conversion_profile.packageUpgrade && efClass == null) {
                    Object[] args = new Object[]{jcClass.getClassName().replace('/', '.')};
                    Notifier.error("binary.40", args);
                    throw new ConversionException();
                }
                if (!this.conversion_profile.packageUpgrade && efClass != null) {
                    if (efClass.isFinal() && !jcClass.isFinal()) {
                        Object[] args = new Object[]{jcClass.getClassName().replace('/', '.')};
                        Notifier.error("binary.41", args);
                        throw new ConversionException();
                    }
                    if (efClass.isAbstract() && !jcClass.isAbstract()) {
                        Object[] args = new Object[]{jcClass.getClassName().replace('/', '.')};
                        Notifier.error("binary.42", args);
                        throw new ConversionException();
                    }
                }
            }
            ++i;
        }
    }

    private void detectRemovedAPIClasses() throws Exception {
        boolean cfr_ignored_0 = this.conversion_profile.debug;
        JcClass[] jc_classes = this.jc_package.getClasses();
        EfClass[] ef_classes = this.jc_package.getEfExportFile().getClasses();
        int i = 0;
        while (i < ef_classes.length) {
            EfClass efClass = ef_classes[i];
            boolean cfr_ignored_1 = this.conversion_profile.debug;
            JcClass jcClass = this.jc_package.getClass(efClass.getClassName());
            boolean bl = this.conversion_profile.debug && jcClass == null;
            if (jcClass == null) {
                Object[] args = new Object[]{efClass.getClassName().replace('/', '.')};
                Notifier.error("binary.43", args);
                throw new ConversionException();
            }
            if (!jcClass.isAPIElement(this.jc_package)) {
                Object[] args = new Object[]{efClass.getClassName().replace('/', '.')};
                Notifier.error("binary.44", args);
                throw new ConversionException();
            }
            ++i;
        }
    }

    public ConversionProfile getConversionProfile() {
        return this.conversion_profile;
    }

    public ExportFileManager getExportFileManager() {
        return this.export_file_manager;
    }

    public JPackage getJavaPackage() {
        return this.java_package;
    }

    public JcClass getJcClass(String class_name) {
        JcClass[] jc_classes = this.jc_package.getClasses();
        int i = 0;
        while (i < jc_classes.length) {
            String jc_class_name = jc_classes[i].getClassName();
            if (jc_class_name.equals(class_name)) {
                return jc_classes[i];
            }
            ++i;
        }
        throw new ConverterInternalError();
    }

    public JcConstantPool getJcConstantPool() {
        return this.jc_cp;
    }

    public JcPackage getJcPackage() {
        return this.jc_package;
    }

    public boolean isIntSupported() {
        return this.int_support;
    }

    public boolean isThisExpProvided() {
        return this.this_exp_provided;
    }

    public void setIntFlag(boolean flag) {
        this.jc_package.setIntFlag(flag);
    }

    private void sortClasses(JClassFile[] java_classes) {
        int counter = 0;
        int i = 0;
        while (i < java_classes.length) {
            JClassFile this_class = java_classes[i];
            int access_flags = this_class.getAccessFlags();
            if (Modifier.isInterface(access_flags)) {
                if (i > counter) {
                    java_classes[i] = java_classes[counter];
                    java_classes[counter] = this_class;
                }
                ++counter;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < java_classes.length) {
            JClassFile this_class = java_classes[i2];
            int access_flags = this_class.getAccessFlags();
            if (Modifier.isInterface(access_flags)) {
                String[] super_interfaces = this_class.getInterfaceNames();
                int j = 0;
                while (j < super_interfaces.length) {
                    String super_interface = super_interfaces[j];
                    if (this.swapClass(i2, super_interface)) {
                        --i2;
                        break;
                    }
                    ++j;
                }
            } else {
                String super_class = this_class.getSuperClassName();
                if (super_class != null && this.swapClass(i2, super_class)) {
                    --i2;
                }
            }
            ++i2;
        }
    }

    private boolean swapClass(int current_index, String super_class_name) {
        JClassFile[] java_classes = this.java_package.getClasses();
        int i = current_index + 1;
        while (i < java_classes.length) {
            JClassFile class_i = java_classes[i];
            if (class_i.getClassName().equals(super_class_name)) {
                java_classes[i] = java_classes[current_index];
                java_classes[current_index] = class_i;
                return true;
            }
            ++i;
        }
        return false;
    }
}

