/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.exportfile.EfAttribute;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.ExportFileFormatError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EfConstantValueAttribute
extends EfAttribute {
    private String name = "ConstantValue";
    private int name_index;
    private int value;
    private int value_index;
    private int attribute_length = 2;
    private EfConstantPool cp;

    public EfConstantValueAttribute(EfConstantPool cp) {
        this.cp = cp;
    }

    public EfConstantValueAttribute(EfConstantPool cp, int value) {
        this.cp = cp;
        this.name_index = cp.addConstantUtf8(this.name);
        this.value = value;
        this.value_index = cp.addConstantInteger(value);
    }

    public int getAttributeLength() {
        return this.attribute_length;
    }

    public String getName() {
        return this.name;
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int getValue() {
        return this.value;
    }

    public int getValueIndex() {
        return this.value_index;
    }

    public void parse(DataInputStream dis) throws IOException {
        this.name_index = dis.readUnsignedShort();
        if (dis.readInt() != 2) {
            throw new ExportFileFormatError();
        }
        this.value_index = dis.readUnsignedShort();
    }

    public void resolve() {
        this.name = this.cp.getConstantUtf8(this.name_index).getUtf8String();
        this.value = this.cp.getConstantInteger(this.value_index).getIntValue();
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeShort(this.name_index);
        dos.writeInt(this.attribute_length);
        dos.writeShort(this.value_index);
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tab_level) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        pw.println(String.valueOf(indent) + "ConstantValue_attribute {");
        pw.println(String.valueOf(indent) + "\tattribute_name_index\t" + this.name_index + "\t\t// " + this.name);
        pw.println(String.valueOf(indent) + "\tattribute_length\t" + 2);
        pw.println(String.valueOf(indent) + "\tconstantvalue_index\t" + this.value_index + "\t\t// value = " + this.value);
        pw.println(String.valueOf(indent) + "}");
    }
}

