/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_ClassRef;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Vector;

public class EfClass
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    public int[] supers;
    public int[] interfaces;
    public EfField[] fields;
    public EfMethod[] methods;
    private Vector newMethodList;
    private Vector newFields;
    private boolean sameVersion;
    private boolean refExists;
    private boolean isInterface;
    private static final int validFlags = 7697;
    private static final int abstractFinalFlags = 1040;
    private static final int shareableInterfaceFlags = 2560;

    EfClass(ExportFile exportFile) {
        super(exportFile);
    }

    public String thisName() {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.nameIndex]).classname();
    }

    public String superName(int n) {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.supers[n]]).classname();
    }

    public String interfaceName(int n) {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.interfaces[n]]).classname();
    }

    void read() throws IOException {
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkClassrefIndex(this.nameIndex);
        int n = this.ef.in.readUnsignedShort();
        this.supers = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.supers[n2] = this.ef.in.readUnsignedShort();
            this.ef.checkClassrefIndex(this.supers[n2]);
            ++n2;
        }
        int n3 = this.ef.in.readUnsignedByte();
        this.interfaces = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.interfaces[n4] = this.ef.in.readUnsignedShort();
            this.ef.checkClassrefIndex(this.interfaces[n4]);
            ++n4;
        }
        int n5 = this.ef.in.readUnsignedShort();
        this.fields = new EfField[n5];
        int n6 = 0;
        while (n6 < n5) {
            EfField efField = new EfField(this.ef, this.thisName());
            efField.read();
            this.fields[n6] = efField;
            ++n6;
        }
        int n7 = this.ef.in.readUnsignedShort();
        this.methods = new EfMethod[n7];
        int n8 = 0;
        while (n8 < n7) {
            EfMethod efMethod = new EfMethod(this.ef, this.thisName());
            efMethod.read();
            this.methods[n8] = efMethod;
            ++n8;
        }
    }

    void verify(HashSet hashSet, BitSet bitSet) {
        String string = this.thisName();
        if (!EfNames.validClassName(string)) {
            throw new VerifierError("EfClass.20", string);
        }
        try {
            String string2;
            int n = string.lastIndexOf(47);
            String string3 = string2 = n == -1 ? "" : string.substring(0, n);
            if (!string2.equals(this.ef.thisName())) {
                throw new VerifierError("EfClass.6", EfNames.prettyClass(this.ef.thisName()));
            }
            if (this.supers.length == 0 && !string.equals("java/lang/Object")) {
                throw new VerifierError("EfClass.22");
            }
            if ((this.accessFlag & 0xFFFFE1EE) != 0) {
                throw new VerifierError("EfClass.1", this.accessFlag);
            }
            if (this.ef.minorVersion != 2 && (this.accessFlag & 0x1000) != 0) {
                throw new VerifierError("EfClass.1", this.accessFlag);
            }
            if ((this.accessFlag & 1) == 0) {
                throw new VerifierError("EfClass.2");
            }
            if ((this.accessFlag & 0x200) != 0) {
                if ((this.accessFlag & 0x400) == 0) {
                    throw new VerifierError("EfClass.3");
                }
                if ((this.accessFlag & 0x10) != 0) {
                    throw new VerifierError("EfClass.4");
                }
            }
            if ((this.accessFlag & 0x410) == 1040) {
                throw new VerifierError("EfClass.5");
            }
            boolean bl = (this.accessFlag & 0x1000) != 0;
            boolean bl2 = this.thisName().equals("java/rmi/Remote");
            int n2 = 0;
            while (n2 < this.interfaces.length) {
                if (this.interfaceName(n2).equals("java/rmi/Remote")) {
                    bl2 = true;
                }
                ++n2;
            }
            if (bl != bl2) {
                throw new VerifierError("EfClass.23", this.thisName());
            }
            boolean bl3 = (this.accessFlag & 0x800) != 0;
            boolean bl4 = this.thisName().equals("javacard/framework/Shareable");
            int n3 = 0;
            while (n3 < this.interfaces.length) {
                if (this.interfaceName(n3).equals("javacard/framework/Shareable")) {
                    bl4 = true;
                }
                ++n3;
            }
            if (bl4 != bl3) {
                throw new VerifierError("EfClass.7");
            }
            if ((this.ef.thisPackage().flags & 1) == 0 && (this.accessFlag & 0xA00) != 2560) {
                throw new VerifierError("EfClass.8");
            }
            if (!hashSet.add(this.thisName())) {
                throw new VerifierError("EfClass.15");
            }
            if (bitSet.get(this.token)) {
                throw new VerifierError("EfClass.16", this.token);
            }
            bitSet.set(this.token);
            HashSet<String> hashSet2 = new HashSet<String>();
            int n4 = 0;
            while (n4 < this.supers.length) {
                if (!hashSet2.add(this.superName(n4))) {
                    throw new VerifierError("EfClass.17", EfNames.prettyClass(this.superName(n4)));
                }
                ++n4;
            }
            if ((this.ef.thisPackage().flags & 1) != 0 && hashSet2.contains("javacard/framework/Applet") && (this.accessFlag & 0x400) == 0) {
                throw new VerifierError("EfClass.21", EfNames.prettyClass(this.ef.thisName()));
            }
            HashSet<String> hashSet3 = new HashSet<String>();
            int n5 = 0;
            while (n5 < this.interfaces.length) {
                if (!hashSet3.add(this.interfaceName(n5))) {
                    throw new VerifierError("EfClass.18", EfNames.prettyClass(this.interfaceName(n5)));
                }
                ++n5;
            }
            boolean bl5 = (this.accessFlag & 0x200) != 0;
            HashSet hashSet4 = new HashSet();
            BitSet bitSet2 = new BitSet();
            BitSet bitSet3 = new BitSet();
            int n6 = 0;
            while (n6 < this.fields.length) {
                this.fields[n6].verify(bl5, hashSet4, bitSet2, bitSet3);
                ++n6;
            }
            HashSet hashSet5 = new HashSet();
            BitSet bitSet4 = new BitSet();
            BitSet bitSet5 = new BitSet();
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < this.methods.length) {
                if (this.methods[n9].isStaticOrInit()) {
                    ++n7;
                } else {
                    ++n8;
                }
                this.methods[n9].verify(bl5, hashSet5, bitSet4, bitSet5);
                ++n9;
            }
            if (bitSet4.length() != n7) {
                throw new VerifierError("EfMethod.15");
            }
            if (bitSet5.length() != n8) {
                throw new VerifierError("EfMethod.15");
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("EfClass.19", (Object)EfNames.prettyClass(this.thisName()), (Object)verifierError.getMessage());
        }
    }

    public int declaredInstanceSize() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fields.length) {
            int n3;
            EfField efField = this.fields[n2];
            if (!efField.isStatic() && (n3 = efField.token + efField.wordSize()) > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public String toString() {
        return EfNames.prettyClass(this.thisName());
    }

    void compareTo(EfClass efClass) {
        this.sameVersion = false;
        int n = this.accessFlag & 0x200;
        if (n == 0) {
            this.isInterface = false;
            if ((this.accessFlag & 0x10) < (efClass.accessFlag & 0x10)) {
                throw new VerifierError("RevisionError.4", this.thisName());
            }
        } else {
            this.isInterface = true;
        }
        if ((this.accessFlag & 0x400) < (efClass.accessFlag & 0x400)) {
            if (this.isInterface) {
                VerifierError.warning("RevisionWarning.2", this.thisName());
            } else {
                throw new VerifierError("RevisionError.5", this.thisName());
            }
        }
        if ((this.accessFlag & 0x1000) > (efClass.accessFlag & 0x1000)) {
            throw new VerifierError("RevisionError.41", this.thisName());
        }
        if ((this.accessFlag & 0x800) > (efClass.accessFlag & 0x800)) {
            throw new VerifierError("RevisionError.6", this.thisName());
        }
        this.compareCommon(efClass);
        this.checkNewMethods(efClass);
        this.checkNewFields(efClass);
    }

    void checkEquality(EfClass efClass) {
        this.sameVersion = true;
        int n = this.accessFlag & 0x200;
        if (n == 0 && (this.accessFlag & 0x10) != (efClass.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        if ((this.accessFlag & 0x400) != (efClass.accessFlag & 0x400)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        if ((this.accessFlag & 0x800) != (efClass.accessFlag & 0x800)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        this.compareCommon(efClass);
    }

    void compareCommon(EfClass efClass) {
        if (this.token != efClass.token) {
            throw new VerifierError("RevisionError.8", this.thisName());
        }
        int n = this.accessFlag & 0x200;
        int n2 = efClass.accessFlag & 0x200;
        if (n != n2) {
            throw new VerifierError("RevisionError.9", this.thisName());
        }
        if (n == 0) {
            this.compareSuperClasses(efClass);
        }
        this.compareInterfaces(efClass);
        this.compareMethodLists(efClass);
        this.compareFieldLists(efClass);
    }

    private void compareSuperClasses(EfClass efClass) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        n2 = this.supers.length;
        n = efClass.supers.length;
        if (this.sameVersion && n2 != n) {
            throw new VerifierError("RevisionError.10", this.thisName());
        }
        int n3 = 0;
        while (n3 < n2) {
            bl = false;
            String string = this.superName(n3);
            int n4 = 0;
            while (n4 < n) {
                String string2 = efClass.superName(n4);
                if (string.equals(string2)) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                throw new VerifierError("RevisionError.12", (Object)string, (Object)this.thisName());
            }
            ++n3;
        }
    }

    private void compareInterfaces(EfClass efClass) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        n2 = this.interfaces.length;
        n = efClass.interfaces.length;
        if (this.sameVersion && n2 != n) {
            throw new VerifierError("RevisionError.13", this.thisName());
        }
        int n3 = 0;
        while (n3 < n2) {
            bl = false;
            String string = this.interfaceName(n3);
            int n4 = 0;
            while (n4 < n) {
                String string2 = efClass.interfaceName(n4);
                if (string.equals(string2)) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                if (this.isInterface) {
                    throw new VerifierError("RevisionError.14", (Object)string, (Object)this.thisName());
                }
                throw new VerifierError("RevisionError.15", (Object)string, (Object)this.thisName());
            }
            ++n3;
        }
    }

    private void compareMethodLists(EfClass efClass) {
        boolean bl = false;
        EfMethod efMethod = null;
        EfMethod efMethod2 = null;
        this.newMethodList = new Vector(efClass.methods.length);
        int n = 0;
        while (n < efClass.methods.length) {
            this.newMethodList.addElement(efClass.methods[n]);
            ++n;
        }
        int n2 = this.methods.length;
        int n3 = this.newMethodList.size();
        if (this.sameVersion && n2 != n3) {
            throw new VerifierError("RevisionError.16", this.thisName());
        }
        int n4 = 0;
        while (n4 < n2) {
            bl = false;
            efMethod = this.methods[n4];
            String string = efMethod.name();
            String string2 = efMethod.sig();
            int n5 = 0;
            while (n5 < this.newMethodList.size()) {
                efMethod2 = (EfMethod)this.newMethodList.get(n5);
                String string3 = efMethod2.name();
                String string4 = efMethod2.sig();
                if (string.equals(string3) && string2.equals(string4)) {
                    bl = true;
                    this.newMethodList.removeElementAt(n5);
                    break;
                }
                ++n5;
            }
            if (bl) {
                if (this.sameVersion) {
                    efMethod.checkEquality(efMethod2);
                } else {
                    boolean bl2 = (this.accessFlag & 0x10) > (efClass.accessFlag & 0x10);
                    efMethod.compareTo(efMethod2, bl2);
                }
            } else {
                throw new VerifierError("RevisionError.18", (Object)string, (Object)this.thisName());
            }
            ++n4;
        }
    }

    private void checkNewMethods(EfClass efClass) {
        if (this.newMethodList.size() > 0) {
            if (this.isInterface) {
                EfMethod efMethod = (EfMethod)this.newMethodList.get(0);
                throw new VerifierError("RevisionError.42", (Object)efMethod.name(), (Object)this.thisName());
            }
            if ((this.accessFlag & 0x10) > 0 || (efClass.accessFlag & 0x10) > 0) {
                return;
            }
            int n = this.newMethodList.size();
            int n2 = 0;
            while (n2 < n) {
                EfMethod efMethod = (EfMethod)this.newMethodList.get(n2);
                if ((efMethod.accessFlag & 8) == 0) {
                    throw new VerifierError("RevisionError.19", (Object)efMethod.name(), (Object)this.thisName());
                }
                ++n2;
            }
        }
    }

    boolean compareFieldLists(EfClass efClass) {
        boolean bl = false;
        EfField efField = null;
        EfField efField2 = null;
        this.refExists = false;
        this.newFields = new Vector(efClass.fields.length);
        int n = 0;
        while (n < efClass.fields.length) {
            this.newFields.addElement(efClass.fields[n]);
            ++n;
        }
        int n2 = this.fields.length;
        int n3 = this.newFields.size();
        if (this.sameVersion) {
            if (n2 != n3) {
                throw new VerifierError("RevisionError.20", this.thisName());
            }
        } else if (n2 == 0) {
            return true;
        }
        int n4 = 0;
        while (n4 < n2) {
            String string;
            bl = false;
            efField = this.fields[n4];
            String string2 = efField.name();
            if (!this.refExists && (string = efField.sig()).indexOf("L") >= 0) {
                this.refExists = true;
            }
            int n5 = 0;
            while (n5 < this.newFields.size()) {
                efField2 = (EfField)this.newFields.get(n5);
                String string3 = efField2.name();
                if (string2.equals(string3)) {
                    bl = true;
                    this.newFields.removeElementAt(n5);
                    break;
                }
                ++n5;
            }
            if (bl) {
                if (this.sameVersion) {
                    efField.checkEquality(efField2);
                } else {
                    efField.compareTo(efField2);
                }
            } else {
                throw new VerifierError("RevisionError.21", (Object)string2, (Object)this.thisName());
            }
            ++n4;
        }
        return true;
    }

    void checkNewFields(EfClass efClass) {
        if (this.newFields.size() > 0 && this.refExists) {
            int n = 0;
            while (n < this.newFields.size()) {
                EfField efField = (EfField)this.newFields.get(n);
                String string = efField.sig();
                if (string.indexOf("L") < 0 && (efField.accessFlag & 8) <= 0) {
                    throw new VerifierError("RevisionError.22", (Object)efField.name(), (Object)this.thisName());
                }
                ++n;
            }
        }
    }

    public EfField getFieldForName(String string) {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].name().equals(string)) {
                return this.fields[n];
            }
            ++n;
        }
        return null;
    }

    public EfField getFieldForTokenAndFlag(int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.fields.length) {
            if (this.fields[n2].token == n && bl == this.fields[n2].isStatic()) {
                return this.fields[n2];
            }
            ++n2;
        }
        return null;
    }

    public EfMethod getMethodForNameAndSig(String string, String string2) {
        int n = 0;
        while (n < this.methods.length) {
            if (this.methods[n].name().equals(string) && this.methods[n].sig().equals(string2)) {
                return this.methods[n];
            }
            ++n;
        }
        return null;
    }
}

