/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import javacard.framework.OwnerPIN;
import javacard.framework.Shareable;
import javacardx.facilities.ServiceFactory;
import javacardx.framework.SharedPINAuth;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.servlet.http.HttpDigestAuthentication;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class PINGlobalAuthenticatorFactory
implements ServiceFactory {
    private final OwnerPIN ownerPIN;
    private final GlobalPINAuth auth;

    public PINGlobalAuthenticatorFactory(byte[] pin, int maxSize, int tryLimit) {
        this.ownerPIN = new OwnerPIN((byte)tryLimit, (byte)maxSize);
        this.ownerPIN.update(pin, (short)0, (byte)pin.length);
        this.auth = new GlobalPINAuth();
    }

    @Override
    public Shareable create(String serviceURI, Object parameter) throws SecurityException {
        if (serviceURI.startsWith("sio:///standard/auth/holder/global/") && serviceURI.endsWith("/pin")) {
            return this.auth;
        }
        return null;
    }

    public OwnerPIN getOwnerPIN() {
        return this.ownerPIN;
    }

    @TransactionType(value=TransactionTypeValue.SUPPORTS)
    private class GlobalPINAuth
    implements SharedPINAuth,
    HttpDigestAuthentication {
        private GlobalPINAuth() {
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public synchronized boolean check(byte[] pin, short offset, byte length) {
            return PINGlobalAuthenticatorFactory.this.ownerPIN.check(pin, offset, length);
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public boolean check(String username, String realm, String method, String uri, String nonce, String nc, String cnonce, String qop, String response) {
            PINGlobalAuthenticatorFactory.this.ownerPIN.reset();
            if (PINGlobalAuthenticatorFactory.this.ownerPIN instanceof HttpDigestAuthentication) {
                return ((HttpDigestAuthentication)((Object)PINGlobalAuthenticatorFactory.this.ownerPIN)).check(username, realm, method, uri, nonce, nc, cnonce, qop, response);
            }
            return false;
        }

        @Override
        public synchronized byte getTriesRemaining() {
            return PINGlobalAuthenticatorFactory.this.ownerPIN.getTriesRemaining();
        }

        @Override
        public synchronized boolean isValidated() {
            return PINGlobalAuthenticatorFactory.this.ownerPIN.isValidated();
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public synchronized void reset() {
            PINGlobalAuthenticatorFactory.this.ownerPIN.reset();
        }
    }
}

