/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import java.util.Vector;

public class InterfaceTable {
    public static final int MAX_ENTRIES = 128;
    protected int lineNumber;
    protected ClassIdentifier classIdentifier;
    protected String className;
    protected Vector<Integer> indexVector;
    protected Vector<String> nameDescrVector;
    protected JCClass parentClass;
    protected JCClass resolvedTo;

    InterfaceTable(JCClass parentClass, ClassIdentifier classIdentifier, int lineNumber) {
        assert (classIdentifier != null) : "classIdentifier != null";
        this.parentClass = parentClass;
        this.classIdentifier = classIdentifier;
        this.lineNumber = lineNumber;
        this.indexVector = new Vector();
        this.nameDescrVector = new Vector();
    }

    InterfaceTable(JCClass parentClass, String className, int lineNumber) {
        assert (className != null) : "className != null";
        this.parentClass = parentClass;
        this.className = className;
        this.lineNumber = lineNumber;
        this.indexVector = new Vector();
        this.nameDescrVector = new Vector();
    }

    public void addInterfaceIndex(int index) {
        if (this.indexVector.size() >= 128) {
            Object[] args = new Object[]{new Integer(this.lineNumber)};
            Msg.error("itable.0", args);
        } else {
            this.indexVector.addElement(new Integer(index));
        }
    }

    public void addRemoteMethodInfo(String name_descr, int index) {
        if (this.indexVector.size() >= 128) {
            Object[] args = new Object[]{new Integer(this.lineNumber)};
            Msg.error("itable.0", args);
        } else {
            this.indexVector.addElement(new Integer(index));
            this.nameDescrVector.addElement(name_descr);
        }
    }

    public String getName() {
        return this.className;
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classIdentifier;
    }

    public JCClass getParentClass() {
        return this.parentClass;
    }

    public void resolve(JCClass c) {
        assert (c != null) : "c != null";
        this.resolvedTo = c;
    }

    public JCClass resolve() {
        assert (this.resolvedTo != null) : "resolvedTo != null";
        return this.resolvedTo;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    public Vector<String> getNameDescrVector() {
        return this.nameDescrVector;
    }

    public Vector<Integer> getIndexVector() {
        return this.indexVector;
    }

    public byte[] toByteArray() {
        byte[] table = new byte[this.size()];
        int index = 0;
        if (this.isResolved()) {
            int addr = this.resolvedTo.getRelocAddr();
            table[index++] = (byte)(addr >> 8 & 0xFF);
            table[index++] = (byte)(addr & 0xFF);
        } else {
            JCPackage p = this.parentClass.getParentPackage();
            PackageIdentifier pid = this.classIdentifier.getPackageIdentifier();
            table[index++] = (byte)(p.getPackageToken(pid) | 0x80);
            table[index++] = (byte)this.classIdentifier.getClassToken();
        }
        table[index++] = (byte)this.indexVector.size();
        for (Integer i : this.indexVector) {
            table[index++] = (byte)i.intValue();
        }
        return table;
    }

    public byte[] remoteInterfaceToByteArray() {
        byte[] table = new byte[2];
        int index = 0;
        if (this.isResolved()) {
            int addr = this.resolvedTo.getRelocAddr();
            table[index++] = (byte)(addr >> 8 & 0xFF);
            table[index++] = (byte)(addr & 0xFF);
        } else {
            JCPackage p = this.parentClass.getParentPackage();
            PackageIdentifier pid = this.classIdentifier.getPackageIdentifier();
            table[index++] = (byte)(p.getPackageToken(pid) | 0x80);
            table[index++] = (byte)this.classIdentifier.getClassToken();
        }
        return table;
    }

    public int size() {
        return 3 + this.indexVector.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(".interfaceTable ");
        sb.append(this.classIdentifier != null ? this.classIdentifier.toString() : this.className);
        sb.append(" {" + Msg.eol);
        for (Integer i : this.indexVector) {
            sb.append(Msg.toHexString((byte)i.intValue()) + ";" + Msg.eol);
        }
        sb.append("}");
        return sb.toString();
    }
}

