/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.util.ZipUtils;
import java.io.File;
import java.util.Hashtable;

public abstract class FolderOrJar
extends PackageItem {
    public static Hashtable<String, String> folderMappingsForJarFiles = new Hashtable();
    protected File folder;

    public FolderOrJar(String nameAndPath) {
        this.folder = new File(nameAndPath);
    }

    @Override
    public void initialize() {
        if (!this.isOk()) {
            return;
        }
        if (this.folder.exists() && this.folder.isFile()) {
            File file = this.folder;
            this.folder = new File(Packager.getPackager().getWorkDir(), file.getName().replace('.', '_'));
            this.folder.mkdirs();
            if (!this.folder.exists()) {
                this.addError(ErrorKey.UnableToCreateTempFolder, this.folder);
                return;
            }
            this.folder.mkdirs();
            this.folder.deleteOnExit();
            try {
                ZipUtils.unzip(file, this.folder);
            }
            catch (Exception e) {
                this.addError(ErrorKey.UnableToExtractTheFile, file, e.getLocalizedMessage());
                return;
            }
            folderMappingsForJarFiles.put(this.folder.toString(), file.getAbsoluteFile().toString() + "!");
        }
        if (!this.folder.exists()) {
            this.addError(ErrorKey.DoesNotExists, this.folder);
            return;
        }
        if (!this.folder.isDirectory()) {
            this.addError(ErrorKey.IsNotADirectory, this.folder);
            return;
        }
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }

    public File getFolder() {
        return this.folder;
    }
}

