/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.FolderCrawler;
import com.sun.javacard.util.FolderCrawlerListener;
import com.sun.javacard.validator.ClassicModule;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.ExtendedModule;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.PackageItem;
import com.sun.javacard.validator.WebModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.SyntheticRepository;

public final class Classes
extends PackageItem
implements FolderCrawlerListener {
    private File folder;
    private Vector<String> names = new Vector();
    private int folderNameLength;
    private SyntheticRepository apiFilesRepository;
    private SyntheticRepository allClassFilesRepository;
    private ZipFile apiJar = null;
    String jcPath;

    public Classes(File folder) {
        String fullPath = "";
        try {
            this.jcPath = System.getProperty("jc.home", null);
            if (this.jcPath == null) {
                this.addWarning(ErrorKey.JCHomeNotSet, new Object[0]);
            } else {
                fullPath = this.jcPath + "/lib/api_connected.jar";
                this.apiJar = new ZipFile(fullPath);
                this.apiFilesRepository = SyntheticRepository.getInstance((ClassPath)new ClassPath(fullPath));
            }
        }
        catch (IOException e) {
            this.addWarning(ErrorKey.API_JarNotFound, new Object[0]);
            fullPath = "";
        }
        this.folder = folder;
        if (folder != null) {
            String prefix = folder.getAbsolutePath().replace(File.separatorChar, '.');
            if (!prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            this.folderNameLength = prefix.length();
            fullPath = fullPath.equals("") ? folder.getAbsolutePath() : fullPath + ";" + folder.getAbsolutePath();
            this.allClassFilesRepository = SyntheticRepository.getInstance((ClassPath)new ClassPath(fullPath));
        } else {
            this.allClassFilesRepository = this.apiFilesRepository;
        }
    }

    @Override
    public String getItemDisplayName() {
        if (this.folder == null) {
            return "EMPTY";
        }
        String str = "";
        if (this.getParent() != null) {
            str = this.getParent().getItemDisplayName();
        }
        str = str + "/classes:" + this.folder.getName();
        return str;
    }

    @Override
    public void initialize() {
        if (this.folder == null) {
            return;
        }
        if (!this.folder.exists()) {
            this.addError(ErrorKey.DoesNotExists, this.folder);
            return;
        }
        if (!this.folder.isDirectory()) {
            this.addError(ErrorKey.IsNotADirectory, this.folder);
            return;
        }
        FolderCrawler folderCrawler = new FolderCrawler(this.folder, this);
        folderCrawler.crawl();
    }

    public InputStream getClassFileStream(String name) {
        File f;
        ZipEntry zipEntry;
        if (this.apiJar != null && (zipEntry = this.apiJar.getEntry(name.replace('.', '/') + ".class")) != null) {
            System.err.println("\n\nFound ZipEntry " + name);
            try {
                return this.apiJar.getInputStream(zipEntry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((f = this.getClassFile(name)) == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        return fis;
    }

    private File getClassFile(String name) {
        if (this.folder == null || !this.getNames().contains(name)) {
            return null;
        }
        return new File(this.folder, name.replace('.', File.separatorChar) + ".class");
    }

    @Override
    public void processInternal() {
        if (this.folder == null) {
            return;
        }
        JavaClass javaClass = null;
        String packageNameFromClassFile = null;
        String packageNameFromPath = null;
        for (String name : this.names) {
            Method[] methods;
            try {
                javaClass = this.allClassFilesRepository.loadClass(name);
            }
            catch (Exception e) {
                this.addError(ErrorKey.UnableToParseTheClassFile, name.replace('.', File.separatorChar) + ".class", e.getLocalizedMessage());
                continue;
            }
            if (javaClass.getMajor() != 50) {
                // empty if block
            }
            packageNameFromClassFile = javaClass.getPackageName();
            int dotIndex = name.lastIndexOf(46);
            packageNameFromPath = dotIndex == -1 ? "" : name.substring(0, dotIndex);
            if (!packageNameFromPath.equals(packageNameFromClassFile)) {
                this.addWarning(ErrorKey.MismatchedPackageName, name, packageNameFromClassFile);
            }
            if (this.jcPath == null || !javaClass.isInterface() || !this.isShareable(javaClass)) continue;
            for (Method m : methods = javaClass.getMethods()) {
            }
        }
    }

    boolean isShareable(JavaClass javaClass) {
        JavaClass[] ifaces = null;
        try {
            ifaces = javaClass.getAllInterfaces();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        if (ifaces != null) {
            for (JavaClass iface : ifaces) {
                if (!iface.getClassName().equals("javacard.framework.Shareable")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void fileFound(File file) {
        if (file.isDirectory()) {
            return;
        }
        String name = file.getAbsolutePath().replace(File.separatorChar, '.');
        if (!name.endsWith(".class")) {
            return;
        }
        name = name.substring(this.folderNameLength);
        name = name.substring(0, name.lastIndexOf(".class")).replace(File.separatorChar, '.');
        this.names.addElement(name);
    }

    public File getFolder() {
        return this.folder;
    }

    public Vector<String> getNames() {
        return this.names;
    }

    public boolean isBelongsToModule() {
        return this.getParent() != null && this.getParent() instanceof Module;
    }

    public boolean belongsToWebModule() {
        return this.getParent() != null && this.getParent() instanceof WebModule;
    }

    public boolean belongsToClassicModule() {
        return this.getParent() != null && this.getParent() instanceof ClassicModule;
    }

    public boolean belongsToExtendedModule() {
        return this.getParent() != null && this.getParent() instanceof ExtendedModule;
    }

    public boolean containsInAPI(String name) {
        if (this.apiJar == null) {
            return false;
        }
        return this.apiJar.getEntry(name.replace('.', '/') + ".class") != null;
    }

    public boolean areSIMethodParamsAndReturnValid(Method m) {
        Type[] params;
        for (Type param : params = m.getArgumentTypes()) {
            if (this.isValidParameterOrReturnType(param)) continue;
            this.addError(ErrorKey.invalidParameterForSIMethod, param.toString(), m.toString());
            return false;
        }
        if (!this.isValidParameterOrReturnType(m.getReturnType())) {
            this.addError(ErrorKey.invalidParameterForSIMethod, m.getReturnType().toString(), m.toString());
            return false;
        }
        return true;
    }

    public boolean isValidParameterOrReturnType(Type type) {
        JavaClass javaClass;
        return !(type instanceof ReferenceType) || type instanceof ArrayType || (javaClass = this.getJavaClass(type.toString())) == null || !(!javaClass.isInterface() ? !type.equals((Object)Type.STRING) : !this.isShareable(javaClass));
    }

    public JavaClass getJavaClass(String className) {
        JavaClass javaClass = this.allClassFilesRepository.findClass(className);
        try {
            if (javaClass == null) {
                javaClass = this.allClassFilesRepository.loadClass(className);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return javaClass;
    }

    public boolean isAPIImplClass(String className) {
        try {
            JavaClass javaClass = this.apiFilesRepository.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Vector<String> getNamesOfClassesInPackage(String pkgName) {
        Vector<String> proxyClassNames = new Vector<String>();
        JavaClass javaClass = null;
        for (String name : this.names) {
            try {
                javaClass = this.allClassFilesRepository.loadClass(name);
            }
            catch (Exception e) {
                this.addError(ErrorKey.UnableToParseTheClassFile, name.replace('.', File.separatorChar) + ".class", e.getLocalizedMessage());
                continue;
            }
            String classPkgName = javaClass.getPackageName();
            if (!pkgName.equals(classPkgName)) continue;
            proxyClassNames.add(name);
        }
        return proxyClassNames;
    }
}

