/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.installer;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.installer.AppletComponent;
import com.sun.javacard.installer.ClassComponent;
import com.sun.javacard.installer.Component;
import com.sun.javacard.installer.ConstantPoolComponent;
import com.sun.javacard.installer.DirectoryComponent;
import com.sun.javacard.installer.ExportComponent;
import com.sun.javacard.installer.HeaderComponent;
import com.sun.javacard.installer.ImportComponent;
import com.sun.javacard.installer.InstallerException;
import com.sun.javacard.installer.MethodComponent;
import com.sun.javacard.installer.ReferenceLocationComponent;
import com.sun.javacard.installer.StaticFieldComponent;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;

class Installer
extends Component {
    private static boolean installerRunning;
    static Component[] f_linkers;
    static byte[] f_downloadOrder;

    protected Installer() {
        if (installerRunning) {
            ISOException.throwIt((short)27904);
        }
        installerRunning = true;
        f_linkers = new Component[11];
        Installer.f_linkers[1] = new HeaderComponent();
        Installer.f_linkers[2] = new DirectoryComponent();
        Installer.f_linkers[3] = new AppletComponent();
        Installer.f_linkers[4] = new ImportComponent();
        Installer.f_linkers[5] = new ConstantPoolComponent();
        Installer.f_linkers[6] = new ClassComponent();
        Installer.f_linkers[7] = new MethodComponent();
        Installer.f_linkers[8] = new StaticFieldComponent();
        Installer.f_linkers[9] = new ReferenceLocationComponent();
        Installer.f_linkers[10] = new ExportComponent();
    }

    void install(APDU apdu) {
        try {
            g_buffer = apdu.getBuffer();
            g_ins = g_buffer[1];
            this.verifyAPDUOrder(apdu);
            g_p1 = g_buffer[2];
            g_p2 = g_buffer[3];
            g_lc = g_buffer[4];
            g_dataOffset = (short)5;
            if (g_ins == -76 || g_ins == -72) {
                g_dataSize = apdu.setIncomingAndReceive();
            }
            switch (g_ins) {
                case -80: {
                    Installer.resetLinker();
                    PackageMgr.reset();
                    if (PackageMgr.g_newPackageIdentifier == -1) {
                        InstallerException.throwIt((short)25655);
                    }
                    break;
                }
                case -78: 
                case -76: 
                case -68: {
                    if (PackageMgr.g_packageInProcess == -1) {
                        InstallerException.throwIt((short)25637);
                    }
                    if (g_p1 < 1 || g_p1 > 10) {
                        InstallerException.throwIt((short)25654);
                    }
                    if (g_ins == -78) {
                        f_linkers[g_p1].init();
                        break;
                    }
                    if (g_ins == -76) {
                        f_linkers[g_p1].process();
                        break;
                    }
                    f_linkers[g_p1].postProcess();
                    break;
                }
                case -70: {
                    if (PackageMgr.g_tempMemoryAddress != 0) {
                        PackageMgr.freeTempMemory();
                    }
                    boolean doCommit = false;
                    if (JCSystem.getTransactionDepth() == 0) {
                        JCSystem.beginTransaction();
                        doCommit = true;
                    }
                    if (PackageMgr.g_newPackage != null) {
                        NativeMethods.installDebugInfo((byte)Component.g_pkgAIDLength, (byte[])Component.g_pkgAID, (int[])Component.g_componentAddresses);
                    }
                    PackageMgr.commit();
                    if (doCommit) {
                        JCSystem.commitTransaction();
                    }
                    g_currentState = 0;
                    break;
                }
                case -72: {
                    AppletComponent.create(apdu);
                    break;
                }
                case -66: {
                    PackageMgr.restore();
                    Installer.echoError((short)25615);
                    break;
                }
                default: {
                    ISOException.throwIt((short)27904);
                    break;
                }
            }
        }
        catch (ISOException e) {
            PackageMgr.restore();
            short reason = e.getReason();
            if (reason != -28672) {
                Installer.echoError(reason);
            }
        }
        catch (InstallerException e) {
            PackageMgr.restore();
            Installer.echoError(e.getReason());
        }
        catch (Exception e) {
            PackageMgr.restore();
            Installer.echoError((short)25636);
        }
    }

    void verifyAPDUOrder(APDU apdu) throws InstallerException {
        byte m_ins = apdu.getBuffer()[1];
        byte m_tag = apdu.getBuffer()[2];
        if (m_ins == -80) {
            return;
        }
        if (g_currentState == -1) {
            if (m_ins == -70) {
                Installer.g_loadComplete[9] = false;
                Installer.g_loadComplete[1] = false;
            }
            InstallerException.throwIt((short)25633);
        }
        switch (m_ins) {
            case -78: 
            case -76: 
            case -68: {
                if (m_tag == g_p1 || g_p1 < 1) break;
                if (f_downloadOrder[m_tag] < f_downloadOrder[g_p1]) {
                    InstallerException.throwIt((short)25634);
                }
                if (f_downloadOrder[m_tag] > (byte)(f_downloadOrder[g_p1] + 1)) {
                    if (m_tag == 6 ? f_downloadOrder[g_p1] + 1 == 4 && (g_capFlags & 4) == 0 : m_tag == 5 && (byte)(f_downloadOrder[g_p1] + 1) == 8 && (g_capFlags & 2) == 0) break;
                    InstallerException.throwIt((short)25634);
                }
                if (g_loadComplete[g_p1]) break;
                InstallerException.throwIt((short)25634);
                break;
            }
            case -72: 
            case -70: {
                if (g_currentState != 0 || g_loadComplete[1] != g_loadComplete[9]) {
                    InstallerException.throwIt((short)25637);
                }
                g_currentState = 0;
                break;
            }
            case -66: {
                break;
            }
            default: {
                InstallerException.throwIt((short)27904);
            }
        }
    }

    static {
        f_downloadOrder = new byte[]{0, 1, 2, 4, 3, 9, 5, 6, 7, 10, 8, 0};
    }
}

