/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.Statement;

public class InstrTableSwitch {
    public int dfl;
    public int low;
    public int high;
    public int[] offsets;
    Instruction instr;

    public InstrTableSwitch(int pc, Instruction instr, Statement[] code) {
        this.instr = instr;
        this.setupInstruction(pc, code);
    }

    private void setupInstruction(int pc, Statement[] code) {
        this.dfl = this.getJumpInstructionOffset(pc, this.instr.operandVector.elementAt(0).getValue(), code);
        int opSize = this.instr.operandVector.size();
        this.offsets = new int[opSize - 3];
        int i = 3;
        int j = 0;
        while (i < opSize) {
            this.offsets[j] = this.getJumpInstructionOffset(pc, this.instr.operandVector.elementAt(i).getValue(), code);
            ++i;
            ++j;
        }
    }

    int getJumpInstructionOffset(int pc, int requiredJumpSize, Statement[] code) {
        int jumpSize = 0;
        while (jumpSize < requiredJumpSize) {
            jumpSize += code[pc].size();
            ++pc;
        }
        return pc;
    }
}

