/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils.instructions;

import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.Instr;
import java.util.Vector;

public class JCObjectInstr
extends Instruction {
    public static final int CLASS_T_BOOLEAN = 4;
    public static final int CLASS_T_BYTE = 8;
    public static final int CLASS_T_SHORT = 9;
    public static final int CLASS_T_INT = 10;
    private byte[] args;
    Vector<Integer> argVector = new Vector();

    public JCObjectInstr(Instr jcInstruction, ClassConstantPool cp) {
        super(jcInstruction);
        switch (jcInstruction.opcode) {
            case 143: {
                this.resolveCPIndexAndSetArgs((short)jcInstruction.arg, cp);
                this.javaInstructions.add(new JavaInstruction(187, this.argVector));
                break;
            }
            case 144: {
                this.argVector.add(new Integer(this.getArrayType(jcInstruction.arg)));
                this.javaInstructions.add(new JavaInstruction(188, this.argVector));
                break;
            }
            case 145: {
                this.resolveCPIndexAndSetArgs((short)jcInstruction.arg, cp);
                this.javaInstructions.add(new JavaInstruction(189, this.argVector));
                break;
            }
            case 146: {
                this.javaInstructions.add(new JavaInstruction(190));
                break;
            }
            case 148: {
                this.setObjectTypeCPIndexArg(jcInstruction.arg, jcInstruction.arg2, cp);
                this.javaInstructions.add(new JavaInstruction(192, this.argVector));
                break;
            }
            case 149: {
                this.setObjectTypeCPIndexArg(jcInstruction.arg, jcInstruction.arg2, cp);
                this.javaInstructions.add(new JavaInstruction(193, this.argVector));
            }
        }
    }

    public JCObjectInstr(int arrayType) {
        super(null);
        this.argVector.add(arrayType);
        this.javaInstructions.add(new JavaInstruction(188, this.argVector));
    }

    private void resolveCPIndexAndSetArgs(short capCPIndex, ClassConstantPool cp) {
        ConstantPoolEntry capCPEntry = Cap.getConstantPool().entry(capCPIndex);
        String refName = CAPUtil.getRefName(capCPEntry.classRef());
        short classCPIndex = cp.getClassRefIndex(refName);
        byte[] argBytes = Util.getShortBytes(classCPIndex);
        this.argVector.add(new Integer(argBytes[0] & 0xFF));
        this.argVector.add(new Integer(argBytes[1] & 0xFF));
    }

    private int getArrayType(int type) {
        switch (type) {
            case 10: {
                return 4;
            }
            case 11: {
                return 8;
            }
            case 12: {
                return 9;
            }
            case 13: {
                return 10;
            }
        }
        System.out.println("Encountered bad array type");
        return 0;
    }

    private void setObjectTypeCPIndexArg(int type, int CapCPEntryIndex, ClassConstantPool cp) {
        ConstantPoolEntry capCPEntry;
        String refName = null;
        if (type != 0) {
            switch (type) {
                case 10: {
                    refName = "[Z";
                    break;
                }
                case 11: {
                    refName = "[B";
                    break;
                }
                case 12: {
                    refName = "[S";
                    break;
                }
                case 13: {
                    refName = "[I";
                    break;
                }
                case 14: {
                    capCPEntry = Cap.getConstantPool().entry(CapCPEntryIndex);
                    refName = CAPUtil.getRefName(capCPEntry.classRef());
                    refName = "[L" + refName + ";";
                }
            }
        } else {
            capCPEntry = Cap.getConstantPool().entry(CapCPEntryIndex);
            refName = CAPUtil.getRefName(capCPEntry.classRef());
        }
        short classCPIndex = cp.getClassRefIndex(refName);
        byte[] argBytes = Util.getShortBytes(classCPIndex);
        this.argVector.add(new Integer(argBytes[0] & 0xFF));
        this.argVector.add(new Integer(argBytes[1] & 0xFF));
    }
}

