/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.Converter;
import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.AppletXml;
import com.sun.javacard.jcasm.cap.CapWriter;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.JavacardXml;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.ReferenceSIChecker;
import com.sun.javacard.jcasm.cap.SIOProxyClassesGen;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CapGen {
    public static final int ACC_INT = 1;
    public static final int ACC_EXPORT = 2;
    public static final int ACC_APPLET = 4;
    JCPackage f_package;
    HeaderComponent f_header;
    ImportComponent f_import;
    AppletComponent f_applet;
    ConstantPoolComponent f_constantPool;
    ClassComponent f_class;
    MethodComponent f_method;
    StaticFieldComponent f_staticField;
    ExportComponent f_export;
    ReferenceLocationComponent f_refLocation;
    DescriptorComponent f_descriptor;
    DirectoryComponent f_directory;
    JavacardXml f_javacardXml = null;
    AppletXml f_appletXml = null;
    File[] f_sioProxyClasses = null;

    public ConstantPoolComponent getConstantPoolComponent() {
        return this.f_constantPool;
    }

    public ImportComponent getImportComponent() {
        return this.f_import;
    }

    public void gen(JCPackage pack, File outFile, ConversionProfile cp, Converter conv) throws Exception {
        if (Globals.debugComp != null) {
            pack.set22Flag();
        }
        this.f_package = pack;
        this.f_method = this.genMethodComponent(this.f_package);
        this.f_staticField = this.genStaticFieldComponent(this.f_package);
        this.f_class = this.genClassComponent(this.f_package);
        this.f_import = this.genImportComponent(this.f_package);
        this.f_applet = this.genAppletComponent(this.f_package);
        this.f_constantPool = this.genConstantPoolComponent(this.f_package);
        this.f_export = this.genExportComponent(this.f_package);
        this.f_refLocation = this.genReferenceLocationComponent(this.f_package);
        this.f_descriptor = this.genDescriptorComponent(this.f_package);
        this.f_header = this.genHeaderComponent(this.f_package);
        this.f_directory = new DirectoryComponent(this.f_package, this.f_header, this.f_applet, this.f_import, this.f_constantPool, this.f_class, this.f_method, this.f_staticField, this.f_refLocation, this.f_export, this.f_descriptor, Globals.debugComp);
        if (this.f_package.appletCount() > 0) {
            this.f_appletXml = new AppletXml(this.f_package);
        }
        boolean proxyClassesGenerated = false;
        if (cp.useProxyClass) {
            File f = new File(cp.class_root + File.separatorChar + this.f_package.getName() + File.separatorChar + "proxy");
            this.f_sioProxyClasses = f.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(".class");
                }
            });
        } else {
            String outputDir = null;
            String pkgName = null;
            if (conv != null) {
                boolean checkExportOnly = false;
                if (cp.output == 2) {
                    checkExportOnly = true;
                }
                ReferenceSIChecker siChecker = new ReferenceSIChecker(conv.getJcPakcage(), conv.getExportFileManager(), checkExportOnly);
                Vector<Hashtable<String, MethodDefinition[]>> exacts = siChecker.getExactProxies();
                siChecker.check();
                Hashtable<String, MethodDefinition[]> siTable = siChecker.getSIMethodsTable();
                if (siTable.size() > 0) {
                    pkgName = this.f_package.getName();
                    String classRoot = cp.class_root;
                    String[] exportPath = cp.export_path;
                    outputDir = cp.output_dir;
                    SIOProxyClassesGen sioProxyClassesGen = new SIOProxyClassesGen(pkgName, siTable, classRoot, exportPath, outputDir, exacts);
                    this.f_sioProxyClasses = sioProxyClassesGen.generate();
                    if (this.f_sioProxyClasses != null) {
                        proxyClassesGenerated = true;
                    }
                }
            }
        }
        if (JavacardXml.hasShareableInterfacesToExpose(this.f_package) || proxyClassesGenerated || cp.useProxyClass) {
            this.f_javacardXml = new JavacardXml(this.f_package, this.f_sioProxyClasses);
        }
        if (Globals.errors == 0 && Globals.debug) {
            String lead = "// " + this.f_package.getName() + "/javacard/";
            if ((Globals.debugLevel & 1) != 0) {
                System.out.println(lead + "Header.cap" + Msg.eol + this.f_header);
            }
            if ((Globals.debugLevel & 2) != 0) {
                System.out.println(lead + "Directory.cap" + Msg.eol + this.f_directory);
            }
            if ((Globals.debugLevel & 4) != 0 && this.f_applet != null) {
                System.out.println(lead + "Applet.cap" + Msg.eol + this.f_applet);
            }
            if ((Globals.debugLevel & 8) != 0) {
                System.out.println(lead + "Import.cap" + Msg.eol + this.f_import);
            }
            if ((Globals.debugLevel & 0x10) != 0) {
                System.out.println(lead + "ConstantPool.cap" + Msg.eol + this.f_constantPool);
            }
            if ((Globals.debugLevel & 0x20) != 0) {
                System.out.println(lead + "Class.cap" + Msg.eol + this.f_class);
            }
            if ((Globals.debugLevel & 0x40) != 0) {
                System.out.println(lead + "Method.cap" + Msg.eol + this.f_method);
            }
            if ((Globals.debugLevel & 0x80) != 0) {
                System.out.println(lead + "StaticField.cap" + Msg.eol + this.f_staticField);
            }
            if ((Globals.debugLevel & 0x100) != 0) {
                System.out.println(lead + "RefLocation.cap" + Msg.eol + this.f_refLocation);
            }
            if ((Globals.debugLevel & 0x200) != 0 && this.f_export != null) {
                System.out.println(lead + "Export.cap" + Msg.eol + this.f_export);
            }
            if ((Globals.debugLevel & 0x400) != 0) {
                System.out.println(lead + "Descriptor.cap" + Msg.eol + this.f_descriptor);
            }
            if ((Globals.debugLevel & 0x800) != 0) {
                System.out.println(lead + "Debug.cap" + Msg.eol + Globals.debugComp);
            }
        }
        CapWriter cw = new CapWriter(outFile, this.f_package.getName());
        if (cp.useCapComponents) {
            cw.publishUsingCapComponents(cp, this.f_header, this.f_sioProxyClasses, this.f_appletXml, this.f_javacardXml);
        } else if ((cp.output & 8) == 8) {
            cw.publish(cp.classes, this.f_sioProxyClasses, this.f_appletXml, this.f_javacardXml, cp, this.f_header);
        } else {
            cw.publish(this.f_header, this.f_directory, this.f_applet, this.f_import, this.f_constantPool, this.f_class, this.f_method, this.f_staticField, this.f_refLocation, this.f_export, this.f_descriptor, Globals.debugComp, cp.classes, this.f_sioProxyClasses, this.f_appletXml, this.f_javacardXml);
        }
    }

    HeaderComponent genHeaderComponent(JCPackage p) {
        int flags = 0;
        if (p.usesIntegers()) {
            flags = 1;
        }
        if (this.f_export != null && this.f_export.size() >= 4) {
            flags |= 2;
        }
        if (p.appletCount() > 0) {
            flags |= 4;
        }
        return new HeaderComponent(p, p.getIdentifier().getAid(), p.getIdentifier().getMajorVersion(), p.getIdentifier().getMinorVersion(), flags);
    }

    ClassComponent genClassComponent(JCPackage p) {
        ClassComponent cl = new ClassComponent(p);
        Enumeration<JCClass> f = p.classElements();
        while (f.hasMoreElements()) {
            cl.add(f.nextElement());
        }
        cl.assignAddresses();
        return cl;
    }

    MethodComponent genMethodComponent(JCPackage p) {
        MethodComponent m = new MethodComponent(p);
        Enumeration<JCClass> f = p.classElements();
        while (f.hasMoreElements()) {
            m.add(f.nextElement());
        }
        m.assignAddresses();
        return m;
    }

    ConstantPoolComponent genConstantPoolComponent(JCPackage p) {
        ConstantPoolComponent cp = new ConstantPoolComponent(p);
        Enumeration<Info> f = p.constantPoolElements();
        while (f.hasMoreElements()) {
            cp.add(f.nextElement());
        }
        return cp;
    }

    ImportComponent genImportComponent(JCPackage p) {
        ImportComponent i = new ImportComponent(p);
        Enumeration<PackageIdentifier> f = p.importElements();
        while (f.hasMoreElements()) {
            i.add(f.nextElement());
        }
        return i;
    }

    AppletComponent genAppletComponent(JCPackage p) {
        if (p.appletCount() == 0) {
            return null;
        }
        AppletComponent a = new AppletComponent(p);
        Enumeration<AppletDeclarator> f = p.appletElements();
        while (f.hasMoreElements()) {
            a.add(f.nextElement());
        }
        return a;
    }

    ExportComponent genExportComponent(JCPackage p) {
        ExportComponent e = new ExportComponent(p);
        Enumeration<JCClass> f = p.classElements();
        while (f.hasMoreElements()) {
            e.add(f.nextElement());
        }
        if (e.dataSize() > 1) {
            return e;
        }
        return null;
    }

    StaticFieldComponent genStaticFieldComponent(JCPackage p) {
        StaticFieldComponent sf = new StaticFieldComponent(p);
        Enumeration<JCClass> f = p.classElements();
        while (f.hasMoreElements()) {
            sf.add(f.nextElement());
        }
        sf.assignAddresses();
        return sf;
    }

    ReferenceLocationComponent genReferenceLocationComponent(JCPackage p) {
        ReferenceLocationComponent rl = new ReferenceLocationComponent(p);
        Enumeration<JCClass> f = p.classElements();
        while (f.hasMoreElements()) {
            rl.addException(f.nextElement());
        }
        f = p.classElements();
        while (f.hasMoreElements()) {
            rl.add(f.nextElement());
        }
        return rl;
    }

    DescriptorComponent genDescriptorComponent(JCPackage p) {
        DescriptorComponent d = new DescriptorComponent(p);
        Enumeration<JCClass> f = p.classElements();
        while (f.hasMoreElements()) {
            d.add(f.nextElement());
        }
        return d;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lead = "// " + this.f_package.getName() + "/javacard/";
        sb.append(lead + "Header.cap" + Msg.eol + this.f_header);
        sb.append(lead + "Directory.cap" + Msg.eol + this.f_directory);
        if (this.f_applet != null) {
            sb.append(lead + "Applet.cap" + Msg.eol + this.f_applet);
        }
        sb.append(lead + "Import.cap" + Msg.eol + this.f_import);
        sb.append(lead + "ConstantPool.cap" + Msg.eol + this.f_constantPool);
        sb.append(lead + "Class.cap" + Msg.eol + this.f_class);
        sb.append(lead + "Method.cap" + Msg.eol + this.f_method);
        sb.append(lead + "StaticField.cap" + Msg.eol + this.f_staticField);
        sb.append(lead + "RefLocation.cap" + Msg.eol + this.f_refLocation);
        if (this.f_export != null) {
            sb.append(lead + "Export.cap" + Msg.eol + this.f_export);
        }
        sb.append(lead + "Descriptor.cap" + Msg.eol + this.f_descriptor);
        sb.append(lead + "Debug.cap" + Msg.eol + Globals.debugComp);
        return sb.toString();
    }
}

