/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.ReferenceTypeConverters;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ArrayTypeConverters {
    static void registerArrayTypeConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(4, 1, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.NEW_ARRAY){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState handlerState, DataOutputStream toVm) throws Exception {
                Log.LOGN(3, "ArrayType: NewInstance");
                int arrayTypeID = handlerState.in.readInt();
                int count = handlerState.in.readInt();
                ClassDebugInfo cl = this.proxy.state().classes().getClassByID(arrayTypeID);
                if (cl == null) {
                    throw new InvalidRequestException(20);
                }
                if (cl.getJDWPTypeTag() != 3) {
                    throw new InvalidRequestException(508);
                }
                String signature = cl.getClassSignature();
                if (signature == null || signature.length() == 1) {
                    throw new InvalidRequestException(508);
                }
                String elementTypeSignature = signature.substring(1);
                byte tag = ReferenceTypeConverters.getTypeTag(elementTypeSignature);
                toVm.writeByte(tag);
                toVm.writeShort((short)count);
                if (tag != 66 && tag != 90 && tag != 83 && tag != 73) {
                    ClassDebugInfo elementType = this.proxy.state().classes().getClassBySignature(elementTypeSignature);
                    if (elementType == null) {
                        throw new InvalidRequestException(508);
                    }
                    toVm.writeByte((byte)elementType.getPackageID());
                    toVm.writeShort((short)elementType.getLocation());
                }
                return ClassicPacketHandler.DeliveryType.NORMAL;
            }

            @Override
            public void processResponseData(HandlerState state, DataInputStream fromVm, int length) throws Exception {
                EncodingUtils.copy(fromVm, state.out, length);
            }
        });
    }
}

