/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.appletcontainer;

import com.sun.javacard.appletcontainer.APDUComm;
import com.sun.javacard.appletcontainer.AppletServer;
import com.sun.javacard.appletcontainer.ChannelManager;
import com.sun.javacard.appletcontainer.T0APDUImpl;
import com.sun.javacard.appletcontainer.T1APDUImpl;
import com.sun.javacard.cm.impl.ApplicationImpl;
import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PrivAccess;
import com.sun.javacard.reflect.Constructor;
import com.sun.javacard.util.APDUUtil;
import com.sun.javacard.util.JCSystemAccessor;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.MultiSelectable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacardx.apdu.ExtendedLength;
import javacardx.framework.ClassicSIOProxy;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class APDUDispatcher
extends Thread {
    public static final int CONTACTED_PORT = 0;
    public static final int CONTACTLESS_PORT = 1;
    private static final byte INS_SELECT = -92;
    private static final byte INS_MANAGECHANNEL = 112;
    private static final byte P1_SELECT_DFBYNAME = 4;
    private static final byte P2_SELECT_OPTIONS = -29;
    private static final byte P2_SELECT_OPTIONS_ONLY = 0;
    private static final byte P1_OPEN_CHANNEL = 0;
    private static final byte P1_CLOSE_CHANNEL = -128;
    private static final byte P2_AUTOSELECT_CHANNEL = 0;
    private static final byte ERR_NO_CHANNEL_AVAILABLE = -1;
    private static final byte BASIC_CHANNEL = 0;
    private static final byte CHANNEL_MS_MASK = 1;
    private static final byte CHANNEL_OPEN_MASK = 2;
    private APDU apdu;
    private APDUComm apduProtocol;
    private byte[] apduBuffer;
    private int protocol;
    private int port;
    private int interfaceID;
    private ChannelManager channelManager;
    private short statusWord = 0;
    private byte appCurrentlySelected = (byte)-1;
    private static byte newAppBeingSelected = (byte)-1;
    private static byte newAppBeingSelectedOnChannel = (byte)-1;
    private static boolean deselectionInProgress = false;

    public APDUDispatcher(int port, int interfaceID, int protocol) {
        this.port = port;
        this.interfaceID = interfaceID;
        this.protocol = protocol;
        this.channelManager = new ChannelManager(this, interfaceID);
        this.channelManager.resetChannelInfoNative();
        if (protocol == 0) {
            this.apduProtocol = new T0APDUImpl(port);
        } else if (protocol == 1 || protocol == -111) {
            this.apduProtocol = new T1APDUImpl(port, protocol);
        }
        NativeMethods.setJCREentry(this.apduProtocol, false);
        Constructor apduConstructor = new Constructor(APDU.class, "(Lcom/sun/javacard/appletcontainer/APDUComm;)V");
        this.apdu = (APDU)apduConstructor.newInstance(this.apduProtocol);
        NativeMethods.setJCREentry(this.apdu, true);
        this.apduBuffer = this.apdu.getBuffer();
        NativeMethods.setJCREentry(this.apduBuffer, true);
    }

    public APDU getAPDU() {
        return this.apdu;
    }

    public byte[] getAPDUBuffer() {
        return this.apduBuffer;
    }

    public byte getCLAChannel() {
        return this.apduProtocol.getCLAChannel();
    }

    public short getInBlockSize() {
        return this.apduProtocol.getInBlockSize();
    }

    public short getOutBlockSize() {
        return this.apduProtocol.getOutBlockSize();
    }

    public byte getProtocol() {
        return this.apduProtocol.getProtocol();
    }

    public boolean inProcessMethod() {
        return this.apduProtocol.inProcessMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    this.apduProtocol.resetSelectingAppletFlag();
                    this.apduProtocol.resetProcessMethodFlag();
                    this.apduProtocol.complete(this.statusWord);
                    byte activeInterface = this.getActiveInterface();
                    this.apduProtocol.verifyLe();
                    if (!this.processAndForward()) continue;
                    byte commandChannel = this.channelManager.getCurrentChannel();
                    if (this.getSelectedAppID(commandChannel) == -1) {
                        throw new ISOException(27033);
                    }
                    this.apduProtocol.setProcessMethodFlag();
                    Applet selectedApplet = this.getSelectedApplet(commandChannel);
                    if (selectedApplet instanceof ExtendedLength) {
                        this.apduProtocol.markExtendedSupport(true);
                    } else {
                        this.apduProtocol.markExtendedSupport(false);
                    }
                    if (selectedApplet == null) continue;
                    if (this.isSelectedAppletClassic(commandChannel)) {
                        Object object = ClassicSIOProxy.CLASSIC_APPLET_CONTAINER_MUTEX;
                        synchronized (object) {
                            this.statusWord = this.callProcess(selectedApplet, true);
                            continue block6;
                        }
                    }
                    this.statusWord = this.callProcess(selectedApplet, false);
                }
            }
            catch (ISOException ex) {
                this.statusWord = ex.getReason();
                continue;
            }
            catch (Throwable e) {
                this.statusWord = (short)28416;
                continue;
            }
            break;
        }
    }

    public boolean selectingApplet() {
        return this.apduProtocol.selectingApplet();
    }

    public boolean amIBeingReselected() {
        if (deselectionInProgress) {
            byte currentAppId = this.getSelectedAppID(newAppBeingSelectedOnChannel);
            return currentAppId == newAppBeingSelected;
        }
        byte selectedAppID = NativeMethods.getPreviousAppId();
        return this.appCurrentlySelected == selectedAppID;
    }

    public void waitExtension() {
        this.apduProtocol.waitExtension();
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    private short callProcess(Applet selectedApplet, boolean isClassic) throws Exception {
        boolean ISOExceptionThrown = false;
        short sw = 0;
        try {
            selectedApplet.process(this.apdu);
            sw = -28672;
        }
        catch (ISOException ex) {
            sw = ex.getReason();
            ISOExceptionThrown = true;
        }
        catch (Throwable e) {
            sw = 28416;
        }
        if (isClassic && NativeMethods.getTransactionDepthNative() != 0) {
            NativeMethods.abortTransactionNative();
            if (!ISOExceptionThrown) {
                throw new Exception();
            }
        }
        return sw;
    }

    public byte getActiveInterface() {
        if (this.interfaceID == 0) {
            return 0;
        }
        return 1;
    }

    private void setAPDUChannel(boolean forISOStandardAPDU) throws SystemException {
        byte theAPDUChannel = APDU.getCLAChannel();
        if (theAPDUChannel >= 20) {
            throw new ISOException(26753);
        }
        if (!forISOStandardAPDU && this.channelManager.getStatus(theAPDUChannel) == 0) {
            throw new ISOException(26753);
        }
        this.channelManager.setCurrentChannel(theAPDUChannel);
    }

    private boolean processAndForward() throws ISOException {
        if (this.apdu.isValidCLA() && this.apdu.isISOInterindustryCLA()) {
            this.setAPDUChannel(true);
            switch (this.apduBuffer[1]) {
                case -92: {
                    if (this.apdu.isSecureMessagingCLA()) break;
                    this.selectAPDU(this.apdu);
                    return true;
                }
                case 112: {
                    if (this.apdu.isSecureMessagingCLA()) {
                        throw new ISOException(26754);
                    }
                    this.manageChannelAPDU(this.apdu);
                    return false;
                }
            }
        } else {
            this.setAPDUChannel(false);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void manageChannelAPDU(APDU theAPDU) throws ISOException {
        newChannel = -1;
        cmdChannel = this.channelManager.getCurrentChannel();
        maxChannels = (byte)this.channelManager.getMaxChannels();
        if (maxChannels == 1) {
            throw new ISOException(26753);
        }
        if (this.channelManager.getCurrentStatus() == 0) {
            throw new ISOException(26753);
        }
        opType = this.apduBuffer[2];
        managedChannel = this.apduBuffer[3];
        if (!this.channelManager.isValidChannel(managedChannel)) {
            throw new ISOException(27265);
        }
        channelStatus = this.channelManager.getStatus(managedChannel);
        switch (opType) {
            case -128: {
                if (managedChannel == 0) {
                    throw new ISOException(27265);
                }
                if ((channelStatus & 2) == 2) {
                    this.deselectOnly(managedChannel, false);
                    this.channelManager.manageChannel(managedChannel, (byte)0);
                    break;
                }
                throw new ISOException(25088);
            }
            case 0: {
                if (managedChannel == 0) {
                    le = theAPDU.setOutgoing();
                    if (le != 1) {
                        throw new ISOException(27649);
                    }
                    newChannel = this.channelManager.manageChannel((byte)-1, (byte)2);
                    if (newChannel == -1) {
                        throw new ISOException(27265);
                    }
                } else if (this.channelManager.manageChannel(managedChannel, (byte)1) != -1) {
                    newChannel = managedChannel;
                } else {
                    throw new ISOException(27270);
                }
                try {
                    if (cmdChannel == 0) {
                        this.selectDefaultApplet(newChannel);
                    } else {
                        selAppletID = this.getSelectedAppID(cmdChannel);
                        if (selAppletID != -1) {
                            this.selectOnly(newChannel, selAppletID);
                        }
                    }
                }
                catch (ISOException isoEx) {
                    this.channelManager.manageChannel(newChannel, (byte)0);
                    throw new ISOException(isoEx.getReason());
                }
                catch (SystemException se) {
                    this.channelManager.manageChannel(newChannel, (byte)0);
                    if (se.getReason() != 5) ** GOTO lbl55
                    if (managedChannel == 0) {
                        throw new ISOException(27265);
                    }
                    throw new ISOException(27270);
                }
lbl55:
                // 3 sources

                if (managedChannel != 0) break;
                theAPDU.setOutgoingLength((short)1);
                this.apduBuffer[0] = newChannel;
                theAPDU.sendBytes((short)0, (short)1);
                break;
            }
            default: {
                throw new ISOException(27265);
            }
        }
        this.statusWord = (short)-28672;
    }

    private void selectAPDU(APDU theAPDU) throws ISOException {
        byte resultOrNewChannel;
        byte selectedChannel = this.channelManager.getCurrentChannel();
        if (this.channelManager.getCurrentStatus() == 0 && (resultOrNewChannel = this.channelManager.manageChannel(selectedChannel, (byte)1)) == -1) {
            throw new ISOException(26753);
        }
        try {
            if (this.apduBuffer[2] == 4) {
                Applet appToSelect;
                if ((this.apduBuffer[3] & 0xFFFFFFE3) != 0) {
                    return;
                }
                byte len = (byte)theAPDU.setIncomingAndReceive();
                if (len == this.apduBuffer[4] && (appToSelect = AppletMgr.findApplet(this.apduBuffer, 5, len)) != null) {
                    short contextAndOwnerOfAppBeingSelected = NativeMethods.getObjectContextAndOwner(appToSelect);
                    byte appIDOfAppletBeingSelected = (byte)(contextAndOwnerOfAppBeingSelected & 0xFF);
                    if (AppletMgr.getAppStateForAppWithAID(PrivAccess.getPrivAccess().getAID(appIDOfAppletBeingSelected)) >= 2) {
                        if (!this.isMultiSelectionOK(appIDOfAppletBeingSelected, contextAndOwnerOfAppBeingSelected)) {
                            throw new ISOException(27013);
                        }
                        this.selectApplet(selectedChannel, appIDOfAppletBeingSelected);
                    } else {
                        this.deselectOnly(selectedChannel, false);
                        this.channelManager.setContext(selectedChannel, (short)0);
                    }
                }
                this.undoReceive();
            }
        }
        catch (SystemException se) {
            if (selectedChannel != 0) {
                this.channelManager.manageChannel(selectedChannel, (byte)0);
            }
            if (se.getReason() == 5) {
                throw new ISOException(26753);
            }
            SystemException.throwIt(se.getReason());
        }
    }

    private void undoReceive() {
        this.apduProtocol.undoIncomingAndReceive();
    }

    public boolean isMultiSelectionOK(byte appID, short contextAndOwner) {
        Applet appToSelect = AppletMgr.findAppletWithAppId(appID);
        if (appToSelect instanceof MultiSelectable) {
            return true;
        }
        return !AppletServer.getAppletServer().isContextActiveOnAnotherChannel(contextAndOwner, this.getActiveInterface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectOnly(byte channelId, byte theAppID) throws ISOException {
        boolean success;
        block21: {
            success = false;
            short appContextId = PrivAccess.getContextId(theAppID);
            byte contextStatus = 0;
            boolean isAppClassic = AppletMgr.isAppClassic(theAppID);
            this.apduProtocol.setSelectingAppletFlag();
            try {
                Applet appToSelect = AppletMgr.findAppletWithAppId(theAppID);
                contextStatus = AppletServer.getAppletServer().getContextStatus(appContextId);
                if ((byte)(contextStatus & 1) != 0 && !(appToSelect instanceof MultiSelectable)) {
                    this.appCurrentlySelected = (byte)-1;
                    throw new ISOException(27013);
                }
                if (this.channelManager.setContext(channelId, appContextId)) {
                    this.channelManager.setCurrentChannel(channelId);
                    if ((byte)(contextStatus & 1) != 0) {
                        MultiSelectable msApp = (MultiSelectable)((Object)this.getSelectedApplet(channelId));
                        if (isAppClassic) {
                            Object object = ClassicSIOProxy.CLASSIC_APPLET_CONTAINER_MUTEX;
                            synchronized (object) {
                                this.channelManager.saveChannelInfoNative(isAppClassic);
                                success = msApp.select((byte)(contextStatus & 4) != 0);
                                if (NativeMethods.getTransactionDepthNative() != 0) {
                                    TransactionException.throwIt((short)1);
                                }
                                break block21;
                            }
                        }
                        this.channelManager.saveChannelInfoNative(isAppClassic);
                        success = msApp.select((byte)(contextStatus & 4) != 0);
                        break block21;
                    }
                    if (isAppClassic) {
                        Object object = ClassicSIOProxy.CLASSIC_APPLET_CONTAINER_MUTEX;
                        synchronized (object) {
                            this.channelManager.saveChannelInfoNative(isAppClassic);
                            success = this.getSelectedApplet(channelId).select();
                            if (NativeMethods.getTransactionDepthNative() != 0) {
                                TransactionException.throwIt((short)1);
                            }
                            break block21;
                        }
                    }
                    this.channelManager.saveChannelInfoNative(isAppClassic);
                    success = this.getSelectedApplet(channelId).select();
                    break block21;
                }
                this.appCurrentlySelected = (byte)-1;
                throw new ISOException(27013);
            }
            catch (ISOException isoEx) {
                this.channelManager.setContext(channelId, (short)-1);
                if (isoEx.getReason() == 27013) {
                    throw new ISOException(isoEx.getReason());
                }
            }
            catch (SystemException se) {
                this.channelManager.setContext(channelId, (short)-1);
                this.appCurrentlySelected = (byte)-1;
                if (se.getReason() == 5) {
                    throw new ISOException(27265);
                }
            }
            catch (Throwable e) {
                success = false;
            }
        }
        this.channelManager.setCurrentChannel(APDU.getCLAChannel());
        if (NativeMethods.getTransactionDepthNative() != 0) {
            success = false;
            NativeMethods.abortTransactionNative();
        }
        if (success) {
            return;
        }
        this.appCurrentlySelected = (byte)-1;
        this.channelManager.setContext(channelId, (short)-1);
        throw new ISOException(27033);
    }

    public void selectDefaultApplet(byte channelId) throws ISOException {
        this.deselectOnly(channelId, false);
        byte defaultAppId = AppletMgr.defaultApplets[channelId];
        if (defaultAppId != -1) {
            this.selectOnly(channelId, defaultAppId);
        }
    }

    public void selectApplet(byte channelID, byte theAppID) throws ISOException {
        this.appCurrentlySelected = this.getSelectedAppID(channelID);
        newAppBeingSelected = theAppID;
        newAppBeingSelectedOnChannel = channelID;
        deselectionInProgress = true;
        this.deselectOnly(channelID, false);
        deselectionInProgress = false;
        this.selectOnly(channelID, theAppID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselectOnly(byte channelId, boolean powerdown) {
        byte contextStatus;
        block18: {
            this.channelManager.resetChannelInfoNative();
            if (this.channelManager.getContext(channelId) == -1) {
                return;
            }
            Applet theApp = this.getSelectedApplet(channelId);
            if (theApp == null) {
                return;
            }
            boolean isAppClassic = this.isSelectedAppletClassic(channelId);
            short appContextId = this.channelManager.getContext(channelId);
            contextStatus = AppletServer.getAppletServer().getContextStatus(appContextId);
            try {
                this.channelManager.setCurrentChannel(channelId);
                this.channelManager.saveChannelInfoNative(isAppClassic);
                if ((short)(contextStatus & 2) != 0) {
                    MultiSelectable msApp = (MultiSelectable)((Object)this.getSelectedApplet(channelId));
                    if (isAppClassic) {
                        Object object = ClassicSIOProxy.CLASSIC_APPLET_CONTAINER_MUTEX;
                        synchronized (object) {
                            msApp.deselect((short)(contextStatus & 8) != 0);
                            if (NativeMethods.getTransactionDepthNative() != 0) {
                                NativeMethods.abortTransactionNative();
                            }
                            break block18;
                        }
                    }
                    msApp.deselect((short)(contextStatus & 8) != 0);
                    break block18;
                }
                if (isAppClassic) {
                    Object msApp = ClassicSIOProxy.CLASSIC_APPLET_CONTAINER_MUTEX;
                    synchronized (msApp) {
                        theApp.deselect();
                        if (NativeMethods.getTransactionDepthNative() != 0) {
                            NativeMethods.abortTransactionNative();
                        }
                        break block18;
                    }
                }
                theApp.deselect();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (!powerdown) {
            this.channelManager.setCurrentChannel(APDU.getCLAChannel());
        }
        if ((short)(contextStatus & 2) == 0) {
            this.channelManager.clearTransientObjs(channelId, 2);
        }
        this.channelManager.setContext(channelId, (short)-1);
        if (NativeMethods.getTransactionDepthNative() != 0) {
            NativeMethods.abortTransactionNative();
        }
    }

    public Applet getSelectedApplet(byte channelId) {
        String appURI = this.getURIForSelectedApp(channelId);
        if (appURI == null) {
            return null;
        }
        byte[] appAIDBytes = APDUUtil.getAIDAsByteArray(appURI);
        return AppletMgr.findApplet(appAIDBytes, 0, appAIDBytes.length);
    }

    public byte getSelectedAppID(byte channelId) {
        short contextId = this.channelManager.getContext(channelId);
        if (contextId == -1) {
            return -1;
        }
        return (byte)(contextId & 0xFF);
    }

    public String getURIForSelectedApp(byte channelId) {
        byte appId = this.getSelectedAppID(channelId);
        if (appId == -1) {
            return null;
        }
        return ApplicationImpl.getAppURIForAppId(appId);
    }

    public boolean isSelectedAppletClassic(byte channelId) {
        String appURI = this.getURIForSelectedApp(channelId);
        if (appURI == null) {
            return false;
        }
        return JCSystemAccessor.getJCSystemAccessor().isAppClassic(appURI);
    }
}

