/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.jcad;

import com.sun.javacard.cm.impl.jcad.SecurityRole;
import com.sun.javacard.cm.impl.jcrd.FormatErrorException;
import com.sun.javacard.cm.impl.wad.WebElementNotSupportException;
import com.sun.javacard.jaxp.org.xml.sax.SAXException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.xml.XmlParser;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class JCPlatformAppDesc {
    Vector<String> descriptions;
    Vector<String> displayNames;
    Vector<String> cardHolderAuthorization;
    Vector<String> dynamicallyLoadedClasses;
    Vector<String> shareableInterfaceClasses;
    Vector<SecurityRole> securityRoles;

    public JCPlatformAppDesc(InputStream is) throws IOException, SAXException, FormatErrorException, WebElementNotSupportException {
        XmlParser xp = new XmlParser();
        XmlParser.Node node = xp.parse(is);
        this.verifyJcadVersion(node);
        Iterator<Object> iter = node.iterator();
        XmlParser.Node node1 = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node1 = (XmlParser.Node)o;
            String element = node1.getTag();
            if ("description".equals(element)) {
                if (this.descriptions == null) {
                    this.descriptions = new Vector();
                }
                this.populateStrings(node1, this.descriptions);
                continue;
            }
            if ("display-name".equals(element)) {
                if (this.displayNames == null) {
                    this.displayNames = new Vector();
                }
                this.populateStrings(node1, this.displayNames);
                continue;
            }
            if ("card-holder-authorization".equals(element)) {
                if (this.cardHolderAuthorization == null) {
                    this.cardHolderAuthorization = new Vector();
                }
                this.populateCardHolderAuthorization(node1);
                continue;
            }
            if ("dynamically-loaded-classes".equals(element)) {
                if (this.dynamicallyLoadedClasses == null) {
                    this.dynamicallyLoadedClasses = new Vector();
                }
                this.populateClasses(node1, this.dynamicallyLoadedClasses);
                continue;
            }
            if ("shareable-interface-classes".equals(element)) {
                if (this.shareableInterfaceClasses == null) {
                    this.shareableInterfaceClasses = new Vector();
                }
                this.populateClasses(node1, this.shareableInterfaceClasses);
                continue;
            }
            if ("security-role".equals(element)) {
                if (this.securityRoles == null) {
                    this.securityRoles = new Vector();
                }
                this.populateSecurityRoles(node1);
                continue;
            }
            throw new WebElementNotSupportException("javacard.xml: element <" + element + ">");
        }
        this.verifyCardHolderRolesVersusSecurityRoles();
    }

    private void verifyJcadVersion(XmlParser.Node node) throws WebElementNotSupportException, FormatErrorException {
        String element = node.getTag();
        String version = node.getAttribute("version");
        if (!element.equalsIgnoreCase("javacard-app")) {
            throw new WebElementNotSupportException("javacard.xml: element <" + element + ">");
        }
        if (version == null || !version.equals("3.0")) {
            throw new FormatErrorException("4205", version);
        }
    }

    private void populateStrings(XmlParser.Node node, Vector<String> list) {
        String desc = node.toString(false, true);
        list.addElement(desc);
    }

    private void populateCardHolderAuthorization(XmlParser.Node node) throws FormatErrorException {
        String role_name = null;
        Iterator<XmlParser.Node> itr = node.iterator("role-name");
        if (!itr.hasNext()) {
            throw new FormatErrorException("4112", "<role-name>\n<card-holder-authorization>");
        }
        while (itr.hasNext()) {
            role_name = itr.next().toString(false, true);
            if (role_name != null && role_name.equals("")) {
                throw new FormatErrorException("4117", "<role-name>\n<card-holder-authorization>");
            }
            this.cardHolderAuthorization.addElement(role_name);
        }
    }

    private void populateClasses(XmlParser.Node node, Vector<String> list) throws FormatErrorException {
        Iterator<XmlParser.Node> itr = node.iterator("class");
        if (!itr.hasNext()) {
            throw new FormatErrorException("4112", "<class>\n<" + node.getTag() + ">");
        }
        while (itr.hasNext()) {
            String class_name = itr.next().getAttribute("name");
            if (class_name == null) {
                throw new FormatErrorException("4118", "<class name= >\n<" + node.getTag() + ">");
            }
            if (class_name.equalsIgnoreCase("")) {
                throw new FormatErrorException("4117", "<class name= >\n<" + node.getTag() + ">");
            }
            list.addElement(class_name);
        }
    }

    private void populateSecurityRoles(XmlParser.Node node) throws FormatErrorException {
        XmlParser.Node subNode;
        Vector<String> descs = null;
        Hashtable<String, String> rol2cat = null;
        Iterator<XmlParser.Node> itr = node.iterator("description");
        while (itr.hasNext()) {
            if (descs == null) {
                descs = new Vector<String>();
            }
            subNode = itr.next();
            String desc = subNode.toString(false, true);
            descs.addElement(desc);
        }
        itr = node.iterator("role-name");
        if (!itr.hasNext()) {
            throw new FormatErrorException("4112", "<role-name>\n<security-role>");
        }
        while (itr.hasNext()) {
            if (rol2cat == null) {
                rol2cat = new Hashtable<String, String>();
            }
            if ((subNode = itr.next()).size() == 0) {
                throw new FormatErrorException("4117", "<role-name category= >\n<security-role>");
            }
            String role = (String)subNode.get(0);
            String category = subNode.getAttribute("category");
            if (category == null) {
                throw new FormatErrorException("4118", "<role-name category= >\n<security-role>");
            }
            if (!category.equals("USER") && !category.equals("ON-CARD-CLIENT")) {
                throw new FormatErrorException("4102", category + "\n" + role);
            }
            rol2cat.put(role, category);
            SecurityRole sr = new SecurityRole(descs, rol2cat);
            this.securityRoles.addElement(sr);
        }
    }

    private void verifyCardHolderRolesVersusSecurityRoles() throws FormatErrorException {
        if (this.cardHolderAuthorization == null) {
            return;
        }
        for (String roleName : this.cardHolderAuthorization) {
            String category2 = this.getSecurityRoleCategory(roleName);
            if (category2 != null) continue;
            throw new FormatErrorException("4101", roleName);
        }
    }

    public Vector<String> getDescriptions() {
        return this.descriptions;
    }

    public Vector<String> getDisplayNames() {
        return this.displayNames;
    }

    public Vector<String> getCardHolderAuthorization() {
        return this.cardHolderAuthorization;
    }

    public Vector<String> getDynamicallyLoadedClasses() {
        return this.dynamicallyLoadedClasses;
    }

    public Vector<String> getShareableInterfaceClasses() {
        return this.shareableInterfaceClasses;
    }

    public Vector<SecurityRole> getSecurityRoles() {
        return this.securityRoles;
    }

    public Vector<String> getSecurityRoleNames() {
        Vector<String> all = null;
        if (this.securityRoles != null) {
            for (SecurityRole sr : this.securityRoles) {
                Vector<String> names = sr.getRoleNames();
                if (all == null) {
                    all = new Vector<String>();
                }
                for (String N : names) {
                    all.addElement(N);
                }
            }
        }
        return all;
    }

    public String getSecurityRoleCategory(String roleName) {
        if (this.securityRoles != null) {
            for (SecurityRole sr : this.securityRoles) {
                Hashtable<String, String> role2cat = sr.getRoleMapping();
                Enumeration<String> en = role2cat.keys();
                while (en.hasMoreElements()) {
                    String role = en.nextElement();
                    if (!role.equals(roleName)) continue;
                    return role2cat.get(role);
                }
            }
        }
        return null;
    }
}

