/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class StreamEndPoint
implements EndPoint {
    InputStream inputStream;
    OutputStream outputStream;

    public StreamEndPoint(InputStream in, OutputStream out) {
        this.inputStream = in;
        this.outputStream = out;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void blockReadable(long millisecs) {
    }

    @Override
    public void blockWritable(long millisecs) {
    }

    @Override
    public boolean isOpen() {
        return this.inputStream != null;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.inputStream = null;
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        this.outputStream = null;
    }

    @Override
    public int fill(Buffer buffer) throws IOException {
        if (this.inputStream == null) {
            return 0;
        }
        int space = buffer.space();
        if (space <= 0) {
            if (buffer.hasContent()) {
                return 0;
            }
            throw new IOException("FULL");
        }
        int len = buffer.readFrom(this.inputStream, space);
        return len;
    }

    @Override
    public int flush(Buffer buffer) throws IOException {
        Logger.debug("org.mortbay.io.bio.StreamEndPoint.flush() -> " + this.outputStream);
        if (this.outputStream == null) {
            return -1;
        }
        int length = buffer.length();
        if (length > 0) {
            buffer.writeTo(this.outputStream);
        }
        if (!buffer.isImmutable()) {
            buffer.clear();
        }
        this.outputStream.flush();
        return length;
    }

    @Override
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int f;
        int tw;
        int len = 0;
        if (header != null && (tw = header.length()) > 0) {
            len = f = this.flush(header);
            if (f < tw) {
                return len;
            }
        }
        if (buffer != null && (tw = buffer.length()) > 0) {
            f = this.flush(buffer);
            if (f < 0) {
                return len > 0 ? len : f;
            }
            len += f;
            if (f < tw) {
                return len;
            }
        }
        if (trailer != null && (tw = trailer.length()) > 0) {
            f = this.flush(trailer);
            if (f < 0) {
                return len > 0 ? len : f;
            }
            len += f;
        }
        return len;
    }

    @Override
    public String getLocalAddr() {
        return null;
    }

    @Override
    public String getLocalHost() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    @Override
    public String getRemoteHost() {
        return null;
    }

    @Override
    public int getRemotePort() {
        return 0;
    }

    @Override
    public Object getConnection() {
        return null;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }
}

