/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.Logger;
import com.sun.javacard.util.URLEncoder;
import com.sun.midp.io.DateParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.http.Cookie;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.View;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpOnlyCookie;
import org.mortbay.util.DateCache;
import org.mortbay.util.EmptyLists;
import org.mortbay.util.LazyList;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HttpFields {
    public static final String SEPARATORS = ", \t";
    private static String[] DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
    private static TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final DateCache DATE_CACHE = new DateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    public static final String JAN_01_1970 = HttpFields.formatDate(0L, false);
    public static final Buffer JAN_01_1970_BUFFER = new ByteArrayBuffer(JAN_01_1970);
    protected Vector<Field> fields = new Vector(20);
    protected int revision;
    protected Hashtable<Buffer, Field> bufferMap = new Hashtable(32);
    private StringBuffer dateBuffer;
    private Calendar calendar;
    private static String __one = "1.0";
    private static String __zero = "0.0";
    private static Hashtable<String, Object> __qualities = new Hashtable();

    public static String formatDate(long date, boolean cookie) {
        StringBuffer buf = new StringBuffer(32);
        Calendar gc = Calendar.getInstance(GMT);
        gc.setTime(new Date(date));
        HttpFields.formatDate(buf, gc, cookie);
        return buf.toString();
    }

    public static String formatDate(Calendar calendar, boolean cookie) {
        StringBuffer buf = new StringBuffer(32);
        HttpFields.formatDate(buf, calendar, cookie);
        return buf.toString();
    }

    public static String formatDate(StringBuffer buf, long date, boolean cookie) {
        Calendar gc = Calendar.getInstance(GMT);
        gc.setTime(new Date(date));
        HttpFields.formatDate(buf, gc, cookie);
        return buf.toString();
    }

    public static void formatDate(StringBuffer buf, Calendar calendar, boolean cookie) {
        int day_of_week = calendar.get(7);
        int day_of_month = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int century = year / 100;
        year %= 100;
        int epoch = (int)(calendar.getTime().getTime() / 1000L % 86400L);
        int seconds = epoch % 60;
        int minutes = (epoch /= 60) % 60;
        int hours = epoch / 60;
        buf.append(DAYS[day_of_week]);
        buf.append(',');
        buf.append(' ');
        StringUtil.append2digits(buf, day_of_month);
        if (cookie) {
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            StringUtil.append2digits(buf, year);
        } else {
            buf.append(' ');
            buf.append(MONTHS[month]);
            buf.append(' ');
            StringUtil.append2digits(buf, century);
            StringUtil.append2digits(buf, year);
        }
        buf.append(' ');
        StringUtil.append2digits(buf, hours);
        buf.append(':');
        StringUtil.append2digits(buf, minutes);
        buf.append(':');
        StringUtil.append2digits(buf, seconds);
        buf.append(" GMT");
    }

    public Enumeration<String> getFieldNames() {
        return new Enumeration<String>(){
            int i = 0;
            Field field = null;

            @Override
            public boolean hasMoreElements() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this.fields.size()) {
                    Field f;
                    if ((f = HttpFields.this.fields.elementAt(this.i++)) == null || f.prev != null || f.revision != HttpFields.this.revision) continue;
                    this.field = f;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (this.field != null || this.hasMoreElements()) {
                    String n = this.field.name.toString();
                    this.field = null;
                    return n;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator<Field> getFields() {
        return new Iterator<Field>(){
            int i = 0;
            Field field = null;

            @Override
            public boolean hasNext() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this.fields.size()) {
                    Field f;
                    if ((f = HttpFields.this.fields.elementAt(this.i++)) == null || f.revision != HttpFields.this.revision) continue;
                    this.field = f;
                    return true;
                }
                return false;
            }

            @Override
            public Field next() {
                if (this.field != null || this.hasNext()) {
                    Field f = this.field;
                    this.field = null;
                    return f;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Field getField(String name) {
        return this.bufferMap.get(HttpHeaders.CACHE.lookup(name));
    }

    private Field getField(Buffer name) {
        return this.bufferMap.get(name);
    }

    public boolean containsKey(Buffer name) {
        Field f = this.getField(name);
        return f != null && f.revision == this.revision;
    }

    public boolean containsKey(String name) {
        Field f = this.getField(name);
        return f != null && f.revision == this.revision;
    }

    public String getStringField(String name) {
        Field field = this.getField(name);
        if (field != null && field.revision == this.revision) {
            return field.getValue();
        }
        return null;
    }

    public String getStringField(Buffer name) {
        Field field = this.getField(name);
        if (field != null && field.revision == this.revision) {
            return field.value.toString();
        }
        return null;
    }

    public Buffer get(Buffer name) {
        Field field = this.getField(name);
        if (field != null && field.revision == this.revision) {
            return field.value;
        }
        return null;
    }

    public Enumeration<String> getValues(String name) {
        final Field field = this.getField(name);
        if (field == null) {
            return null;
        }
        return new Enumeration<String>(){
            Field f;
            {
                this.f = field;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.f != null && this.f.revision != HttpFields.this.revision) {
                    this.f = this.f.next;
                }
                return this.f != null;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field n = this.f;
                do {
                    this.f = this.f.next;
                } while (this.f != null && this.f.revision != HttpFields.this.revision);
                return n.getValue();
            }
        };
    }

    public Enumeration<String> getValues(Buffer name) {
        final Field field = this.getField(name);
        if (field == null) {
            return null;
        }
        return new Enumeration<String>(){
            Field f;
            {
                this.f = field;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.f != null && this.f.revision != HttpFields.this.revision) {
                    this.f = this.f.next;
                }
                return this.f != null;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field n = this.f;
                this.f = this.f.next;
                while (this.f != null && this.f.revision != HttpFields.this.revision) {
                    this.f = this.f.next;
                }
                return n.getValue();
            }
        };
    }

    public Enumeration<String> getValues(String name, final String separators) {
        final Enumeration<String> e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration<String>(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (e.hasMoreElements()) {
                    String value = (String)e.nextElement();
                    this.tok = new QuotedStringTokenizer(value, separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next = (String)this.tok.nextElement();
                if (next != null) {
                    next = next.trim();
                }
                return next;
            }
        };
    }

    public void put(String name, String value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = null;
        if (value != null) {
            v = HttpHeaderValues.CACHE.lookup(value);
        }
        this.put(n, v, -1L);
    }

    public void put(Buffer name, String value) {
        Buffer v = HttpHeaderValues.CACHE.lookup(value);
        this.put(name, v, -1L);
    }

    public void put(Buffer name, Buffer value) {
        this.put(name, value, -1L);
    }

    private void put(Buffer name, Buffer value, long numValue) {
        Field field;
        if (value == null) {
            this.remove(name);
            return;
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        if ((field = this.bufferMap.get(name)) != null) {
            field.reset(value, numValue, this.revision);
            field = field.next;
            while (field != null) {
                field.clear();
                field = field.next;
            }
            return;
        }
        field = new Field(name, value, numValue, this.revision);
        this.fields.addElement(field);
        this.bufferMap.put(field.getNameBuffer(), field);
    }

    public void add(String name, String value) throws IllegalArgumentException {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = HttpHeaderValues.CACHE.lookup(value);
        this.add(n, v, -1L);
    }

    public void add(Buffer name, Buffer value) throws IllegalArgumentException {
        this.add(name, value, -1L);
    }

    private void add(Buffer name, Buffer value, long numValue) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        Field field = this.bufferMap.get(name);
        Field last = null;
        if (field != null) {
            while (field != null && field.revision == this.revision) {
                last = field;
                field = field.next;
            }
        }
        if (field != null) {
            field.reset(value, numValue, this.revision);
        } else {
            field = new Field(name, value, numValue, this.revision);
            if (last != null) {
                field.prev = last;
                last.next = field;
            } else {
                this.bufferMap.put(field.getNameBuffer(), field);
            }
            this.fields.addElement(field);
        }
    }

    public void remove(String name) {
        this.remove(HttpHeaders.CACHE.lookup(name));
    }

    public void remove(Buffer name) {
        Field field = this.bufferMap.get(name);
        if (field != null) {
            while (field != null) {
                field.clear();
                field = field.next;
            }
        }
    }

    public long getLongField(String name) throws NumberFormatException {
        Field field = this.getField(name);
        if (field != null && field.revision == this.revision) {
            return field.getLongValue();
        }
        return -1L;
    }

    public long getLongField(Buffer name) throws NumberFormatException {
        Field field = this.getField(name);
        if (field != null && field.revision == this.revision) {
            return field.getLongValue();
        }
        return -1L;
    }

    public long getDateField(String name) {
        Field field = this.getField(name);
        if (field == null || field.revision != this.revision) {
            return -1L;
        }
        if (field.numValue != -1L) {
            return field.numValue;
        }
        String val = HttpFields.valueParameters(field.value.toString(), null);
        if (val == null) {
            return -1L;
        }
        try {
            field.numValue = DateParser.parse(val);
            return field.numValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (val.endsWith(" GMT")) {
                val = val.substring(0, val.length() - 4);
                try {
                    field.numValue = DateParser.parse(val);
                    return field.numValue;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
    }

    public void putLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer(value);
        this.put(n, v, value);
    }

    public void addLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer(value);
        this.add(n, v, value);
    }

    public void addLongField(Buffer name, long value) {
        Logger.debug("HttpFields.addLongField(", name, value, ")");
        Buffer v = BufferUtil.toBuffer(value);
        this.add(name, v, value);
    }

    public void putDateField(String name, long date) {
        if (this.dateBuffer == null) {
            this.dateBuffer = new StringBuffer(32);
            this.calendar = Calendar.getInstance(GMT);
        }
        this.dateBuffer.setLength(0);
        this.calendar.setTime(new Date(date));
        HttpFields.formatDate(this.dateBuffer, this.calendar, false);
        Buffer n = HttpHeaders.CACHE.lookup(name);
        ByteArrayBuffer v = new ByteArrayBuffer(this.dateBuffer.toString());
        this.put(n, v, date);
    }

    public void addDateField(String name, long date) {
        if (this.dateBuffer == null) {
            this.dateBuffer = new StringBuffer(32);
            this.calendar = Calendar.getInstance(GMT);
        }
        this.dateBuffer.setLength(0);
        this.calendar.setTime(new Date(date));
        HttpFields.formatDate(this.dateBuffer, this.calendar, false);
        Buffer n = HttpHeaders.CACHE.lookup(name);
        ByteArrayBuffer v = new ByteArrayBuffer(this.dateBuffer.toString());
        this.add(n, v, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSetCookie(Cookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        int version = cookie.getVersion();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuffer buf = new StringBuffer(128);
        String name_value_params = null;
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            long maxAge;
            String domain;
            String path;
            buf.append(name);
            buf.append('=');
            if (value != null && value.length() > 0) {
                if (version == 0) {
                    try {
                        buf.append(URLEncoder.encodeString(value, StringUtil.ISO_8859_1));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    QuotedStringTokenizer.quote(buf, value);
                }
            }
            if (version > 0) {
                buf.append(";version=");
                buf.append(version);
                String comment = cookie.getComment();
                if (comment != null && comment.length() > 0) {
                    buf.append(";Comment=");
                    QuotedStringTokenizer.quote(buf, comment);
                }
            }
            if ((path = cookie.getPath()) != null && path.length() > 0) {
                buf.append(";path=");
                buf.append(path);
            }
            if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
                buf.append(";domain=");
                buf.append(domain.toLowerCase());
            }
            if ((maxAge = (long)cookie.getMaxAge()) >= 0L) {
                if (version == 0) {
                    buf.append(";expires=");
                    if (maxAge == 0L) {
                        buf.append(JAN_01_1970);
                    } else {
                        HttpFields.formatDate(buf, System.currentTimeMillis() + 1000L * maxAge, true);
                    }
                } else {
                    buf.append(";max-age=");
                    buf.append(maxAge);
                }
            } else if (version > 0) {
                buf.append(";discard");
            }
            if (cookie.getSecure()) {
                buf.append(";Secure");
            }
            if (cookie instanceof HttpOnlyCookie) {
                buf.append(";HttpOnly");
            }
            name_value_params = buf.toString();
        }
        this.put(HttpHeaders.EXPIRES_BUFFER, JAN_01_1970_BUFFER);
        this.add(HttpHeaders.SET_COOKIE_BUFFER, new ByteArrayBuffer(name_value_params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer) throws IOException {
        Writer writer2 = writer;
        synchronized (writer2) {
            for (int i = 0; i < this.fields.size(); ++i) {
                Field field = this.fields.elementAt(i);
                if (field == null || field.revision != this.revision) continue;
                field.write(writer);
            }
            writer.write("\r\n");
        }
    }

    public void put(Buffer buffer) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (field == null || field.revision != this.revision) continue;
            field.put(buffer);
        }
        BufferUtil.putCRLF(buffer);
    }

    public String toString() {
        try {
            ByteArrayBuffer buffer = new ByteArrayBuffer(1024);
            this.put(buffer);
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void clear() {
        ++this.revision;
        if (this.revision > 1000000) {
            this.revision = 0;
            int i = this.fields.size();
            while (i-- > 0) {
                Field field = this.fields.elementAt(i);
                if (field == null) continue;
                field.clear();
            }
        }
    }

    public void destroy() {
        if (this.fields != null) {
            int i = this.fields.size();
            while (i-- > 0) {
                Field field = this.fields.elementAt(i);
                if (field == null) continue;
                field.destroy();
            }
        }
        this.fields = null;
        this.dateBuffer = null;
        this.calendar = null;
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration<String> e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Enumeration<String> values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, values.nextElement());
            }
        }
    }

    public static String valueParameters(String value, Hashtable<String, String> parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (tok1.hasMoreTokens()) {
            String token = tok1.nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!tok2.hasMoreTokens()) continue;
            String paramName = tok2.nextToken();
            String paramVal = null;
            if (tok2.hasMoreTokens()) {
                paramVal = tok2.nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    public static String getQuality(String value) {
        Object entry;
        if (value == null) {
            return __zero;
        }
        int qe = value.indexOf(";");
        if (qe++ < 0 || qe == value.length()) {
            return __one;
        }
        if (value.charAt(qe++) == 'q' && (entry = __qualities.get(new String(value.getBytes(), ++qe, value.length() - qe))) != null) {
            return entry.toString();
        }
        Hashtable<String, String> params = new Hashtable<String, String>(3);
        HttpFields.valueParameters(value, params);
        String qs = params.get("q");
        String q = (String)__qualities.get(qs);
        if (q == null) {
            try {
                q = qs;
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    public static Vector<String> qualityList(Enumeration<String> e) {
        if (e == null || !e.hasMoreElements()) {
            return EmptyLists.EMPTY_VECTOR;
        }
        LazyList<String> list = null;
        LazyList<String> qual = null;
        while (e.hasMoreElements()) {
            String v = e.nextElement();
            String q = HttpFields.getQuality(v);
            if (HttpFields.compareFloatStrings(q, "0.001") < 0) continue;
            list = LazyList.add(list, v);
            qual = LazyList.add(qual, q);
        }
        Vector<String> vl = LazyList.getList(list, false);
        if (vl.size() < 2) {
            return vl;
        }
        Vector ql = LazyList.getList(qual, false);
        String last = __zero;
        int i = vl.size();
        while (i-- > 0) {
            String q = (String)ql.elementAt(i);
            if (HttpFields.compareFloatStrings(last, q) > 0) {
                String tmp = vl.elementAt(i);
                vl.setElementAt(vl.elementAt(i + 1), i);
                vl.setElementAt(tmp, i + 1);
                ql.setElementAt(ql.elementAt(i + 1), i);
                ql.setElementAt(q, i + 1);
                last = __zero;
                i = vl.size();
                continue;
            }
            last = q;
        }
        ql.removeAllElements();
        return vl;
    }

    private static int compareFloatStrings(String str1, String str2) {
        int i;
        int num1 = 0;
        String decimal1 = null;
        int num2 = 0;
        String decimal2 = null;
        int dotIndex1 = str1.indexOf(46);
        int dotIndex2 = str2.indexOf(46);
        int padlength = 0;
        if (dotIndex1 == -1) {
            num1 = Integer.parseInt(str1);
        } else {
            num1 = Integer.parseInt(str1.substring(0, dotIndex1));
            decimal1 = str1.substring(dotIndex1 + 1);
            padlength = 10 - decimal1.length();
            for (i = 0; i < padlength; ++i) {
                decimal1 = decimal1 + '0';
            }
        }
        if (dotIndex2 == -1) {
            num2 = Integer.parseInt(str2);
        } else {
            num2 = Integer.parseInt(str2.substring(0, dotIndex2));
            decimal2 = str2.substring(dotIndex2 + 1);
            padlength = 10 - decimal2.length();
            for (i = 0; i < padlength; ++i) {
                decimal2 = decimal2 + '0';
            }
        }
        int result = 0;
        result = num1 > num2 ? 1 : (num1 < num2 ? -1 : decimal1.compareTo(decimal2));
        return result;
    }

    static {
        Logger.debug("org.mortbay.jetty.HttpFields.STATIC() -> ");
        __qualities.put("1.0", __one);
        __qualities.put("1", __one);
        __qualities.put("0.9", "0.9");
        __qualities.put("0.8", "0.8");
        __qualities.put("0.7", "0.7");
        __qualities.put("0.66", "0.66");
        __qualities.put("0.6", "0.6");
        __qualities.put("0.5", "0.5");
        __qualities.put("0.4", "0.4");
        __qualities.put("0.33", "0.33");
        __qualities.put("0.3", "0.3");
        __qualities.put("0.2", "0.2");
        __qualities.put("0.1", "0.1");
        __qualities.put("0", __zero);
        __qualities.put("0.0", __zero);
        Logger.debug(__qualities.toString());
    }

    public static final class Field {
        Buffer name;
        Buffer value;
        private String stringValue;
        long numValue;
        Field next;
        Field prev;
        int revision;

        Field(Buffer name, Buffer value, long numValue, int revision) {
            this.name = name.asImmutableBuffer();
            this.value = value.isImmutable() ? value : new View(value);
            this.next = null;
            this.prev = null;
            this.revision = revision;
            this.numValue = numValue;
            this.stringValue = null;
        }

        void clear() {
            this.revision = -1;
        }

        void destroy() {
            this.name = null;
            this.value = null;
            this.next = null;
            this.prev = null;
            this.stringValue = null;
        }

        void reset(Buffer value, long numValue, int revision) {
            this.revision = revision;
            if (this.value == null) {
                this.value = value.isImmutable() ? value : new View(value);
                this.numValue = numValue;
                this.stringValue = null;
            } else if (value.isImmutable()) {
                this.value = value;
                this.numValue = numValue;
                this.stringValue = null;
            } else {
                if (this.value instanceof View) {
                    ((View)this.value).update(value);
                } else {
                    this.value = new View(value);
                }
                this.numValue = numValue;
                if (this.stringValue != null) {
                    if (this.stringValue.length() != value.length()) {
                        this.stringValue = null;
                    } else {
                        int i = value.length();
                        while (i-- > 0) {
                            if (value.peek(value.getReadIndex() + i) == this.stringValue.charAt(i)) continue;
                            this.stringValue = null;
                            break;
                        }
                    }
                }
            }
        }

        public void write(Writer writer) throws IOException {
            writer.write(this.name.toString());
            writer.write(":");
            writer.write(this.value.toString());
            writer.write("\r\n");
        }

        public void put(Buffer buffer) {
            buffer.put(this.name);
            buffer.put((byte)58);
            buffer.put((byte)32);
            buffer.put(this.value);
            BufferUtil.putCRLF(buffer);
        }

        public String getName() {
            return this.name.toString();
        }

        Buffer getNameBuffer() {
            return this.name;
        }

        public int getNameOrdinal() {
            return HttpHeaders.CACHE.getOrdinal(this.name);
        }

        public String getValue() {
            if (this.stringValue == null) {
                this.stringValue = this.value.toString();
            }
            return this.stringValue;
        }

        Buffer getValueBuffer() {
            return this.value;
        }

        public int getValueOrdinal() {
            return HttpHeaderValues.CACHE.getOrdinal(this.value);
        }

        public int getIntValue() {
            return (int)this.getLongValue();
        }

        public long getLongValue() {
            if (this.numValue == -1L) {
                this.numValue = BufferUtil.toLong(this.value);
            }
            return this.numValue;
        }

        public String toString() {
            return "[" + (this.prev == null ? "" : "<-") + this.getName() + "=" + this.revision + "=" + this.value + (this.next == null ? "" : "->") + "]";
        }
    }
}

