/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import com.sun.javacard.Logger;
import com.sun.javacard.security.Principal;
import com.sun.spot.security.MessageDigest;
import java.io.IOException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class DigestAuthenticator
implements Authenticator {
    protected long maxNonceAge = 0L;
    protected long nonceSecret = (long)this.hashCode() ^ System.currentTimeMillis();
    protected boolean useStale = false;

    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        boolean stale = false;
        Principal user = null;
        String credentials = request.getHeader("Authorization");
        request.clearHeader("Authorization");
        if (credentials != null) {
            Logger.debug("Credentials: " + credentials);
            QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
            Digest digest = new Digest(request.getMethod());
            String last = null;
            String name = null;
            block5: while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                switch (c) {
                    case '=': {
                        name = last;
                        last = tok;
                        continue block5;
                    }
                    case ',': {
                        name = null;
                    }
                    case ' ': {
                        continue block5;
                    }
                }
                last = tok;
                if (name == null) continue;
                if ("username".equalsIgnoreCase(name)) {
                    digest.username = tok;
                    continue;
                }
                if ("realm".equalsIgnoreCase(name)) {
                    digest.realm = tok;
                    continue;
                }
                if ("nonce".equalsIgnoreCase(name)) {
                    digest.nonce = tok;
                    continue;
                }
                if ("nc".equalsIgnoreCase(name)) {
                    digest.nc = tok;
                    continue;
                }
                if ("cnonce".equalsIgnoreCase(name)) {
                    digest.cnonce = tok;
                    continue;
                }
                if ("qop".equalsIgnoreCase(name)) {
                    digest.qop = tok;
                    continue;
                }
                if ("uri".equalsIgnoreCase(name)) {
                    digest.uri = tok;
                    continue;
                }
                if (!"response".equalsIgnoreCase(name)) continue;
                digest.response = tok;
            }
            int n = this.checkNonce(digest.nonce, request);
            if (n > 0) {
                user = realm.authenticate(digest.username, digest, request, "DIGEST");
            } else if (n == 0) {
                stale = true;
            }
            if (user == null) {
                Logger.debug("AUTH FAILURE: user " + digest.username);
            } else {
                if (user.getName().equals("forbidden")) {
                    response.sendError(403);
                    return null;
                }
                request.setAuthType("DIGEST");
                request.setUserPrincipal(user);
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, request, response, stale);
        }
        return user;
    }

    @Override
    public String getAuthMethod() {
        return "DIGEST";
    }

    public void sendChallenge(UserRealm realm, Request request, Response response, boolean stale) throws IOException {
        String contextPath = request.getContextPath();
        response.setHeader("WWW-Authenticate", "Digest realm=\"" + realm.getName() + "\", domain=\"" + contextPath + "\", nonce=\"" + this.newNonce(request) + "\", algorithm=MD5, qop=\"auth\"" + (this.useStale ? " stale=" + stale : ""));
        response.sendError(401);
    }

    public String newNonce(Request request) {
        long ts = request.getTimeStamp();
        long sk = this.nonceSecret;
        byte[] nounce = new byte[24];
        for (int i = 0; i < 8; ++i) {
            nounce[i] = (byte)(ts & 0xFFL);
            ts >>= 8;
            nounce[8 + i] = (byte)(sk & 0xFFL);
            sk >>= 8;
        }
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance((String)"MD5");
            md.reset();
            hash = new byte[16];
            md.update(nounce, 0, 16);
            md.digest(hash, 0, 16);
        }
        catch (Exception e) {
            Logger.debug(e);
            e.printStackTrace();
        }
        Logger.debug("hash is" + hash);
        for (int i = 0; i < hash.length; ++i) {
            nounce[8 + i] = hash[i];
            if (i == 23) break;
        }
        Logger.debug("got new nounce");
        return new String(B64Code.encode(nounce));
    }

    public int checkNonce(String nonce, Request request) {
        try {
            byte[] n = B64Code.decode(nonce.toCharArray());
            if (n.length != 24) {
                return -1;
            }
            long ts = 0L;
            long sk = this.nonceSecret;
            byte[] n2 = new byte[16];
            System.arraycopy(n, 0, n2, 0, 8);
            for (int i = 0; i < 8; ++i) {
                n2[8 + i] = (byte)(sk & 0xFFL);
                sk >>= 8;
                ts = (ts << 8) + (0xFFL & (long)n[7 - i]);
            }
            long age = request.getTimeStamp() - ts;
            Logger.debug("age=" + age);
            byte[] hash = new byte[16];
            try {
                MessageDigest md = MessageDigest.getInstance((String)"MD5");
                md.reset();
                md.update(n2, 0, 16);
                md.digest(hash, 0, 16);
            }
            catch (Exception e) {
                Logger.debug(e);
            }
            for (int i = 0; i < 16; ++i) {
                if (n[i + 8] == hash[i]) continue;
                return -1;
            }
            if (this.maxNonceAge > 0L && (age < 0L || age > this.maxNonceAge)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            Logger.debug(e);
            return -1;
        }
    }

    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public long getNonceSecret() {
        return this.nonceSecret;
    }

    public void setNonceSecret(long nonceSecret) {
        this.nonceSecret = nonceSecret;
    }

    public void setUseStale(boolean us) {
        this.useStale = us;
    }

    public boolean getUseStale() {
        return this.useStale;
    }

    public class NotChecked
    implements Principal {
        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "NOT CHECKED";
        }
    }

    public static class Digest
    extends Credential {
        public String method = null;
        public String username = null;
        public String realm = null;
        public String nonce = null;
        public String nc = null;
        public String cnonce = null;
        public String qop = null;
        public String uri = null;
        public String response = null;

        public Digest(String username, String realm, String method, String uri, String nonce, String nc, String cnonce, String qop, String response) {
            this.username = username;
            this.realm = realm;
            this.method = method;
            this.uri = uri;
            this.nonce = nonce;
            this.nc = nc;
            this.cnonce = cnonce;
            this.qop = qop;
            this.response = response;
        }

        Digest(String m) {
            this.method = m;
        }

        @Override
        public boolean check(Object credentials) {
            Logger.debug("digest info=" + this.username + "," + this.realm + "," + this.nonce + "," + this.nc + "," + this.cnonce + "," + this.qop + "," + this.uri);
            Logger.debug("In DA.digest");
            String password = credentials instanceof String ? (String)credentials : credentials.toString();
            Logger.debug("pw:" + password);
            try {
                MessageDigest md = MessageDigest.getInstance((String)"MD5");
                byte[] ha1 = new byte[16];
                byte[] colon = ":".getBytes(StringUtil.ISO_8859_1);
                byte[] userNameBytes = this.username.getBytes(StringUtil.ISO_8859_1);
                byte[] realmBytes = this.realm.getBytes(StringUtil.ISO_8859_1);
                byte[] passwordBytes = password.getBytes(StringUtil.ISO_8859_1);
                byte[] methodBytes = this.method.getBytes(StringUtil.ISO_8859_1);
                byte[] uriBytes = this.uri.getBytes(StringUtil.ISO_8859_1);
                byte[] nonceBytes = this.nonce.getBytes(StringUtil.ISO_8859_1);
                byte[] ncBytes = this.nc.getBytes(StringUtil.ISO_8859_1);
                Logger.debug("nc=" + this.nc);
                byte[] cnonceBytes = this.cnonce.getBytes(StringUtil.ISO_8859_1);
                byte[] qopBytes = this.qop.getBytes(StringUtil.ISO_8859_1);
                if (credentials instanceof Credential.MD5) {
                    ha1 = ((Credential.MD5)credentials).getDigest();
                } else {
                    md.update(userNameBytes, 0, userNameBytes.length);
                    md.update(colon, 0, colon.length);
                    md.update(realmBytes, 0, realmBytes.length);
                    md.update(colon, 0, colon.length);
                    md.update(passwordBytes, 0, passwordBytes.length);
                    md.digest(ha1, 0, ha1.length);
                }
                byte[] ha2 = new byte[16];
                md.reset();
                md.update(methodBytes, 0, methodBytes.length);
                md.update(colon, 0, colon.length);
                md.update(uriBytes, 0, uriBytes.length);
                md.digest(ha2, 0, ha2.length);
                byte[] digest = new byte[16];
                byte[] ha1Bytes = TypeUtil.toString(ha1, 16).getBytes(StringUtil.ISO_8859_1);
                byte[] ha2Bytes = TypeUtil.toString(ha2, 16).getBytes(StringUtil.ISO_8859_1);
                md.update(ha1Bytes, 0, ha1Bytes.length);
                md.update(colon, 0, colon.length);
                md.update(nonceBytes, 0, nonceBytes.length);
                md.update(colon, 0, colon.length);
                md.update(ncBytes, 0, ncBytes.length);
                md.update(colon, 0, colon.length);
                md.update(cnonceBytes, 0, cnonceBytes.length);
                md.update(colon, 0, colon.length);
                md.update(qopBytes, 0, qopBytes.length);
                md.update(colon, 0, colon.length);
                md.update(ha2Bytes, 0, ha2Bytes.length);
                md.digest(digest, 0, digest.length);
                Logger.debug("digest is:" + TypeUtil.toString(digest, 16));
                Logger.debug("response is:" + this.response);
                Logger.debug("check pw" + TypeUtil.toString(digest, 16).equalsIgnoreCase(this.response));
                return TypeUtil.toString(digest, 16).equalsIgnoreCase(this.response);
            }
            catch (Exception e) {
                Logger.debug(e);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }
}

