/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import com.sun.javacard.Logger;
import com.sun.javacard.jcre.JCRuntime;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.thread.ThreadPool;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class BoundedThreadPool
extends AbstractLifeCycle
implements ThreadPool {
    static final int MAX_THREADS = JCRuntime.getIntProperty("webserver.threadpool.maxThreads", 255);
    static final int MIN_THREADS = JCRuntime.getIntProperty("webserver.threadpool.minThreads", 3);
    private static final int LOW_THREADS = JCRuntime.getIntProperty("webserver.threadpool.lowThreads", 25);
    static final int MAX_IDLE_TIME = JCRuntime.getIntProperty("webserver.threadpool.maxIdleTime", 60000);
    TransientReference<Vector<Thread>> blockedThreads = new TransientReference<Object>(null);
    TransientReference<Vector<Thread>> threads = new TransientReference<Object>(null);
    TransientReference<Vector<Thread>> idleThreads = new TransientReference<Object>(null);
    final Object lock = new Object();
    private final Object joinLock = new Object();
    boolean warned = false;
    long lastShrink;

    @Override
    public int getThreadsCount() {
        return this.threads.get().size();
    }

    @Override
    public int getIdleThreadsCount() {
        return this.idleThreads.get().size();
    }

    @Override
    public boolean isLowOnThreads() {
        return MAX_THREADS - this.getThreadsCount() + this.getIdleThreadsCount() < LOW_THREADS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch(Runnable job) {
        boolean queued = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning()) {
                return false;
            }
            int blockMs = MAX_IDLE_TIME;
            while (this.idleThreads.get().size() <= 0) {
                if (this.threads.get().size() < MAX_THREADS) {
                    this.newThread();
                    break;
                }
                if (!this.warned) {
                    this.warned = true;
                    JCRuntime.halt("Out of threads in Thread Pool");
                }
                if (blockMs < 0) {
                    return false;
                }
                try {
                    this.blockedThreads.get().addElement(Thread.currentThread());
                    this.lock.wait(blockMs);
                    blockMs = -1;
                }
                catch (InterruptedException ie) {}
                continue;
                finally {
                    this.blockedThreads.get().removeElement(Thread.currentThread());
                }
            }
            PoolThread thread = (PoolThread)this.idleThreads.get().elementAt(this.idleThreads.get().size() - 1);
            this.idleThreads.get().removeElementAt(this.idleThreads.get().size() - 1);
            thread.dispatch(job);
            queued = true;
        }
        if (this.idleThreads.get().size() == 0) {
            Thread.yield();
        }
        return queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        Object object = this.joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this.joinLock.wait(MAX_IDLE_TIME);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newThread() {
        Object object = this.lock;
        synchronized (object) {
            PoolThread thread = new PoolThread();
            this.threads.get().addElement(thread);
            this.idleThreads.get().addElement(thread);
            thread.start();
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (MAX_THREADS < MIN_THREADS || MIN_THREADS <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this.threads.set(new Vector());
        this.idleThreads.set(new Vector());
        this.blockedThreads.set(new Vector());
        for (int i = 0; i < MIN_THREADS; ++i) {
            this.newThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        Object object = this.joinLock;
        synchronized (object) {
            this.joinLock.notifyAll();
        }
    }

    @Override
    public void reset() {
        try {
            this.doStart();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class PoolThread
    extends Thread {
        private Runnable job = null;

        PoolThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                if (this.job != null || job == null) {
                    throw new IllegalStateException();
                }
                this.job = job;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Runnable job = null;
            try {
                while (BoundedThreadPool.this.isRunning()) {
                    Object object = BoundedThreadPool.this.lock;
                    // MONITORENTER : object
                    if (job != null) {
                        BoundedThreadPool.this.idleThreads.get().addElement(this);
                        if (BoundedThreadPool.this.idleThreads.get().size() >= MIN_THREADS) {
                            BoundedThreadPool.this.warned = false;
                        }
                        if (BoundedThreadPool.this.blockedThreads.get().size() > 0) {
                            BoundedThreadPool.this.blockedThreads.get().elementAt(0).interrupt();
                        }
                    }
                    // MONITOREXIT : object
                    object = this;
                    // MONITORENTER : object
                    job = null;
                    if (this.job == null) {
                        this.wait(MAX_IDLE_TIME);
                    }
                    job = this.job;
                    this.job = null;
                    // MONITOREXIT : object
                    if (BoundedThreadPool.this.isRunning() && job != null) {
                        job.run();
                    }
                    object = BoundedThreadPool.this.lock;
                    // MONITORENTER : object
                    if (job == null) {
                        long now = System.currentTimeMillis();
                        if (BoundedThreadPool.this.threads.get().size() > MAX_THREADS || BoundedThreadPool.this.idleThreads.get().size() - BoundedThreadPool.this.blockedThreads.get().size() > 0 && BoundedThreadPool.this.threads.get().size() > MIN_THREADS && now - BoundedThreadPool.this.lastShrink > (long)MAX_IDLE_TIME) {
                            BoundedThreadPool.this.lastShrink = now;
                            BoundedThreadPool.this.idleThreads.get().removeElement(this);
                            // MONITOREXIT : object
                            return;
                        }
                    }
                    // MONITOREXIT : object
                }
                return;
                catch (InterruptedException e) {
                    Logger.debug(e);
                    Object object = BoundedThreadPool.this.lock;
                    // MONITORENTER : object
                    BoundedThreadPool.this.idleThreads.get().removeElement(this);
                    BoundedThreadPool.this.threads.get().removeElement(this);
                    // MONITOREXIT : object
                    object = this;
                    // MONITORENTER : object
                    job = null;
                    job = this.job;
                    // MONITOREXIT : object
                    if (job == null) return;
                    if (!BoundedThreadPool.this.isRunning()) return;
                    BoundedThreadPool.this.dispatch(job);
                    return;
                }
            }
            finally {
                Object object = BoundedThreadPool.this.lock;
            }
        }
    }
}

