/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.CustomComponent;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.BitSet;

class DirectoryComponent
extends Safeptr {
    DirectoryComponent(byte[] data) {
        super(data, "Directory");
    }

    int appletCount() {
        return this.u1(29);
    }

    int arrayInitCount() {
        return this.u2(24);
    }

    int arrayInitSize() {
        return this.u2(26);
    }

    int componentSize(int n) {
        return this.u2((n - 1) * 2);
    }

    CustomComponent customComps() {
        return new CustomComponent(this.offset(31));
    }

    int customCount() {
        return this.u1(30);
    }

    int imageSize() {
        return this.u2(22);
    }

    int importCount() {
        return this.u1(28);
    }

    void verify() {
        int appcount;
        if (Verifier.verbose >= 2) {
            Messages.println("DirectoryComponent.100");
        }
        Safeptr[] comps = new Safeptr[]{null, Cap.Header, Cap.Directory, Cap.Applet, Cap.Import, Cap.ConstantPool, Cap.Class, Cap.Method, Cap.StaticField, Cap.ReferenceLocation, Cap.Export, Cap.Descriptor};
        String[] names = new String[]{null, "Header", "Directory", "Applet", "Import", "ConstantPool", "Class", "Method", "StaticField", "ReferenceLocation", "Export", "Descriptor"};
        int i = 1;
        while (i <= 11) {
            int size;
            Safeptr c = comps[i];
            int n = size = c == null ? 0 : c.size();
            if (size != this.componentSize(i)) {
                throw new VerifierError("DirectoryComponent.1", (Object)names[i], this.componentSize(i), size);
            }
            ++i;
        }
        if (this.imageSize() != Cap.StaticField.imageSize()) {
            throw new VerifierError("DirectoryComponent.2", Cap.StaticField.imageSize(), this.imageSize());
        }
        if (this.arrayInitCount() != Cap.StaticField.arrayInitCount()) {
            throw new VerifierError("DirectoryComponent.3", Cap.StaticField.arrayInitCount(), this.arrayInitCount());
        }
        int iaSize = 0;
        InitializedArray ia = Cap.StaticField.arrayInit();
        int i2 = Cap.StaticField.arrayInitCount();
        while (i2 > 0) {
            iaSize += ia.count();
            ia.next();
            --i2;
        }
        if (this.arrayInitSize() != iaSize) {
            throw new VerifierError("DirectoryComponent.4", iaSize, this.arrayInitSize());
        }
        if (this.importCount() != Cap.Import.count()) {
            throw new VerifierError("DirectoryComponent.5", Cap.Import.count(), this.importCount());
        }
        int n = appcount = Cap.Applet == null ? 0 : Cap.Applet.count();
        if (this.appletCount() != appcount) {
            throw new VerifierError("DirectoryComponent.6", appcount, this.appletCount());
        }
        BitSet ccompTags = new BitSet(256);
        CustomComponent p = this.customComps();
        int i3 = this.customCount();
        while (i3 > 0) {
            int tag = p.componentTag();
            if (tag < 128 || tag > 255) {
                throw new VerifierError("DirectoryComponent.8", tag);
            }
            if (ccompTags.get(tag)) {
                throw new VerifierError("DirectoryComponent.9", tag);
            }
            ccompTags.set(tag);
            if (!AID.isValid(p)) {
                throw new VerifierError("DirectoryComponent.12", p.AID_length(), tag);
            }
            if (!AID.sameRID(p, Cap.Header.thisPackage())) {
                throw new VerifierError("DirectoryComponent.13");
            }
            Safeptr cc = Cap.customComponent(tag);
            if (cc == null) {
                throw new VerifierError("DirectoryComponent.10", tag);
            }
            if (p.componentSize() != cc.size()) {
                throw new VerifierError("DirectoryComponent.11", tag, cc.size(), p.componentSize());
            }
            p.next();
            --i3;
        }
        if (!p.atComponentEnd()) {
            throw new VerifierError("DirectoryComponent.14");
        }
    }
}

