/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Statement;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCMethod
extends Member {
    protected MethodIdentifier methodIdentifier;
    protected JCClass parentClass;
    protected Vector statementVector = new Vector();
    protected ExceptionTable exceptionTable;
    protected int stack;
    protected int locals;
    private Hashtable symbolTable = new Hashtable();
    private int relPc;
    private int size;
    private boolean abstractError;
    private boolean nativeError;
    private boolean sizeError;
    public short nativeToken;

    public JCMethod(JCClass parentClass, int attributes, String name, int line) {
        super(attributes, name, line, 0);
        this.parentClass = parentClass;
        this.checkForInts(name);
    }

    public JCMethod(JCClass parentClass, int attributes, String name, MethodIdentifier id, int line) {
        this(parentClass, attributes, name, line);
        this.methodIdentifier = id;
    }

    public void addExceptionTableEntry(ExceptionTableEntry entry) {
        if (this.exceptionTable == null) {
            this.exceptionTable = new ExceptionTable(this);
        }
        this.exceptionTable.addExceptionEntry(entry);
    }

    protected void addStatement(Statement s) {
        if (Modifier.isAbstract(this.attributes) && !this.abstractError) {
            Object[] args = new Object[]{this.name};
            Msg.error("method.1", args);
            this.abstractError = true;
            return;
        }
        if (Modifier.isNative(this.attributes) && !this.nativeError) {
            Object[] args = new Object[]{this.name};
            Msg.error("method.2", args);
            this.nativeError = true;
            return;
        }
        this.statementVector.addElement(s);
        if (s.label != null) {
            String key = s.label.toLowerCase();
            if (this.symbolTable.containsKey(key)) {
                Object[] arguments = new Object[]{key, new Integer(s.lineNumber)};
                Msg.error("method.0", arguments);
            }
            this.symbolTable.put(key, new Integer(this.relPc));
        }
        s.relPc = this.relPc;
        this.relPc += s.size();
        this.size += s.size();
        if (this.size > Short.MAX_VALUE && !this.sizeError) {
            Object[] args = new Object[]{this.name};
            Msg.error("method.3", args);
            this.sizeError = true;
        }
    }

    private void checkForInts(String name) {
        char c;
        int index = 0;
        while (name.charAt(index++) != '(') {
        }
        while ((c = name.charAt(index++)) != ')') {
            switch (c) {
                case 'I': {
                    this.parentClass.getParentPackage().usesIntegers(true);
                    break;
                }
                case 'L': {
                    while (name.charAt(index++) != ';') {
                    }
                    break;
                }
            }
        }
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptionTable;
    }

    public byte[] getMethodHeader() {
        if (Modifier.isInterface(this.parentClass.getAttributes()) && Modifier.isAbstract(this.getAttributes())) {
            return new byte[0];
        }
        int params = this.getParams();
        byte[] header = this.stack > 15 || params > 15 || this.locals > 15 ? new byte[]{-128, (byte)this.stack, (byte)params, (byte)this.locals} : new byte[]{(byte)(this.stack & 0xF), (byte)(params << 4 | this.locals & 0xF)};
        if (Modifier.isAbstract(this.attributes)) {
            header[0] = (byte)(header[0] | 0x40);
        }
        if (Modifier.isNative(this.attributes)) {
            header[0] = (byte)(header[0] | 0x20);
        }
        return header;
    }

    public MethodIdentifier getMethodIdentifier() {
        return this.methodIdentifier;
    }

    public short getNativeToken() {
        return this.nativeToken;
    }

    public int getParams() {
        char c;
        int params = Modifier.isStatic(this.attributes) ? 0 : 1;
        int index = 0;
        while (this.name.charAt(index++) != '(') {
        }
        while ((c = this.name.charAt(index++)) != ')') {
            block0 : switch (c) {
                case 'B': 
                case 'S': 
                case 'Z': {
                    ++params;
                    break;
                }
                case 'I': {
                    params += 2;
                    break;
                }
                case '[': {
                    c = this.name.charAt(index++);
                    switch (c) {
                        case 'L': {
                            while (this.name.charAt(index++) != ';') {
                            }
                        }
                        case 'B': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            ++params;
                            break block0;
                        }
                    }
                    Assert.Assert(false, "getParams()");
                    break;
                }
                case 'L': {
                    while (this.name.charAt(index++) != ';') {
                    }
                    ++params;
                    break;
                }
                default: {
                    Assert.Assert(false, "getParams()");
                    break;
                }
            }
        }
        return params;
    }

    public JCClass getParentClass() {
        return this.parentClass;
    }

    protected void methodFixup() {
        if (this.symbolTable == null) {
            return;
        }
        Enumeration e = this.statementVector.elements();
        while (e.hasMoreElements()) {
            Statement s = (Statement)e.nextElement();
            s.methodFixup(this.symbolTable);
        }
        if (this.exceptionTable != null) {
            this.exceptionTable.fixup(this.symbolTable);
        }
        if (!Globals.debug) {
            this.symbolTable = null;
        }
    }

    protected void setLocals(int locals) {
        this.locals = locals;
    }

    public void setNativeToken(short tk) {
        this.nativeToken = tk;
    }

    protected void setStack(int stack) {
        this.stack = stack;
    }

    public int size() {
        if (Modifier.isInterface(this.parentClass.getAttributes()) && Modifier.isAbstract(this.getAttributes())) {
            return 0;
        }
        int params = this.getParams();
        if (this.stack > 15 || params > 15 || this.locals > 15) {
            return this.size + 4;
        }
        return this.size + 2;
    }

    public Enumeration statementElements() {
        return this.statementVector.elements();
    }

    public byte[] toByteArray() {
        if (this.size() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] methodHeader = this.getMethodHeader();
            dos.write(methodHeader, 0, methodHeader.length);
            Enumeration e = this.statementVector.elements();
            while (e.hasMoreElements()) {
                Statement smt = (Statement)e.nextElement();
                byte[] array = smt.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(".method " + super.toString());
        if (this.methodIdentifier != null) {
            sb.append(" <" + this.methodIdentifier + ">");
        }
        sb.append(" {" + Msg.eol);
        sb.append("method_header: " + Msg.toHexString(this.getMethodHeader()) + Msg.eol);
        Enumeration e = this.statementVector.elements();
        while (e.hasMoreElements()) {
            Statement c = (Statement)e.nextElement();
            sb.append(c);
        }
        if (this.exceptionTable != null) {
            sb.append(String.valueOf(String.valueOf(this.exceptionTable)) + Msg.eol);
        }
        if (Globals.debug && this.symbolTable != null) {
            sb.append("// " + this.symbolTable + Msg.eol);
        }
        sb.append("}" + Msg.eol);
        return sb.toString();
    }
}

