/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.RemoteInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.SafeptrError;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

class ClassComponent
extends Safeptr {
    static final int MAX_SUPER_INTERFACE_COUNT = 14;
    static Vector classNamesVector = new Vector();
    int classInterfaceInfoOffset;
    Safeptr signaturePool;
    private TreeSet allClasses;

    ClassComponent(byte[] byArray) {
        super(byArray, "Class");
    }

    ClassInfo infoOfs(int n) {
        return new ClassInfo(this.offset(n));
    }

    void verify() {
        if (Cap.capMinorVersion == 2) {
            int n = this.u2(0);
            this.classInterfaceInfoOffset = n + 2;
            this.signaturePool = this.offset(2);
            this.verifySignaturePool(n);
        }
        if (Verifier.verbose >= 2) {
            Messages.println("ClassComponent.100");
        }
        this.allClasses = new TreeSet();
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        int n = Cap.Descriptor.classCount();
        while (n > 0) {
            ClassInfo classInfo = this.infoOfs(classDescriptor.thisClass());
            try {
                this.verifyClass(classDescriptor, classInfo);
            }
            catch (SafeptrError safeptrError) {
                throw new SafeptrError("ClassComponent.1", classDescriptor, classInfo, safeptrError.getMessage(), safeptrError);
            }
            catch (VerifierError verifierError) {
                throw new VerifierError("ClassComponent.1", (Object)classDescriptor, (Object)classInfo, (Object)verifierError.getMessage());
            }
            --n;
            classDescriptor.next();
        }
        this.verifyOverlap();
        this.allClasses = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyClass(ClassDescriptor classDescriptor, ClassInfo classInfo) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        boolean bl;
        boolean bl2 = false;
        int n5 = 0;
        if (Cap.capMinorVersion == 2 ? (classInfo.flags() & 0xFFFFFFF1) != 0 : (classInfo.flags() & 0xFFFFFFF3) != 0) {
            throw new VerifierError("ClassComponent.2", classInfo.flags());
        }
        if ((classDescriptor.flags() & 0x40) != 0) {
            if ((classInfo.flags() & 8) == 0) {
                throw new VerifierError("ClassComponent.4");
            }
        } else if ((classInfo.flags() & 8) != 0) {
            throw new VerifierError("ClassComponent.7");
        }
        if (Cap.capMinorVersion == 2) {
            bl = (classInfo.flags() & 2) != 0;
            bl2 = false;
            bl2 = (classInfo.flags() & 8) != 0 ? Classref.isRemote(classDescriptor.thisClass(), false) : Classref.isRemote(classDescriptor.thisClass(), true);
            if (bl && !bl2) {
                throw new VerifierError("RemoteInfoError.2");
            }
            bl2 = bl;
            if (bl2 && !Cap.Header.hasName) {
                throw new VerifierError("RemoteInfoError.3");
            }
        }
        bl = (classInfo.flags() & 4) != 0;
        boolean bl3 = false;
        if (Classref.Shareable != -1) {
            bl3 = (classInfo.flags() & 8) != 0 ? Classref.extendsInterface(classDescriptor.thisClass(), Classref.Shareable) : Classref.implementsInterface(classDescriptor.thisClass(), Classref.Shareable);
        }
        if (bl != bl3) {
            throw new VerifierError("ClassComponent.3");
        }
        if ((classDescriptor.flags() & 0x40) != 0) {
            if (classInfo.interfaceCount() > 14) {
                throw new SafeptrError("ClassComponent.11", classDescriptor);
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            object = new TreeSet();
            n4 = 0;
            while (n4 < classInfo.interfaceCount()) {
                n3 = classInfo.superinterface(n4);
                n2 = Classref.checkAndGetAccessFlags(n3);
                if ((n2 & 0x40) == 0) {
                    throw new VerifierError("ClassComponent.5", n3);
                }
                if (!Classref.isExternal(n3) && n3 >= classDescriptor.thisClass()) {
                    throw new VerifierError("ClassComponent.41");
                }
                if (!treeSet.add(new Integer(n3))) {
                    throw new VerifierError("ClassComponent.51", n3);
                }
                this.addSuperInterfaces((TreeSet)object, n3);
                ++n4;
            }
            if (!treeSet.equals(object)) {
                throw new VerifierError("ClassComponent.50");
            }
            if (bl2) {
                RemoteInfo.verifyRemoteInterface(classDescriptor);
                n3 = classInfo.interfaceNamelength();
                if (n3 <= 0) throw new VerifierError("RemoteInfoError.10");
                Safeptr safeptr = classInfo.interfaceName();
                String string = ClassInfo.getStringFromBytes(n3, safeptr);
                if (string.indexOf("/") > -1 || !EfNames.validClassName(string)) {
                    throw new VerifierError("RemoteInfoError.11", string);
                }
                if (classNamesVector.contains(string)) {
                    throw new VerifierError("RemoteInfoError.14", string);
                }
                classNamesVector.add(string);
            }
        } else {
            int n6 = classInfo.superclass();
            if (n6 == 65535) {
                if (Cap.Import != null && Cap.Import.count() != 0 || classDescriptor.token() != 0) {
                    throw new VerifierError("ClassComponent.8");
                }
            } else {
                int n7 = Classref.checkAndGetAccessFlags(n6);
                if ((n7 & 0x40) != 0) {
                    throw new VerifierError("ClassComponent.9", n6);
                }
                if ((n7 & 0x10) != 0) {
                    throw new VerifierError("ClassComponent.10", n6);
                }
                if (!Classref.isExternal(n6) && n6 >= classDescriptor.thisClass()) {
                    throw new VerifierError("ClassComponent.42");
                }
            }
            object = new TreeSet();
            n4 = 0;
            while (n4 < classDescriptor.fieldCount()) {
                this.checkClassField(classInfo, classDescriptor.fieldDescr(n4), (TreeSet)object);
                ++n4;
            }
            this.verifyTokenOverlap((TreeSet)object, classInfo.declaredInstanceSize());
            this.checkFieldTokenOrdering(classDescriptor);
            if (classInfo.referenceCount() == 0 && classInfo.firstReferenceIndex() != 255) {
                throw new VerifierError("ClassComponent.38");
            }
            if (Classref.totalInstanceSize(classInfo.ofs) > 255) {
                throw new VerifierError("ClassComponent.53");
            }
            n3 = 0;
            while (n3 < classInfo.publicMethodCount()) {
                this.checkClassMethod(classDescriptor, classInfo, classInfo.publicMethod(n3), classInfo.publicMethodBase() + n3, false);
                ++n3;
            }
            n2 = 0;
            while (n2 < classInfo.packageMethodCount()) {
                this.checkClassMethod(classDescriptor, classInfo, classInfo.packageMethod(n2), classInfo.packageMethodBase() + n2 + 128, true);
                ++n2;
            }
            int n8 = 0;
            while (n8 < classInfo.publicMethodBase()) {
                this.checkClassMethod(classDescriptor, classInfo, 65535, n8, false);
                ++n8;
            }
            int n9 = 0;
            while (n9 < classInfo.packageMethodBase()) {
                this.checkClassMethod(classDescriptor, classInfo, 65535, n9 + 128, false);
                ++n9;
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            ImplementedInterface implementedInterface = classInfo.firstImplementedInterface();
            int n10 = classInfo.interfaceCount();
            while (n10 > 0) {
                if (!treeSet.add(new Integer(implementedInterface.interfaceImpl()))) {
                    throw new VerifierError("ClassComponent.52", implementedInterface.interfaceImpl());
                }
                ClassComponent.checkClassImplIntf(classDescriptor, classInfo, implementedInterface);
                --n10;
                implementedInterface.next();
            }
            int n11 = 0;
            while (n11 < classDescriptor.interfaceCount()) {
                if (!ClassComponent.classInfoImplementsInterface(classDescriptor.thisClass(), classDescriptor.interfaceRef(n11))) {
                    throw new VerifierError("ClassComponent.40", classDescriptor.interfaceRef(n11));
                }
                ++n11;
            }
            if ((classDescriptor.flags() & 0x80) == 0) {
                ClassComponent.checkMethodsAreProvided(classInfo, 0, classInfo.publicMethodBase(), classInfo.publicMethodCount(), classInfo.publicVtable());
                ClassComponent.checkMethodsAreProvided(classInfo, 128, classInfo.packageMethodBase(), classInfo.packageMethodCount(), classInfo.packageVtable());
            }
            if ((classInfo.flags() & 2) != 0) {
                ImplementedInterface implementedInterface2 = classInfo.firstImplementedInterface();
                int n12 = classInfo.interfaceCount();
                while (n12 > 0) {
                    implementedInterface2.next();
                    --n12;
                }
                int n13 = implementedInterface2.ofs;
                RemoteInfo remoteInfo = new RemoteInfo(this.offset(n13));
                remoteInfo.verifyRemoteInfo(classDescriptor, classInfo);
                n5 = remoteInfo.getRemoteDataLength();
            }
        }
        if ((classDescriptor.flags() & 0x40) == 0) {
            object = classInfo.firstImplementedInterface();
            n4 = classInfo.interfaceCount();
            while (n4 > 0) {
                ((ImplementedInterface)object).next();
                --n4;
            }
            n = ((ImplementedInterface)object).ofs + n5 - classInfo.ofs;
        } else {
            n = (classInfo.flags() & 2) == 0 ? 1 + 2 * classInfo.interfaceCount() : 2 + 2 * classInfo.interfaceCount() + classInfo.interfaceNamelength();
        }
        if (this.allClasses.add(new OffsetAndLength(classInfo.ofs, n))) return;
        throw new VerifierError("ClassComponent.31");
    }

    private void checkClassField(ClassInfo classInfo, FieldDescriptor fieldDescriptor, TreeSet treeSet) {
        if ((fieldDescriptor.flags() & 8) != 0) {
            return;
        }
        int n = fieldDescriptor.type();
        int n2 = n == 32773 ? 2 : 1;
        int n3 = fieldDescriptor.token();
        if (n3 + n2 > classInfo.declaredInstanceSize()) {
            throw new VerifierError("ClassComponent.13", n3, (Object)fieldDescriptor);
        }
        if ((n & 0x8000) == 0) {
            if (classInfo.firstReferenceIndex() == 255) {
                throw new VerifierError("ClassComponent.35");
            }
            if (n3 < classInfo.firstReferenceIndex() || n3 >= classInfo.firstReferenceIndex() + classInfo.referenceCount()) {
                throw new VerifierError("ClassComponent.36", n3, (Object)fieldDescriptor);
            }
        } else if ((fieldDescriptor.flags() & 5) == 0) {
            if (classInfo.firstReferenceIndex() != 255 && n3 < classInfo.firstReferenceIndex() + classInfo.referenceCount()) {
                throw new VerifierError("ClassComponent.48", n3, (Object)fieldDescriptor);
            }
        } else if (classInfo.firstReferenceIndex() != 255 && n3 + n2 > classInfo.firstReferenceIndex()) {
            throw new VerifierError("ClassComponent.49", n3, (Object)fieldDescriptor);
        }
        if (!treeSet.add(new OffsetAndLength(n3, n2))) {
            throw new VerifierError("ClassComponent.32", n3);
        }
    }

    void checkFieldTokenOrdering(ClassDescriptor classDescriptor) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        while (n3 < classDescriptor.fieldCount()) {
            FieldDescriptor fieldDescriptor = classDescriptor.fieldDescr(n3);
            if ((fieldDescriptor.flags() & 8) == 0) {
                int n4 = fieldDescriptor.token();
                if ((fieldDescriptor.flags() & 5) == 0) {
                    if (n4 <= n2) {
                        throw new VerifierError("ClassComponent.46", n4, (Object)fieldDescriptor);
                    }
                    if (n4 < n) {
                        n = n4;
                    }
                } else {
                    if (n4 >= n) {
                        throw new VerifierError("ClassComponent.47", n4, (Object)fieldDescriptor);
                    }
                    if (n4 > n2) {
                        n2 = n4;
                    }
                }
            }
            ++n3;
        }
    }

    private void checkClassMethod(ClassDescriptor classDescriptor, ClassInfo classInfo, int n, int n2, boolean bl) {
        if (n == 65535) {
            if (bl) {
                throw new VerifierError("ClassComponent.44");
            }
            MethodDescriptor methodDescriptor = Methodref.virtualMethodDescriptor(classDescriptor, n2);
            if (methodDescriptor != null && (methodDescriptor.flags() & 4) == 0) {
                throw new VerifierError("ClassComponent.45", n2);
            }
            return;
        }
        ClassAndMethodDescriptor classAndMethodDescriptor = Methodref.findDescr(n);
        ClassDescriptor classDescriptor2 = classAndMethodDescriptor.classDescr;
        MethodDescriptor methodDescriptor = classAndMethodDescriptor.methodDescr;
        if (!Classref.isSubclass(classDescriptor.thisClass(), classDescriptor2.thisClass())) {
            throw new VerifierError("ClassComponent.16", n);
        }
        if (methodDescriptor.token() != n2) {
            throw new VerifierError("ClassComponent.17", methodDescriptor.token(), n2);
        }
        if ((methodDescriptor.flags() & 0x88) != 0) {
            throw new VerifierError("ClassComponent.18");
        }
        MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(classInfo.superclass(), n2, false);
        if (methodTypeAndFlags != null && methodTypeAndFlags.offset != n) {
            TypeMethod typeMethod = TypeMethod.parseCap(Cap.TypeDescr.at(methodDescriptor.type()));
            if (!typeMethod.equals(methodTypeAndFlags.mty)) {
                throw new VerifierError("ClassComponent.19", (Object)typeMethod, (Object)methodTypeAndFlags.mty);
            }
            if ((methodTypeAndFlags.flags & 0x10) != 0) {
                throw new VerifierError("ClassComponent.20");
            }
            if (ClassComponent.visibilityLevel(methodDescriptor.flags()) < ClassComponent.visibilityLevel(methodTypeAndFlags.flags)) {
                throw new VerifierError("ClassComponent.30");
            }
        }
    }

    static void checkClassImplIntf(ClassDescriptor classDescriptor, ClassInfo classInfo, ImplementedInterface implementedInterface) {
        int n = implementedInterface.interfaceImpl();
        Classref.check(n);
        if (!Classref.implementsInterface(classDescriptor.thisClass(), n)) {
            throw new VerifierError("ClassComponent.21", n);
        }
        if (!Classref.isExternal(n) && n >= classDescriptor.thisClass()) {
            throw new VerifierError("ClassComponent.43");
        }
        int n2 = 0;
        while (n2 < implementedInterface.count()) {
            int n3 = implementedInterface.indexMethod(n2);
            MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(implementedInterface.interfaceImpl(), n2, false);
            if (methodTypeAndFlags == null) {
                throw new VerifierError("ClassComponent.22", implementedInterface.interfaceImpl());
            }
            MethodTypeAndFlags methodTypeAndFlags2 = Methodref.findByToken(classDescriptor.thisClass(), n3, false);
            if (methodTypeAndFlags2 == null) {
                throw new VerifierError("ClassComponent.23", implementedInterface.interfaceImpl());
            }
            if ((methodTypeAndFlags2.flags & 1) == 0) {
                throw new VerifierError("ClassComponent.24");
            }
            if (!methodTypeAndFlags2.mty.equals(methodTypeAndFlags.mty)) {
                throw new VerifierError("ClassComponent.25");
            }
            ++n2;
        }
        if (implementedInterface.count() != Classref.numberOfMethods(implementedInterface.interfaceImpl())) {
            throw new VerifierError("ClassComponent.39", implementedInterface.interfaceImpl());
        }
    }

    static boolean classInfoImplementsInterface(int n, int n2) {
        if (Classref.isExternal(n)) {
            EfClass efClass = Classref.checkExternal(n);
            int n3 = 0;
            while (n3 < efClass.supers.length) {
                if (Classref.refForName(efClass.interfaceName(n3)) == n2) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        ClassInfo classInfo = Cap.Class.infoOfs(n);
        ImplementedInterface implementedInterface = classInfo.firstImplementedInterface();
        int n4 = classInfo.interfaceCount();
        while (n4 > 0) {
            if (implementedInterface.interfaceImpl() == n2) {
                return true;
            }
            --n4;
            implementedInterface.next();
        }
        int n5 = classInfo.superclass();
        if (n5 == 65535) {
            return false;
        }
        return ClassComponent.classInfoImplementsInterface(n5, n2);
    }

    private static void checkMethodsAreProvided(ClassInfo classInfo, int n, int n2, int n3, Safeptr safeptr) {
        int n4 = 0;
        while (n4 < n2 + n3) {
            MethodTypeAndFlags methodTypeAndFlags;
            int n5 = n + n4;
            if (!(n4 >= n2 && safeptr.u2((n4 - n2) * 2) != 65535 || (methodTypeAndFlags = Methodref.findByToken(classInfo.ofs, n5, false)) != null && (methodTypeAndFlags.flags & 0x40) == 0)) {
                throw new VerifierError("ClassComponent.26", n5);
            }
            ++n4;
        }
    }

    private void verifyOverlap() {
        Safeptr safeptr = this.offset(this.classInterfaceInfoOffset);
        Iterator iterator = this.allClasses.iterator();
        while (iterator.hasNext()) {
            OffsetAndLength offsetAndLength = (OffsetAndLength)iterator.next();
            if (offsetAndLength.offset < safeptr.ofs) {
                throw new VerifierError("ClassComponent.27", safeptr.ofs);
            }
            if (offsetAndLength.offset > safeptr.ofs) {
                throw new VerifierError("ClassComponent.28", safeptr.ofs);
            }
            safeptr.advance(offsetAndLength.length);
        }
        if (!safeptr.atComponentEnd()) {
            throw new VerifierError("ClassComponent.29");
        }
    }

    private void verifyTokenOverlap(TreeSet treeSet, int n) {
        int n2 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            OffsetAndLength offsetAndLength = (OffsetAndLength)iterator.next();
            if (offsetAndLength.offset < n2) {
                throw new VerifierError("ClassComponent.33", n2);
            }
            if (offsetAndLength.offset > n2) {
                throw new VerifierError("ClassComponent.34", n2);
            }
            n2 += offsetAndLength.length;
        }
        if (n2 != n) {
            throw new VerifierError("ClassComponent.34", n2);
        }
    }

    private static int visibilityLevel(int n) {
        if ((n & 1) != 0) {
            return 3;
        }
        if ((n & 4) != 0) {
            return 2;
        }
        if ((n & 2) != 0) {
            return 0;
        }
        return 1;
    }

    private void addSuperInterfaces(TreeSet treeSet, int n) {
        treeSet.add(new Integer(n));
        if (Classref.isExternal(n)) {
            EfClass efClass = Classref.checkExternal(n);
            int n2 = 0;
            while (n2 < efClass.interfaces.length) {
                treeSet.add(new Integer(Classref.refForName(efClass.interfaceName(n2))));
                ++n2;
            }
        } else {
            ClassInfo classInfo = this.infoOfs(n);
            int n3 = 0;
            while (n3 < classInfo.interfaceCount()) {
                this.addSuperInterfaces(treeSet, classInfo.superinterface(n3));
                ++n3;
            }
        }
    }

    void verifySignaturePool(int n) {
        int n2 = 0;
        while (n2 < n) {
            RemoteInfo.verifyRemoteMethodTypeDescr(this.signaturePool.offset(n2));
            int n3 = this.signaturePool.u1(n2);
            n2 += (n3 + 1) / 2 + 1;
        }
    }
}

