/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.util.ZipUtils;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Library;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ClassicLibrary
extends Library {
    private Vector<File> exportFiles;
    private static Vector<String> mandatoryCAPComponentsForLibrary = new Vector<String>(){
        {
            this.addElement("export.cap");
            this.addElement("header.cap");
            this.addElement("directory.cap");
            this.addElement("import.cap");
            this.addElement("constantpool.cap");
            this.addElement("class.cap");
            this.addElement("method.cap");
            this.addElement("staticfield.cap");
            this.addElement("reflocation.cap");
            this.addElement("descriptor.cap");
        }
    };

    public ClassicLibrary(String path) {
        super(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInternal() {
        Attributes attributes;
        File f = new File(this.folder, "META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest();
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                manifest.read(fis);
            }
            catch (Exception ex) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        if (!"true".equalsIgnoreCase((attributes = manifest.getMainAttributes()).getValue("Sealed"))) {
            this.addError(ErrorKey.badValueForSealedAttribute, new Object[0]);
        }
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        Vector<File> vf = FileUtils.listAllFilesInFolder(this.folder, ".class");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < vf.size(); ++i) {
            f = vf.elementAt(i).getParentFile();
            if (f.getName().equals("proxy")) {
                f = f.getParentFile();
            }
            set.add(f.getAbsolutePath());
        }
        if (set.size() > 1) {
            this.addError(ErrorKey.OnlyOnePackageInClassicAppOrLib, new Object[0]);
            return;
        }
        vf = FileUtils.listAllFilesInFolder(this.folder, ".cap");
        for (File file : vf) {
            mandatoryCAPComponentsForLibrary.removeElement(file.getName().toLowerCase());
        }
        if (mandatoryCAPComponentsForLibrary.size() != 0) {
            this.addError(ErrorKey.missingCAPComponent, new Object[0]);
        }
        try {
            File tempCAPFile = File.createTempFile("abc", null);
            ZipUtils.zip(this.folder, tempCAPFile, false);
            FileInputStream fis = new FileInputStream(tempCAPFile);
            Verifier.verifyCap(fis, null, this.exportFiles);
        }
        catch (Exception e) {
            this.addError(ErrorKey.VerifierError, e.getMessage());
            return;
        }
    }

    public void setExportFiles(Vector<File> exportFiles) {
        this.exportFiles = exportFiles;
    }
}

